/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;

public class Transaction {
    private final TransactionId transactionId;
    private final List<MapUpdate<String, byte[]>> updates;
    private final State state;

    public Transaction(TransactionId transactionId, List<MapUpdate<String, byte[]>> updates) {
        this(transactionId, updates, State.PREPARING);
    }

    private Transaction(TransactionId transactionId, List<MapUpdate<String, byte[]>> updates, State state) {
        this.transactionId = transactionId;
        this.updates = ImmutableList.copyOf(updates);
        this.state = state;
    }

    public TransactionId id() {
        return this.transactionId;
    }

    public List<MapUpdate<String, byte[]>> updates() {
        return this.updates;
    }

    public State state() {
        return this.state;
    }

    public Transaction transition(State newState) {
        return new Transaction(this.transactionId, this.updates, newState);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("transactionId", (Object)this.transactionId).add("updates", this.updates).add("state", (Object)this.state).toString();
    }

    static enum State {
        PREPARING,
        PREPARED,
        COMMITTING,
        COMMITTED,
        ROLLINGBACK,
        ROLLEDBACK;

    }
}

