/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.resource.ResourceStateMachine;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.onlab.util.CountDownCompleter;
import org.onlab.util.Match;
import org.onosproject.store.primitives.resources.impl.AsyncConsistentMultimapCommands;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncConsistentSetMultimapState
extends ResourceStateMachine
implements SessionListener,
Snapshottable {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicLong globalVersion = new AtomicLong(1L);
    private final Map<String, MapEntryValue> backingMap = Maps.newHashMap();

    public AsyncConsistentSetMultimapState(Properties properties) {
        super(properties);
    }

    public void snapshot(SnapshotWriter writer) {
    }

    public void install(SnapshotReader reader) {
    }

    protected void configure(StateMachineExecutor executor) {
        executor.register(AsyncConsistentMultimapCommands.Size.class, this::size);
        executor.register(AsyncConsistentMultimapCommands.IsEmpty.class, this::isEmpty);
        executor.register(AsyncConsistentMultimapCommands.ContainsKey.class, this::containsKey);
        executor.register(AsyncConsistentMultimapCommands.ContainsValue.class, this::containsValue);
        executor.register(AsyncConsistentMultimapCommands.ContainsEntry.class, this::containsEntry);
        executor.register(AsyncConsistentMultimapCommands.Clear.class, this::clear);
        executor.register(AsyncConsistentMultimapCommands.KeySet.class, this::keySet);
        executor.register(AsyncConsistentMultimapCommands.Keys.class, this::keys);
        executor.register(AsyncConsistentMultimapCommands.Values.class, this::values);
        executor.register(AsyncConsistentMultimapCommands.Entries.class, this::entries);
        executor.register(AsyncConsistentMultimapCommands.Get.class, this::get);
        executor.register(AsyncConsistentMultimapCommands.RemoveAll.class, this::removeAll);
        executor.register(AsyncConsistentMultimapCommands.MultiRemove.class, this::multiRemove);
        executor.register(AsyncConsistentMultimapCommands.Put.class, this::put);
        executor.register(AsyncConsistentMultimapCommands.Replace.class, this::replace);
    }

    public void delete() {
        super.delete();
    }

    protected int size(Commit<? extends AsyncConsistentMultimapCommands.Size> commit) {
        try {
            int n = this.backingMap.values().stream().map(valueCollection -> valueCollection.values().size()).collect(Collectors.summingInt(size -> size));
            return n;
        }
        finally {
            commit.close();
        }
    }

    protected boolean isEmpty(Commit<? extends AsyncConsistentMultimapCommands.IsEmpty> commit) {
        try {
            boolean bl = this.backingMap.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected boolean containsKey(Commit<? extends AsyncConsistentMultimapCommands.ContainsKey> commit) {
        try {
            boolean bl = this.backingMap.containsKey(((AsyncConsistentMultimapCommands.ContainsKey)commit.operation()).key());
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsValue(Commit<? extends AsyncConsistentMultimapCommands.ContainsValue> commit) {
        try {
            Match match = Match.ifValue((Object)((AsyncConsistentMultimapCommands.ContainsValue)commit.operation()).value());
            boolean bl = this.backingMap.values().stream().anyMatch(valueList -> valueList.values().stream().anyMatch(byteValue -> match.matches(byteValue)));
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsEntry(Commit<? extends AsyncConsistentMultimapCommands.ContainsEntry> commit) {
        try {
            MapEntryValue entryValue = this.backingMap.get(((AsyncConsistentMultimapCommands.ContainsEntry)commit.operation()).key());
            if (entryValue == null) {
                boolean bl = false;
                return bl;
            }
            Match valueMatch = Match.ifValue((Object)((AsyncConsistentMultimapCommands.ContainsEntry)commit.operation()).value());
            boolean bl = entryValue.values().stream().anyMatch(byteValue -> valueMatch.matches(byteValue));
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected void clear(Commit<? extends AsyncConsistentMultimapCommands.Clear> commit) {
        try {
            this.backingMap.clear();
        }
        finally {
            commit.close();
        }
    }

    protected Set<String> keySet(Commit<? extends AsyncConsistentMultimapCommands.KeySet> commit) {
        try {
            Set<String> set = this.backingMap.keySet();
            return set;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Multiset<String> keys(Commit<? extends AsyncConsistentMultimapCommands.Keys> commit) {
        try {
            HashMultiset keys = HashMultiset.create();
            this.backingMap.forEach((arg_0, arg_1) -> AsyncConsistentSetMultimapState.lambda$keys$141((Multiset)keys, arg_0, arg_1));
            HashMultiset hashMultiset = keys;
            return hashMultiset;
        }
        finally {
            commit.close();
        }
    }

    protected Multiset<byte[]> values(Commit<? extends AsyncConsistentMultimapCommands.Values> commit) {
        try {
            Multiset multiset = (Multiset)this.backingMap.values().stream().collect(new HashMultisetValueCollector());
            return multiset;
        }
        finally {
            commit.close();
        }
    }

    protected Collection<Map.Entry<String, byte[]>> entries(Commit<? extends AsyncConsistentMultimapCommands.Entries> commit) {
        try {
            Collection collection = this.backingMap.entrySet().stream().collect(new EntrySetCollector());
            return collection;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Versioned<Collection<? extends byte[]>> get(Commit<? extends AsyncConsistentMultimapCommands.Get> commit) {
        try {
            MapEntryValue mapEntryValue = this.backingMap.get(((AsyncConsistentMultimapCommands.Get)commit.operation()).key());
            Versioned<Collection<? extends byte[]>> versioned = this.toVersioned(this.backingMap.get(((AsyncConsistentMultimapCommands.Get)commit.operation()).key()));
            return versioned;
        }
        finally {
            commit.close();
        }
    }

    protected Versioned<Collection<? extends byte[]>> removeAll(Commit<? extends AsyncConsistentMultimapCommands.RemoveAll> commit) {
        if (!this.backingMap.containsKey(((AsyncConsistentMultimapCommands.RemoveAll)commit.operation()).key())) {
            commit.close();
            return new Versioned((Object)Sets.newHashSet(), -1L);
        }
        return this.backingMap.get(((AsyncConsistentMultimapCommands.RemoveAll)commit.operation()).key()).addCommit(commit);
    }

    protected boolean multiRemove(Commit<? extends AsyncConsistentMultimapCommands.MultiRemove> commit) {
        if (!this.backingMap.containsKey(((AsyncConsistentMultimapCommands.MultiRemove)commit.operation()).key())) {
            commit.close();
            return false;
        }
        return this.backingMap.get(((AsyncConsistentMultimapCommands.MultiRemove)commit.operation()).key()).addCommit(commit) != null;
    }

    protected boolean put(Commit<? extends AsyncConsistentMultimapCommands.Put> commit) {
        if (((AsyncConsistentMultimapCommands.Put)commit.operation()).values().isEmpty()) {
            return false;
        }
        if (!this.backingMap.containsKey(((AsyncConsistentMultimapCommands.Put)commit.operation()).key())) {
            this.backingMap.put(((AsyncConsistentMultimapCommands.Put)commit.operation()).key(), new NonTransactionalCommit(1L));
        }
        return this.backingMap.get(((AsyncConsistentMultimapCommands.Put)commit.operation()).key()).addCommit(commit) != null;
    }

    protected Versioned<Collection<? extends byte[]>> replace(Commit<? extends AsyncConsistentMultimapCommands.Replace> commit) {
        if (!this.backingMap.containsKey(((AsyncConsistentMultimapCommands.Replace)commit.operation()).key())) {
            this.backingMap.put(((AsyncConsistentMultimapCommands.Replace)commit.operation()).key(), new NonTransactionalCommit(1L));
        }
        return this.backingMap.get(((AsyncConsistentMultimapCommands.Replace)commit.operation()).key()).addCommit(commit);
    }

    public void register(ServerSession session) {
        super.register(session);
    }

    public void unregister(ServerSession session) {
        super.unregister(session);
    }

    public void expire(ServerSession session) {
        super.expire(session);
    }

    public void close(ServerSession session) {
        super.close(session);
    }

    private Versioned<Collection<? extends byte[]>> toVersioned(MapEntryValue value) {
        return value == null ? new Versioned((Object)Lists.newArrayList(), -1L) : new Versioned(value.values(), value.version());
    }

    private static /* synthetic */ void lambda$keys$141(Multiset keys, String key, MapEntryValue mapEntryValue) {
        keys.add((Object)key, mapEntryValue.values().size());
    }

    private class ByteArrayComparator
    implements Comparator<byte[]> {
        private ByteArrayComparator() {
        }

        @Override
        public int compare(byte[] o1, byte[] o2) {
            if (Arrays.equals(o1, o2)) {
                return 0;
            }
            for (int i = 0; i < o1.length && i < o2.length; ++i) {
                if (o1[i] < o2[i]) {
                    return -1;
                }
                if (o1[i] <= o2[i]) continue;
                return 1;
            }
            return o1.length > o2.length ? 1 : -1;
        }
    }

    private class EntrySetCollector
    implements Collector<Map.Entry<String, MapEntryValue>, Set<Map.Entry<String, byte[]>>, Set<Map.Entry<String, byte[]>>> {
        private Set<Map.Entry<String, byte[]>> set = null;

        private EntrySetCollector() {
        }

        @Override
        public Supplier<Set<Map.Entry<String, byte[]>>> supplier() {
            return new Supplier<Set<Map.Entry<String, byte[]>>>(){

                @Override
                public Set<Map.Entry<String, byte[]>> get() {
                    if (EntrySetCollector.this.set == null) {
                        EntrySetCollector.this.set = Sets.newHashSet();
                    }
                    return EntrySetCollector.this.set;
                }
            };
        }

        @Override
        public BiConsumer<Set<Map.Entry<String, byte[]>>, Map.Entry<String, MapEntryValue>> accumulator() {
            return (set, entry) -> ((MapEntryValue)entry.getValue()).values().forEach(byteValue -> set.add(Maps.immutableEntry(entry.getKey(), (Object)byteValue)));
        }

        @Override
        public BinaryOperator<Set<Map.Entry<String, byte[]>>> combiner() {
            return (setOne, setTwo) -> {
                setOne.addAll(setTwo);
                return setOne;
            };
        }

        @Override
        public Function<Set<Map.Entry<String, byte[]>>, Set<Map.Entry<String, byte[]>>> finisher() {
            return unused -> this.set;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED);
        }
    }

    private class HashMultisetValueCollector
    implements Collector<MapEntryValue, HashMultiset<byte[]>, HashMultiset<byte[]>> {
        private HashMultiset<byte[]> multiset = null;

        private HashMultisetValueCollector() {
        }

        @Override
        public Supplier<HashMultiset<byte[]>> supplier() {
            return new Supplier<HashMultiset<byte[]>>(){

                @Override
                public HashMultiset<byte[]> get() {
                    if (HashMultisetValueCollector.this.multiset == null) {
                        HashMultisetValueCollector.this.multiset = HashMultiset.create();
                    }
                    return HashMultisetValueCollector.this.multiset;
                }
            };
        }

        @Override
        public BiConsumer<HashMultiset<byte[]>, MapEntryValue> accumulator() {
            return (multiset, mapEntryValue) -> multiset.addAll(mapEntryValue.values());
        }

        @Override
        public BinaryOperator<HashMultiset<byte[]>> combiner() {
            return (setOne, setTwo) -> {
                setOne.addAll((Collection)setTwo);
                return setOne;
            };
        }

        @Override
        public Function<HashMultiset<byte[]>, HashMultiset<byte[]>> finisher() {
            return unused -> this.multiset;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED);
        }
    }

    private class NonTransactionalCommit
    implements MapEntryValue {
        private long version;
        private final TreeMap<byte[], CountDownCompleter<Commit>> valueCountdownMap;
        private final HashMultimap<Commit, CountDownCompleter<Commit>> additiveToRemovalCommits;

        public NonTransactionalCommit(long version) {
            this.valueCountdownMap = Maps.newTreeMap((Comparator)new ByteArrayComparator());
            this.additiveToRemovalCommits = HashMultimap.create();
            this.version = AsyncConsistentSetMultimapState.this.globalVersion.get();
        }

        @Override
        public Collection<? extends byte[]> values() {
            return this.valueCountdownMap.keySet();
        }

        @Override
        public long version() {
            return this.version;
        }

        @Override
        public void discard() {
            this.valueCountdownMap.values().forEach(completer -> ((Commit)completer.object()).close());
        }

        @Override
        public Versioned<Collection<? extends byte[]>> addCommit(Commit<? extends AsyncConsistentMultimapCommands.MultimapCommand> commit) {
            Preconditions.checkNotNull(commit);
            Preconditions.checkNotNull((Object)commit.operation());
            if (commit.operation() instanceof AsyncConsistentMultimapCommands.Put) {
                TreeSet valuesToAdd = Sets.newTreeSet((Comparator)new ByteArrayComparator());
                ((AsyncConsistentMultimapCommands.Put)commit.operation()).values().forEach(value -> {
                    if (!this.valueCountdownMap.containsKey(value)) {
                        valuesToAdd.add(value);
                    }
                });
                if (valuesToAdd.isEmpty()) {
                    commit.close();
                    return null;
                }
                CountDownCompleter completer = new CountDownCompleter(commit, (long)valuesToAdd.size(), c -> {
                    if (this.additiveToRemovalCommits.containsKey(c)) {
                        this.additiveToRemovalCommits.get(c).forEach(countdown -> countdown.countDown());
                        this.additiveToRemovalCommits.removeAll(c);
                    }
                    c.close();
                });
                Versioned retVersion = new Versioned((Object)valuesToAdd, this.version);
                valuesToAdd.forEach(value -> this.valueCountdownMap.put((byte[])value, (CountDownCompleter<Commit>)completer));
                ++this.version;
                return retVersion;
            }
            if (commit.operation() instanceof AsyncConsistentMultimapCommands.Replace) {
                HashSet removedValues = Sets.newHashSet();
                removedValues.addAll(this.valueCountdownMap.keySet());
                Versioned retVersion = new Versioned((Object)removedValues, this.version);
                this.valueCountdownMap.values().forEach(countdown -> countdown.countDown());
                this.valueCountdownMap.clear();
                TreeSet valuesToAdd = Sets.newTreeSet((Comparator)new ByteArrayComparator());
                ((AsyncConsistentMultimapCommands.Replace)commit.operation()).values().forEach(value -> valuesToAdd.add(value));
                if (valuesToAdd.isEmpty()) {
                    this.version = AsyncConsistentSetMultimapState.this.globalVersion.incrementAndGet();
                    AsyncConsistentSetMultimapState.this.backingMap.remove(((AsyncConsistentMultimapCommands.Replace)commit.operation()).key());
                    commit.close();
                    return retVersion;
                }
                CountDownCompleter completer = new CountDownCompleter(commit, (long)valuesToAdd.size(), c -> {
                    if (this.additiveToRemovalCommits.containsKey(c)) {
                        this.additiveToRemovalCommits.get(c).forEach(countdown -> countdown.countDown());
                        this.additiveToRemovalCommits.removeAll(c);
                    }
                    c.close();
                });
                valuesToAdd.forEach(value -> this.valueCountdownMap.put((byte[])value, (CountDownCompleter<Commit>)completer));
                this.version = AsyncConsistentSetMultimapState.this.globalVersion.incrementAndGet();
                return retVersion;
            }
            if (commit.operation() instanceof AsyncConsistentMultimapCommands.RemoveAll) {
                HashSet removed = Sets.newHashSet();
                removed.addAll(this.valueCountdownMap.keySet());
                Versioned retVersion = new Versioned((Object)removed, this.version);
                this.valueCountdownMap.values().forEach(countdown -> countdown.countDown());
                this.valueCountdownMap.clear();
                String key = ((AsyncConsistentMultimapCommands.RemoveAll)commit.operation()).key();
                commit.close();
                this.version = AsyncConsistentSetMultimapState.this.globalVersion.incrementAndGet();
                AsyncConsistentSetMultimapState.this.backingMap.remove(key);
                return retVersion;
            }
            if (commit.operation() instanceof AsyncConsistentMultimapCommands.MultiRemove) {
                HashSet removed = Sets.newHashSet();
                HashSet commitsRemovedFrom = Sets.newHashSet();
                ((AsyncConsistentMultimapCommands.MultiRemove)commit.operation()).values().forEach(value -> {
                    if (this.valueCountdownMap.containsKey(value)) {
                        removed.add(value);
                        commitsRemovedFrom.add(this.valueCountdownMap.get(value).object());
                    }
                });
                if (removed.isEmpty()) {
                    commit.close();
                    return null;
                }
                CountDownCompleter completer = new CountDownCompleter(commit, (long)commitsRemovedFrom.size(), c -> c.close());
                commitsRemovedFrom.forEach(commitRemovedFrom -> this.additiveToRemovalCommits.put(commitRemovedFrom, (Object)completer));
                String removedKey = ((AsyncConsistentMultimapCommands.MultiRemove)commit.operation()).key();
                removed.forEach(removedValue -> this.valueCountdownMap.remove(removedValue).countDown());
                Versioned retVersion = new Versioned((Object)removed, this.version);
                this.version = AsyncConsistentSetMultimapState.this.globalVersion.incrementAndGet();
                if (this.valueCountdownMap.isEmpty()) {
                    AsyncConsistentSetMultimapState.this.backingMap.remove(removedKey);
                }
                return retVersion;
            }
            throw new IllegalArgumentException();
        }
    }

    private static interface MapEntryValue {
        public Collection<? extends byte[]> values();

        public long version();

        public void discard();

        public Versioned<Collection<? extends byte[]>> addCommit(Commit<? extends AsyncConsistentMultimapCommands.MultimapCommand> var1);
    }
}

