/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ResourceTypeInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Change;
import org.onosproject.store.primitives.resources.impl.AtomixLeaderElectorCommands;
import org.onosproject.store.primitives.resources.impl.AtomixLeaderElectorFactory;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.DistributedPrimitive;

@ResourceTypeInfo(id=-152, factory=AtomixLeaderElectorFactory.class)
public class AtomixLeaderElector
extends AbstractResource<AtomixLeaderElector>
implements AsyncLeaderElector {
    private final Set<Consumer<DistributedPrimitive.Status>> statusChangeListeners = Sets.newCopyOnWriteArraySet();
    private final Set<Consumer<Change<Leadership>>> leadershipChangeListeners = Sets.newCopyOnWriteArraySet();
    private final Consumer<Change<Leadership>> cacheUpdater;
    private final Consumer<DistributedPrimitive.Status> statusListener;
    public static final String CHANGE_SUBJECT = "leadershipChangeEvents";
    private final LoadingCache<String, CompletableFuture<Leadership>> cache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(topic -> this.client.submit((Query)new AtomixLeaderElectorCommands.GetLeadership((String)topic))));

    public AtomixLeaderElector(CopycatClient client, Properties properties) {
        super(client, properties);
        this.cacheUpdater = change -> {
            Leadership leadership = (Leadership)change.newValue();
            this.cache.put((Object)leadership.topic(), CompletableFuture.completedFuture(leadership));
        };
        this.statusListener = status -> {
            if (status == DistributedPrimitive.Status.SUSPENDED || status == DistributedPrimitive.Status.INACTIVE) {
                this.cache.invalidateAll();
            }
        };
        this.addStatusChangeListener(this.statusListener);
    }

    public CompletableFuture<Void> destroy() {
        this.removeStatusChangeListener(this.statusListener);
        return this.removeChangeListener(this.cacheUpdater);
    }

    public String name() {
        return null;
    }

    public CompletableFuture<AtomixLeaderElector> open() {
        return super.open().thenApply(result -> {
            this.client.onStateChange(state -> {
                if (state == CopycatClient.State.CONNECTED && this.isListening()) {
                    this.client.submit((Command)new AtomixLeaderElectorCommands.Listen());
                }
            });
            this.client.onEvent(CHANGE_SUBJECT, this::handleEvent);
            return result;
        });
    }

    public CompletableFuture<AtomixLeaderElector> setupCache() {
        return this.addChangeListener(this.cacheUpdater).thenApply(v -> this);
    }

    private void handleEvent(List<Change<Leadership>> changes) {
        changes.forEach(change -> this.leadershipChangeListeners.forEach(l -> l.accept(change)));
    }

    public CompletableFuture<Leadership> run(String topic, NodeId nodeId) {
        return this.client.submit((Command)new AtomixLeaderElectorCommands.Run(topic, nodeId)).whenComplete((r, e) -> this.cache.invalidate((Object)topic));
    }

    public CompletableFuture<Void> withdraw(String topic) {
        return this.client.submit((Command)new AtomixLeaderElectorCommands.Withdraw(topic)).whenComplete((r, e) -> this.cache.invalidate((Object)topic));
    }

    public CompletableFuture<Boolean> anoint(String topic, NodeId nodeId) {
        return this.client.submit((Command)new AtomixLeaderElectorCommands.Anoint(topic, nodeId)).whenComplete((r, e) -> this.cache.invalidate((Object)topic));
    }

    public CompletableFuture<Boolean> promote(String topic, NodeId nodeId) {
        return this.client.submit((Command)new AtomixLeaderElectorCommands.Promote(topic, nodeId)).whenComplete((r, e) -> this.cache.invalidate((Object)topic));
    }

    public CompletableFuture<Void> evict(NodeId nodeId) {
        return this.client.submit((Command)new AtomixLeaderElectorCommands.Evict(nodeId));
    }

    public CompletableFuture<Leadership> getLeadership(String topic) {
        return ((CompletableFuture)this.cache.getUnchecked((Object)topic)).whenComplete((r, e) -> {
            if (e != null) {
                this.cache.invalidate((Object)topic);
            }
        });
    }

    public CompletableFuture<Map<String, Leadership>> getLeaderships() {
        return this.client.submit((Query)new AtomixLeaderElectorCommands.GetAllLeaderships());
    }

    public CompletableFuture<Set<String>> getElectedTopics(NodeId nodeId) {
        return this.client.submit((Query)new AtomixLeaderElectorCommands.GetElectedTopics(nodeId));
    }

    public synchronized CompletableFuture<Void> addChangeListener(Consumer<Change<Leadership>> consumer) {
        if (this.leadershipChangeListeners.isEmpty()) {
            return this.client.submit((Command)new AtomixLeaderElectorCommands.Listen()).thenRun(() -> this.leadershipChangeListeners.add(consumer));
        }
        this.leadershipChangeListeners.add(consumer);
        return CompletableFuture.completedFuture(null);
    }

    public synchronized CompletableFuture<Void> removeChangeListener(Consumer<Change<Leadership>> consumer) {
        if (this.leadershipChangeListeners.remove(consumer) && this.leadershipChangeListeners.isEmpty()) {
            return this.client.submit((Command)new AtomixLeaderElectorCommands.Unlisten()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.statusChangeListeners.add(listener);
    }

    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.statusChangeListeners.remove(listener);
    }

    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return ImmutableSet.copyOf(this.statusChangeListeners);
    }

    private boolean isListening() {
        return !this.leadershipChangeListeners.isEmpty();
    }
}

