/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.function.Function;
import org.onosproject.store.primitives.impl.CachingAsyncConsistentMap;
import org.onosproject.store.primitives.impl.DefaultAsyncDistributedSet;
import org.onosproject.store.primitives.impl.MeteredAsyncConsistentMap;
import org.onosproject.store.primitives.impl.TranscodingAsyncConsistentMap;
import org.onosproject.store.primitives.impl.TranscodingAsyncConsistentTreeMap;
import org.onosproject.store.primitives.impl.UnmodifiableAsyncConsistentMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.AsyncConsistentTreeMap;
import org.onosproject.store.service.AsyncDistributedSet;

public final class DistributedPrimitives {
    private DistributedPrimitives() {
    }

    public static <E> AsyncDistributedSet<E> newSetFromMap(AsyncConsistentMap<E, Boolean> map) {
        return new DefaultAsyncDistributedSet<E>(map, map.name(), true);
    }

    public static <K, V> AsyncConsistentMap<K, V> newMeteredMap(AsyncConsistentMap<K, V> map) {
        return new MeteredAsyncConsistentMap<K, V>(map);
    }

    public static <K, V> AsyncConsistentMap<K, V> newCachingMap(AsyncConsistentMap<K, V> map) {
        return new CachingAsyncConsistentMap<K, V>(map);
    }

    public static <K, V> AsyncConsistentMap<K, V> newUnmodifiableMap(AsyncConsistentMap<K, V> map) {
        return new UnmodifiableAsyncConsistentMap<K, V>(map);
    }

    public static <K1, V1, K2, V2> AsyncConsistentMap<K1, V1> newTranscodingMap(AsyncConsistentMap<K2, V2> map, Function<K1, K2> keyEncoder, Function<K2, K1> keyDecoder, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        return new TranscodingAsyncConsistentMap<K1, V1, K2, V2>(map, keyEncoder, keyDecoder, valueEncoder, valueDecoder);
    }

    public static <V1, V2> AsyncConsistentTreeMap<V1> newTranscodingTreeMap(AsyncConsistentTreeMap<V2> map, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        return new TranscodingAsyncConsistentTreeMap<V1, V2>(map, valueEncoder, valueDecoder);
    }
}

