/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.PartitionId;
import org.onosproject.persistence.PersistenceService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.primitives.DistributedPrimitiveCreator;
import org.onosproject.store.primitives.PartitionAdminService;
import org.onosproject.store.primitives.PartitionService;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.DefaultAtomicCounterBuilder;
import org.onosproject.store.primitives.impl.DefaultAtomicValueBuilder;
import org.onosproject.store.primitives.impl.DefaultConsistentMapBuilder;
import org.onosproject.store.primitives.impl.DefaultConsistentTreeMapBuilder;
import org.onosproject.store.primitives.impl.DefaultDistributedSetBuilder;
import org.onosproject.store.primitives.impl.DefaultDistributedTopic;
import org.onosproject.store.primitives.impl.DefaultLeaderElectorBuilder;
import org.onosproject.store.primitives.impl.DefaultTransactionContextBuilder;
import org.onosproject.store.primitives.impl.EventuallyConsistentMapBuilderImpl;
import org.onosproject.store.primitives.impl.FederatedDistributedPrimitiveCreator;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.impl.TransactionCoordinator;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.AtomicCounterBuilder;
import org.onosproject.store.service.AtomicValueBuilder;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.ConsistentTreeMapBuilder;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.EventuallyConsistentMapBuilder;
import org.onosproject.store.service.LeaderElectorBuilder;
import org.onosproject.store.service.MapInfo;
import org.onosproject.store.service.PartitionInfo;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageAdminService;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Topic;
import org.onosproject.store.service.TransactionContextBuilder;
import org.onosproject.store.service.WorkQueue;
import org.onosproject.store.service.WorkQueueStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class StorageManager
implements StorageService,
StorageAdminService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PersistenceService persistenceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PartitionService partitionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PartitionAdminService partitionAdminService;
    private final Supplier<TransactionId> transactionIdGenerator = () -> TransactionId.from((String)UUID.randomUUID().toString());
    private DistributedPrimitiveCreator federatedPrimitiveCreator;
    private AsyncConsistentMap<TransactionId, Transaction.State> transactions;
    private TransactionCoordinator transactionCoordinator;

    @Activate
    public void activate() {
        HashMap partitionMap = Maps.newHashMap();
        this.partitionService.getAllPartitionIds().stream().filter(id -> !id.equals((Object)PartitionId.from((int)0))).forEach(id -> partitionMap.put(id, this.partitionService.getDistributedPrimitiveCreator(id)));
        this.federatedPrimitiveCreator = new FederatedDistributedPrimitiveCreator(partitionMap);
        this.transactions = ((ConsistentMapBuilder)((ConsistentMapBuilder)this.consistentMapBuilder().withName("onos-transactions")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API, (Class[])new Class[]{Transaction.class, Transaction.State.class}))).buildAsyncMap();
        this.transactionCoordinator = new TransactionCoordinator(this.transactions);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public <K, V> EventuallyConsistentMapBuilder<K, V> eventuallyConsistentMapBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new EventuallyConsistentMapBuilderImpl(this.clusterService, this.clusterCommunicator, this.persistenceService);
    }

    public <K, V> ConsistentMapBuilder<K, V> consistentMapBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new DefaultConsistentMapBuilder(this.federatedPrimitiveCreator);
    }

    public <V> ConsistentTreeMapBuilder<V> consistentTreeMapBuilder() {
        return new DefaultConsistentTreeMapBuilder(this.federatedPrimitiveCreator);
    }

    public <E> DistributedSetBuilder<E> setBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new DefaultDistributedSetBuilder(() -> this.consistentMapBuilder());
    }

    public AtomicCounterBuilder atomicCounterBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new DefaultAtomicCounterBuilder(this.federatedPrimitiveCreator);
    }

    public <V> AtomicValueBuilder<V> atomicValueBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        Supplier<ConsistentMapBuilder<String, byte[]>> mapBuilderSupplier = () -> (ConsistentMapBuilder)((ConsistentMapBuilder)this.consistentMapBuilder().withName("onos-atomic-values")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.BASIC));
        return new DefaultAtomicValueBuilder(mapBuilderSupplier);
    }

    public TransactionContextBuilder transactionContextBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new DefaultTransactionContextBuilder(this.transactionIdGenerator.get(), this.federatedPrimitiveCreator, this.transactionCoordinator);
    }

    public LeaderElectorBuilder leaderElectorBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new DefaultLeaderElectorBuilder(this.federatedPrimitiveCreator);
    }

    public <E> WorkQueue<E> getWorkQueue(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return this.federatedPrimitiveCreator.newWorkQueue(name, serializer);
    }

    public <V> AsyncDocumentTree<V> getDocumentTree(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return this.federatedPrimitiveCreator.newAsyncDocumentTree(name, serializer);
    }

    public List<MapInfo> getMapInfo() {
        return this.listMapInfo(this.federatedPrimitiveCreator);
    }

    public Map<String, Long> getCounters() {
        ConcurrentMap counters = Maps.newConcurrentMap();
        this.federatedPrimitiveCreator.getAsyncAtomicCounterNames().forEach(name -> counters.put(name, this.federatedPrimitiveCreator.newAsyncCounter(name).asAtomicCounter().get()));
        return counters;
    }

    public Map<String, WorkQueueStats> getQueueStats() {
        ConcurrentMap workQueueStats = Maps.newConcurrentMap();
        this.federatedPrimitiveCreator.getWorkQueueNames().forEach(name -> {
            WorkQueueStats cfr_ignored_0 = (WorkQueueStats)workQueueStats.put(name, this.federatedPrimitiveCreator.newWorkQueue(name, Serializer.using((KryoNamespace)KryoNamespaces.BASIC)).stats().join());
        });
        return workQueueStats;
    }

    public List<PartitionInfo> getPartitionInfo() {
        return this.partitionAdminService.partitionInfo();
    }

    public Collection<TransactionId> getPendingTransactions() {
        return (Collection)Futures.getUnchecked((Future)this.transactions.keySet());
    }

    private List<MapInfo> listMapInfo(DistributedPrimitiveCreator creator) {
        Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.BASIC);
        return creator.getAsyncConsistentMapNames().stream().map(name -> {
            ConsistentMap map = creator.newAsyncConsistentMap(name, serializer).asConsistentMap();
            return new MapInfo(name, map.size());
        }).collect(Collectors.toList());
    }

    public <T> Topic<T> getTopic(String name, Serializer serializer) {
        AsyncAtomicValue atomicValue = (AsyncAtomicValue)((AtomicValueBuilder)((AtomicValueBuilder)this.atomicValueBuilder().withName("topic-" + name)).withSerializer(serializer)).build();
        return new DefaultDistributedTopic(atomicValue);
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    protected void unbindPersistenceService(PersistenceService persistenceService) {
        if (this.persistenceService == persistenceService) {
            this.persistenceService = null;
        }
    }

    protected void bindPartitionService(PartitionService partitionService) {
        this.partitionService = partitionService;
    }

    protected void unbindPartitionService(PartitionService partitionService) {
        if (this.partitionService == partitionService) {
            this.partitionService = null;
        }
    }

    protected void bindPartitionAdminService(PartitionAdminService partitionAdminService) {
        this.partitionAdminService = partitionAdminService;
    }

    protected void unbindPartitionAdminService(PartitionAdminService partitionAdminService) {
        if (this.partitionAdminService == partitionAdminService) {
            this.partitionAdminService = null;
        }
    }
}

