/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.impl.TransactionParticipant;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.CommitStatus;

public class TransactionCoordinator {
    private final AsyncConsistentMap<TransactionId, Transaction.State> transactions;

    public TransactionCoordinator(AsyncConsistentMap<TransactionId, Transaction.State> transactions) {
        this.transactions = transactions;
    }

    CompletableFuture<CommitStatus> commit(TransactionId transactionId, Set<TransactionParticipant> transactionParticipants) {
        int totalUpdates = transactionParticipants.stream().map(TransactionParticipant::totalUpdates).reduce(Math::addExact).orElse(0);
        if (totalUpdates == 0) {
            return CompletableFuture.completedFuture(CommitStatus.SUCCESS);
        }
        if (totalUpdates == 1) {
            return transactionParticipants.stream().filter(p -> p.totalUpdates() == 1).findFirst().get().prepareAndCommit().thenApply(v -> v != false ? CommitStatus.SUCCESS : CommitStatus.FAILURE);
        }
        CompletionStage status = ((CompletableFuture)this.transactions.put((Object)transactionId, (Object)Transaction.State.PREPARING).thenCompose(v -> this.doPrepare(transactionParticipants))).thenCompose(result -> result != false ? ((CompletableFuture)this.transactions.put((Object)transactionId, (Object)Transaction.State.COMMITTING).thenCompose(v -> this.doCommit(transactionParticipants))).thenApply(v -> CommitStatus.SUCCESS) : ((CompletableFuture)this.transactions.put((Object)transactionId, (Object)Transaction.State.ROLLINGBACK).thenCompose(v -> this.doRollback(transactionParticipants))).thenApply(v -> CommitStatus.FAILURE));
        return ((CompletableFuture)status).thenCompose(v -> this.transactions.remove((Object)transactionId).thenApply(u -> v));
    }

    private CompletableFuture<Boolean> doPrepare(Set<TransactionParticipant> transactionParticipants) {
        return Tools.allOf(transactionParticipants.stream().filter(TransactionParticipant::hasPendingUpdates).map(TransactionParticipant::prepare).collect(Collectors.toList())).thenApply(list -> list.stream().reduce(Boolean::logicalAnd).orElse(true));
    }

    private CompletableFuture<Void> doCommit(Set<TransactionParticipant> transactionParticipants) {
        return CompletableFuture.allOf((CompletableFuture[])transactionParticipants.stream().filter(TransactionParticipant::hasPendingUpdates).map(TransactionParticipant::commit).toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<Void> doRollback(Set<TransactionParticipant> transactionParticipants) {
        return CompletableFuture.allOf((CompletableFuture[])transactionParticipants.stream().filter(TransactionParticipant::hasPendingUpdates).map(TransactionParticipant::rollback).toArray(CompletableFuture[]::new));
    }
}

