/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.MoreObjects;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.onlab.util.Match;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.resources.impl.CommitResult;
import org.onosproject.store.primitives.resources.impl.MapEntryUpdateResult;
import org.onosproject.store.primitives.resources.impl.PrepareResult;
import org.onosproject.store.primitives.resources.impl.RollbackResult;
import org.onosproject.store.service.MapTransaction;
import org.onosproject.store.service.Versioned;

public final class AtomixConsistentMapCommands {
    private AtomixConsistentMapCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        public void resolve(SerializerRegistry registry) {
            registry.register(ContainsKey.class, -761);
            registry.register(ContainsValue.class, -762);
            registry.register(Get.class, -763);
            registry.register(EntrySet.class, -764);
            registry.register(Values.class, -765);
            registry.register(KeySet.class, -766);
            registry.register(Clear.class, -767);
            registry.register(IsEmpty.class, -768);
            registry.register(Size.class, -769);
            registry.register(Listen.class, -770);
            registry.register(Unlisten.class, -771);
            registry.register(TransactionPrepare.class, -772);
            registry.register(TransactionCommit.class, -773);
            registry.register(TransactionRollback.class, -774);
            registry.register(TransactionPrepareAndCommit.class, -775);
            registry.register(UpdateAndGet.class, -776);
        }
    }

    public static class Unlisten
    implements Command<Void>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    public static class Listen
    implements Command<Void>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    public static class Clear
    extends MapCommand<MapEntryUpdateResult.Status> {
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.FULL;
        }
    }

    public static class Size
    extends MapQuery<Integer> {
    }

    public static class EntrySet
    extends MapQuery<Set<Map.Entry<String, Versioned<byte[]>>>> {
    }

    public static class Values
    extends MapQuery<Collection<Versioned<byte[]>>> {
    }

    public static class KeySet
    extends MapQuery<Set<String>> {
    }

    public static class IsEmpty
    extends MapQuery<Boolean> {
    }

    public static class Get
    extends KeyQuery<Versioned<byte[]>> {
        public Get() {
        }

        public Get(String key) {
            super(key);
        }
    }

    public static class UpdateAndGet
    extends MapCommand<MapEntryUpdateResult<String, byte[]>> {
        private String key;
        private byte[] value;
        private Match<byte[]> valueMatch;
        private Match<Long> versionMatch;

        public UpdateAndGet() {
        }

        public UpdateAndGet(String key, byte[] value, Match<byte[]> valueMatch, Match<Long> versionMatch) {
            this.key = key;
            this.value = value;
            this.valueMatch = valueMatch;
            this.versionMatch = versionMatch;
        }

        public String key() {
            return this.key;
        }

        public byte[] value() {
            return this.value;
        }

        public Match<byte[]> valueMatch() {
            return this.valueMatch;
        }

        public Match<Long> versionMatch() {
            return this.versionMatch;
        }

        public Command.CompactionMode compaction() {
            return this.value == null ? Command.CompactionMode.FULL : Command.CompactionMode.QUORUM;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.key, buffer);
            serializer.writeObject((Object)this.value, buffer);
            serializer.writeObject(this.valueMatch, buffer);
            serializer.writeObject(this.versionMatch, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = (String)serializer.readObject(buffer);
            this.value = (byte[])serializer.readObject(buffer);
            this.valueMatch = (Match)serializer.readObject(buffer);
            this.versionMatch = (Match)serializer.readObject(buffer);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key).add("value", (Object)this.value).add("valueMatch", this.valueMatch).add("versionMatch", this.versionMatch).toString();
        }
    }

    public static class TransactionRollback
    extends MapCommand<RollbackResult> {
        private TransactionId transactionId;

        public TransactionRollback() {
        }

        public TransactionRollback(TransactionId transactionId) {
            this.transactionId = transactionId;
        }

        public TransactionId transactionId() {
            return this.transactionId;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.transactionId, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.transactionId = (TransactionId)serializer.readObject(buffer);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("transactionId", (Object)this.transactionId).toString();
        }
    }

    public static class TransactionCommit
    extends MapCommand<CommitResult> {
        private TransactionId transactionId;

        public TransactionCommit() {
        }

        public TransactionCommit(TransactionId transactionId) {
            this.transactionId = transactionId;
        }

        public TransactionId transactionId() {
            return this.transactionId;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.transactionId, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.transactionId = (TransactionId)serializer.readObject(buffer);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("transactionId", (Object)this.transactionId).toString();
        }
    }

    public static class TransactionPrepareAndCommit
    extends TransactionPrepare {
        public TransactionPrepareAndCommit() {
        }

        public TransactionPrepareAndCommit(MapTransaction<String, byte[]> mapTransaction) {
            super(mapTransaction);
        }
    }

    public static class TransactionPrepare
    extends MapCommand<PrepareResult> {
        private MapTransaction<String, byte[]> mapTransaction;

        public TransactionPrepare() {
        }

        public TransactionPrepare(MapTransaction<String, byte[]> mapTransaction) {
            this.mapTransaction = mapTransaction;
        }

        public MapTransaction<String, byte[]> transaction() {
            return this.mapTransaction;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.mapTransaction, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.mapTransaction = (MapTransaction)serializer.readObject(buffer);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("mapTransaction", this.mapTransaction).toString();
        }
    }

    public static class ContainsValue
    extends ValueQuery<Boolean> {
        public ContainsValue() {
        }

        public ContainsValue(byte[] value) {
            super(value);
        }
    }

    public static class ContainsKey
    extends KeyQuery<Boolean> {
        public ContainsKey() {
        }

        public ContainsKey(String key) {
            super(key);
        }
    }

    public static abstract class ValueQuery<V>
    extends MapQuery<V> {
        protected byte[] value;

        public ValueQuery() {
        }

        public ValueQuery(byte[] value) {
            this.value = (byte[])Assert.notNull((Object)value, (String)"value");
        }

        public byte[] value() {
            return this.value;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", (Object)this.value).toString();
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = (byte[])serializer.readObject(buffer);
        }
    }

    public static abstract class KeyQuery<V>
    extends MapQuery<V> {
        protected String key;

        public KeyQuery() {
        }

        public KeyQuery(String key) {
            this.key = (String)Assert.notNull((Object)key, (String)"key");
        }

        public String key() {
            return this.key;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key).toString();
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.key, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = (String)serializer.readObject(buffer);
        }
    }

    public static abstract class MapQuery<V>
    implements Query<V>,
    CatalystSerializable {
        public Query.ConsistencyLevel consistency() {
            return Query.ConsistencyLevel.SEQUENTIAL;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    public static abstract class MapCommand<V>
    implements Command<V>,
    CatalystSerializable {
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

