/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.MoreObjects;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import org.onlab.util.Match;
import org.onosproject.store.primitives.resources.impl.MapEntryUpdateResult;
import org.onosproject.store.service.Versioned;

public final class AtomixConsistentTreeMapCommands {
    private AtomixConsistentTreeMapCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        public void resolve(SerializerRegistry registry) {
            registry.register(ContainsKey.class, -1161);
            registry.register(ContainsValue.class, -1162);
            registry.register(Get.class, -1163);
            registry.register(EntrySet.class, -1164);
            registry.register(Values.class, -1165);
            registry.register(KeySet.class, -1166);
            registry.register(Clear.class, -1167);
            registry.register(IsEmpty.class, -1168);
            registry.register(Size.class, -1169);
            registry.register(Listen.class, -1170);
            registry.register(Unlisten.class, -1171);
            registry.register(UpdateAndGet.class, -1175);
            registry.register(FirstKey.class, -1176);
            registry.register(LastKey.class, -1177);
            registry.register(FirstEntry.class, -1178);
            registry.register(LastEntry.class, -1179);
            registry.register(PollFirstEntry.class, -1180);
            registry.register(PollLastEntry.class, -1181);
            registry.register(LowerEntry.class, -1182);
            registry.register(LowerKey.class, -1183);
            registry.register(FloorEntry.class, -1184);
            registry.register(FloorKey.class, -1185);
            registry.register(CeilingEntry.class, -1186);
            registry.register(CeilingKey.class, -1187);
            registry.register(HigherEntry.class, -1188);
            registry.register(HigherKey.class, -1189);
            registry.register(SubMap.class, -1190);
            registry.register(NavigableKeySet.class, -1191);
        }
    }

    public static class SubMap<K, V>
    extends TreeQuery<NavigableMap<K, V>> {
        private K fromKey;
        private K toKey;
        private boolean inclusiveFrom;
        private boolean inclusiveTo;

        public SubMap() {
        }

        public SubMap(K fromKey, K toKey, boolean inclusiveFrom, boolean inclusiveTo) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.inclusiveFrom = inclusiveFrom;
            this.inclusiveTo = inclusiveTo;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("getFromKey", this.fromKey).add("getToKey", this.toKey).add("inclusiveFrotBound", this.inclusiveFrom).add("inclusiveToBound", this.inclusiveTo).toString();
        }

        @Override
        public void writeObject(BufferOutput<?> bufferOutput, Serializer serializer) {
            super.writeObject(bufferOutput, serializer);
            serializer.writeObject(this.fromKey, bufferOutput);
            serializer.writeObject(this.toKey, bufferOutput);
            serializer.writeObject((Object)this.inclusiveFrom, bufferOutput);
            serializer.writeObject((Object)this.inclusiveTo, bufferOutput);
        }

        @Override
        public void readObject(BufferInput<?> bufferInput, Serializer serializer) {
            super.readObject(bufferInput, serializer);
            this.fromKey = serializer.readObject(bufferInput);
            this.toKey = serializer.readObject(bufferInput);
            this.inclusiveFrom = (Boolean)serializer.readObject(bufferInput);
            this.inclusiveTo = (Boolean)serializer.readObject(bufferInput);
        }

        public K fromKey() {
            return this.fromKey;
        }

        public K toKey() {
            return this.toKey;
        }

        public boolean isInclusiveFrom() {
            return this.inclusiveFrom;
        }

        public boolean isInclusiveTo() {
            return this.inclusiveTo;
        }
    }

    public static class NavigableKeySet<K, V>
    extends TreeQuery<NavigableSet<K>> {
    }

    public static class HigherKey<K>
    extends KeyQuery<K> {
        public HigherKey() {
        }

        public HigherKey(String key) {
            super(key);
        }
    }

    public static class HigherEntry<K, V>
    extends KeyQuery<Map.Entry<K, V>> {
        public HigherEntry() {
        }

        public HigherEntry(String key) {
            super(key);
        }
    }

    public static class CeilingKey<K>
    extends KeyQuery<K> {
        public CeilingKey() {
        }

        public CeilingKey(String key) {
            super(key);
        }
    }

    public static class CeilingEntry<K, V>
    extends KeyQuery<Map.Entry<K, V>> {
        public CeilingEntry() {
        }

        public CeilingEntry(String key) {
            super(key);
        }
    }

    public static class FloorKey<K>
    extends KeyQuery<K> {
        public FloorKey() {
        }

        public FloorKey(String key) {
            super(key);
        }
    }

    public static class FloorEntry<K, V>
    extends KeyQuery<Map.Entry<K, V>> {
        public FloorEntry() {
        }

        public FloorEntry(String key) {
            super(key);
        }
    }

    public static class LowerKey<K>
    extends KeyQuery<K> {
        public LowerKey() {
        }

        public LowerKey(String key) {
            super(key);
        }
    }

    public static class LowerEntry<K, V>
    extends KeyQuery<K> {
        public LowerEntry() {
        }

        public LowerEntry(String key) {
            super(key);
        }
    }

    public static class PollLastEntry<K, V>
    extends TreeQuery<Map.Entry<K, V>> {
    }

    public static class PollFirstEntry<K, V>
    extends TreeQuery<Map.Entry<K, V>> {
    }

    public static class LastEntry<K, V>
    extends TreeQuery<Map.Entry<K, V>> {
    }

    public static class FirstEntry<K, V>
    extends TreeQuery<Map.Entry<K, V>> {
    }

    public static class LastKey<K>
    extends TreeQuery<K> {
    }

    public static class FirstKey<K>
    extends TreeQuery<K> {
    }

    public static class Unlisten
    implements Command<Void>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }
    }

    public static class Listen
    implements Command<Void>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }
    }

    public static class Clear
    extends TreeCommand<MapEntryUpdateResult.Status> {
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.FULL;
        }
    }

    public static class Size
    extends TreeQuery<Integer> {
    }

    public static class EntrySet
    extends TreeQuery<Set<Map.Entry<String, Versioned<byte[]>>>> {
    }

    public static class Values
    extends TreeQuery<Collection<Versioned<byte[]>>> {
    }

    public static class KeySet
    extends TreeQuery<Set<String>> {
    }

    public static class IsEmpty
    extends TreeQuery<Boolean> {
    }

    public static class Get
    extends KeyQuery<Versioned<byte[]>> {
        public Get() {
        }

        public Get(String key) {
            super(key);
        }
    }

    public static class UpdateAndGet
    extends TreeCommand<MapEntryUpdateResult<String, byte[]>> {
        private String key;
        private byte[] value;
        private Match<byte[]> valueMatch;
        private Match<Long> versionMatch;

        public UpdateAndGet() {
        }

        public UpdateAndGet(String key, byte[] value, Match<byte[]> valueMatch, Match<Long> versionMatch) {
            this.key = key;
            this.value = value;
            this.valueMatch = valueMatch;
            this.versionMatch = versionMatch;
        }

        public String key() {
            return this.key;
        }

        public byte[] value() {
            return this.value;
        }

        public Match<byte[]> valueMatch() {
            return this.valueMatch;
        }

        public Match<Long> versionMatch() {
            return this.versionMatch;
        }

        public Command.CompactionMode compaction() {
            return this.value == null ? Command.CompactionMode.FULL : Command.CompactionMode.QUORUM;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.key, buffer);
            serializer.writeObject((Object)this.value, buffer);
            serializer.writeObject(this.valueMatch, buffer);
            serializer.writeObject(this.versionMatch, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = (String)serializer.readObject(buffer);
            this.value = (byte[])serializer.readObject(buffer);
            this.valueMatch = (Match)serializer.readObject(buffer);
            this.versionMatch = (Match)serializer.readObject(buffer);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key).add("value", (Object)this.value).add("valueMatch", this.valueMatch).add("versionMatch", this.versionMatch).toString();
        }
    }

    public static class ContainsValue
    extends ValueQuery<Boolean> {
        public ContainsValue() {
        }

        public ContainsValue(byte[] value) {
            super(value);
        }
    }

    public static class ContainsKey
    extends KeyQuery<Boolean> {
        public ContainsKey(String key) {
            super(key);
        }

        public ContainsKey() {
        }
    }

    public static abstract class ValueQuery<V>
    extends TreeQuery<V> {
        protected byte[] value;

        public ValueQuery() {
        }

        public ValueQuery(byte[] value) {
            this.value = (byte[])Assert.notNull((Object)value, (String)"value");
        }

        public byte[] value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> bufferOutput, Serializer serializer) {
            super.writeObject(bufferOutput, serializer);
            serializer.writeObject((Object)this.value, bufferOutput);
        }

        @Override
        public void readObject(BufferInput<?> bufferInput, Serializer serializer) {
            super.readObject(bufferInput, serializer);
            this.value = (byte[])serializer.readObject(bufferInput);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", (Object)this.value).toString();
        }
    }

    public static abstract class KeyQuery<K>
    extends TreeQuery<K> {
        protected String key;

        public KeyQuery(String key) {
            this.key = (String)Assert.notNull((Object)key, (String)"key");
        }

        public KeyQuery() {
        }

        public String key() {
            return this.key;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key).toString();
        }

        @Override
        public void writeObject(BufferOutput<?> bufferOutput, Serializer serializer) {
            super.writeObject(bufferOutput, serializer);
            serializer.writeObject((Object)this.key, bufferOutput);
        }

        @Override
        public void readObject(BufferInput<?> bufferInput, Serializer serializer) {
            super.readObject(bufferInput, serializer);
            this.key = (String)serializer.readObject(bufferInput);
        }
    }

    public static abstract class TreeQuery<V>
    implements Query<V>,
    CatalystSerializable {
        public Query.ConsistencyLevel consistency() {
            return Query.ConsistencyLevel.LINEARIZABLE_LEASE;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }

        public void writeObject(BufferOutput<?> bufferOutput, Serializer serializer) {
        }

        public void readObject(BufferInput<?> bufferInput, Serializer serializer) {
        }
    }

    public static abstract class TreeCommand<V>
    implements Command<V>,
    CatalystSerializable {
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

