/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ResourceTypeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.onlab.util.Match;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMapCommands;
import org.onosproject.store.primitives.resources.impl.AtomixDocumentTreeCommands;
import org.onosproject.store.primitives.resources.impl.AtomixDocumentTreeFactory;
import org.onosproject.store.primitives.resources.impl.DocumentTreeUpdateResult;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTreeEvent;
import org.onosproject.store.service.DocumentTreeListener;
import org.onosproject.store.service.IllegalDocumentModificationException;
import org.onosproject.store.service.NoSuchDocumentPathException;
import org.onosproject.store.service.Versioned;

@ResourceTypeInfo(id=-156, factory=AtomixDocumentTreeFactory.class)
public class AtomixDocumentTree
extends AbstractResource<AtomixDocumentTree>
implements AsyncDocumentTree<byte[]> {
    private final Map<DocumentTreeListener<byte[]>, Executor> eventListeners = new HashMap<DocumentTreeListener<byte[]>, Executor>();
    public static final String CHANGE_SUBJECT = "changeEvents";

    protected AtomixDocumentTree(CopycatClient client, Properties options) {
        super(client, options);
    }

    public CompletableFuture<AtomixDocumentTree> open() {
        return super.open().thenApply(result -> {
            this.client.onStateChange(state -> {
                if (state == CopycatClient.State.CONNECTED && this.isListening()) {
                    this.client.submit((Command)new AtomixDocumentTreeCommands.Listen());
                }
            });
            this.client.onEvent(CHANGE_SUBJECT, this::processTreeUpdates);
            return result;
        });
    }

    public String name() {
        return null;
    }

    public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.DOCUMENT_TREE;
    }

    public CompletableFuture<Void> destroy() {
        return this.client.submit((Command)new AtomixDocumentTreeCommands.Clear());
    }

    public DocumentPath root() {
        return DocumentPath.from((String)"root");
    }

    public CompletableFuture<Map<String, Versioned<byte[]>>> getChildren(DocumentPath path) {
        return this.client.submit((Query)new AtomixDocumentTreeCommands.GetChildren((DocumentPath)Preconditions.checkNotNull((Object)path)));
    }

    public CompletableFuture<Versioned<byte[]>> get(DocumentPath path) {
        return this.client.submit((Query)new AtomixDocumentTreeCommands.Get((DocumentPath)Preconditions.checkNotNull((Object)path)));
    }

    public CompletableFuture<Versioned<byte[]>> set(DocumentPath path, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixDocumentTreeCommands.Update((DocumentPath)Preconditions.checkNotNull((Object)path), (byte[])Preconditions.checkNotNull((Object)value), (Match<byte[]>)Match.any(), (Match<Long>)Match.any())).thenCompose(result -> {
            if (result.status() == DocumentTreeUpdateResult.Status.INVALID_PATH) {
                return Tools.exceptionalFuture((Throwable)new NoSuchDocumentPathException());
            }
            if (result.status() == DocumentTreeUpdateResult.Status.ILLEGAL_MODIFICATION) {
                return Tools.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
            }
            return CompletableFuture.completedFuture(result);
        })).thenApply(result -> result.oldValue());
    }

    public CompletableFuture<Boolean> create(DocumentPath path, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixDocumentTreeCommands.Update((DocumentPath)Preconditions.checkNotNull((Object)path), (byte[])Preconditions.checkNotNull((Object)value), (Match<byte[]>)Match.ifNull(), (Match<Long>)Match.any())).thenCompose(result -> {
            if (result.status() == DocumentTreeUpdateResult.Status.INVALID_PATH) {
                return Tools.exceptionalFuture((Throwable)new NoSuchDocumentPathException());
            }
            if (result.status() == DocumentTreeUpdateResult.Status.ILLEGAL_MODIFICATION) {
                return Tools.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
            }
            return CompletableFuture.completedFuture(result);
        })).thenApply(result -> result.created());
    }

    public CompletableFuture<Boolean> replace(DocumentPath path, byte[] newValue, long version) {
        return this.client.submit((Command)new AtomixDocumentTreeCommands.Update((DocumentPath)Preconditions.checkNotNull((Object)path), newValue, (Match<byte[]>)Match.any(), (Match<Long>)Match.ifValue((Object)version))).thenApply(result -> result.updated());
    }

    public CompletableFuture<Boolean> replace(DocumentPath path, byte[] newValue, byte[] currentValue) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixDocumentTreeCommands.Update((DocumentPath)Preconditions.checkNotNull((Object)path), newValue, (Match<byte[]>)Match.ifValue((Object)currentValue), (Match<Long>)Match.any())).thenCompose(result -> {
            if (result.status() == DocumentTreeUpdateResult.Status.INVALID_PATH) {
                return Tools.exceptionalFuture((Throwable)new NoSuchDocumentPathException());
            }
            if (result.status() == DocumentTreeUpdateResult.Status.ILLEGAL_MODIFICATION) {
                return Tools.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
            }
            return CompletableFuture.completedFuture(result);
        })).thenApply(result -> result.updated());
    }

    public CompletableFuture<Versioned<byte[]>> removeNode(DocumentPath path) {
        if (path.equals((Object)DocumentPath.from((String)"root"))) {
            return Tools.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
        }
        return ((CompletableFuture)this.client.submit((Command)new AtomixDocumentTreeCommands.Update((DocumentPath)Preconditions.checkNotNull((Object)path), null, (Match<byte[]>)Match.ifNotNull(), (Match<Long>)Match.any())).thenCompose(result -> {
            if (result.status() == DocumentTreeUpdateResult.Status.INVALID_PATH) {
                return Tools.exceptionalFuture((Throwable)new NoSuchDocumentPathException());
            }
            if (result.status() == DocumentTreeUpdateResult.Status.ILLEGAL_MODIFICATION) {
                return Tools.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
            }
            return CompletableFuture.completedFuture(result);
        })).thenApply(result -> result.oldValue());
    }

    public CompletableFuture<Void> addListener(DocumentPath path, DocumentTreeListener<byte[]> listener) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(listener);
        if (this.isListening()) {
            this.eventListeners.putIfAbsent(listener, MoreExecutors.directExecutor());
            return CompletableFuture.completedFuture(null);
        }
        return this.client.submit((Command)new AtomixDocumentTreeCommands.Listen(path)).thenRun(() -> this.eventListeners.put(listener, MoreExecutors.directExecutor()));
    }

    public CompletableFuture<Void> removeListener(DocumentTreeListener<byte[]> listener) {
        Preconditions.checkNotNull(listener);
        if (this.eventListeners.remove(listener) != null && this.eventListeners.isEmpty()) {
            return this.client.submit((Command)new AtomixConsistentMapCommands.Unlisten()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean isListening() {
        return !this.eventListeners.isEmpty();
    }

    private void processTreeUpdates(List<DocumentTreeEvent<byte[]>> events) {
        events.forEach(event -> this.eventListeners.forEach((listener, executor) -> executor.execute(() -> listener.event(event))));
    }
}

