/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.copycat.session.Session;
import io.atomix.resource.ResourceStateMachine;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.onlab.util.Match;
import org.onosproject.store.primitives.resources.impl.AtomixDocumentTreeCommands;
import org.onosproject.store.primitives.resources.impl.DefaultDocumentTree;
import org.onosproject.store.primitives.resources.impl.DocumentTreeUpdateResult;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTree;
import org.onosproject.store.service.DocumentTreeEvent;
import org.onosproject.store.service.IllegalDocumentModificationException;
import org.onosproject.store.service.NoSuchDocumentPathException;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixDocumentTreeState
extends ResourceStateMachine
implements SessionListener,
Snapshottable {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<Long, Commit<? extends AtomixDocumentTreeCommands.Listen>> listeners = new HashMap<Long, Commit<? extends AtomixDocumentTreeCommands.Listen>>();
    private AtomicLong versionCounter = new AtomicLong(0L);
    private final DocumentTree<TreeNodeValue> docTree = new DefaultDocumentTree<TreeNodeValue>((Supplier<Long>)((Supplier)this.versionCounter::incrementAndGet));

    public AtomixDocumentTreeState(Properties properties) {
        super(properties);
    }

    public void snapshot(SnapshotWriter writer) {
        writer.writeLong(this.versionCounter.get());
    }

    public void install(SnapshotReader reader) {
        this.versionCounter = new AtomicLong(reader.readLong());
    }

    protected void configure(StateMachineExecutor executor) {
        executor.register(AtomixDocumentTreeCommands.Listen.class, this::listen);
        executor.register(AtomixDocumentTreeCommands.Unlisten.class, this::unlisten);
        executor.register(AtomixDocumentTreeCommands.Get.class, this::get);
        executor.register(AtomixDocumentTreeCommands.GetChildren.class, this::getChildren);
        executor.register(AtomixDocumentTreeCommands.Update.class, this::update);
        executor.register(AtomixDocumentTreeCommands.Clear.class, this::clear);
    }

    protected void listen(Commit<? extends AtomixDocumentTreeCommands.Listen> commit) {
        Long sessionId = commit.session().id();
        if (this.listeners.putIfAbsent(sessionId, commit) != null) {
            commit.close();
            return;
        }
        commit.session().onStateChange(state -> {
            Commit<? extends AtomixDocumentTreeCommands.Listen> listener;
            if ((state == Session.State.CLOSED || state == Session.State.EXPIRED) && (listener = this.listeners.remove(sessionId)) != null) {
                listener.close();
            }
        });
    }

    protected void unlisten(Commit<? extends AtomixDocumentTreeCommands.Unlisten> commit) {
        try {
            this.closeListener(commit.session().id());
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Versioned<byte[]> get(Commit<? extends AtomixDocumentTreeCommands.Get> commit) {
        try {
            Versioned value = this.docTree.get(((AtomixDocumentTreeCommands.Get)commit.operation()).path());
            Versioned versioned = value == null ? null : value.map(node -> node == null ? null : node.value());
            return versioned;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Versioned<byte[]>> getChildren(Commit<? extends AtomixDocumentTreeCommands.GetChildren> commit) {
        try {
            Map children = this.docTree.getChildren(((AtomixDocumentTreeCommands.GetChildren)commit.operation()).path());
            HashMap hashMap = children == null ? null : Maps.newHashMap((Map)Maps.transformValues((Map)children, value -> value.map(TreeNodeValue::value)));
            return hashMap;
        }
        finally {
            commit.close();
        }
    }

    protected DocumentTreeUpdateResult<byte[]> update(Commit<? extends AtomixDocumentTreeCommands.Update> commit) {
        DocumentTreeUpdateResult<Object> result = null;
        DocumentPath path = ((AtomixDocumentTreeCommands.Update)commit.operation()).path();
        boolean updated = false;
        Versioned currentValue = this.docTree.get(path);
        try {
            Versioned newValue;
            Match<Long> versionMatch = ((AtomixDocumentTreeCommands.Update)commit.operation()).versionMatch();
            Match<byte[]> valueMatch = ((AtomixDocumentTreeCommands.Update)commit.operation()).valueMatch();
            if (versionMatch.matches(currentValue == null ? null : Long.valueOf(currentValue.version())) && valueMatch.matches(currentValue == null ? null : ((TreeNodeValue)currentValue.value()).value())) {
                if (((AtomixDocumentTreeCommands.Update)commit.operation()).value() == null) {
                    this.docTree.removeNode(path);
                } else {
                    this.docTree.set(path, (Object)new NonTransactionalCommit(commit));
                }
                updated = true;
            }
            Versioned versioned = newValue = updated ? this.docTree.get(path) : currentValue;
            DocumentTreeUpdateResult.Status updateStatus = updated ? DocumentTreeUpdateResult.Status.OK : (((AtomixDocumentTreeCommands.Update)commit.operation()).value() == null ? DocumentTreeUpdateResult.Status.INVALID_PATH : DocumentTreeUpdateResult.Status.NOOP);
            result = new DocumentTreeUpdateResult(path, updateStatus, newValue == null ? null : newValue.map(TreeNodeValue::value), currentValue == null ? null : currentValue.map(TreeNodeValue::value));
        }
        catch (IllegalDocumentModificationException e) {
            result = DocumentTreeUpdateResult.illegalModification(path);
        }
        catch (NoSuchDocumentPathException e) {
            result = DocumentTreeUpdateResult.invalidPath(path);
        }
        catch (Exception e) {
            this.log.error("Failed to apply {} to state machine", (Object)commit.operation(), (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            if (updated) {
                if (currentValue != null) {
                    ((TreeNodeValue)currentValue.value()).discard();
                }
            } else {
                commit.close();
            }
        }
        this.notifyListeners(path, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear(Commit<? extends AtomixDocumentTreeCommands.Clear> commit) {
        try {
            ArrayDeque toClearQueue = Queues.newArrayDeque();
            Map topLevelChildren = this.docTree.getChildren(DocumentPath.from((String)"root"));
            toClearQueue.addAll(topLevelChildren.keySet().stream().map(name -> new DocumentPath(name, DocumentPath.from((String)"root"))).collect(Collectors.toList()));
            while (!toClearQueue.isEmpty()) {
                DocumentPath path = (DocumentPath)toClearQueue.remove();
                Map children = this.docTree.getChildren(path);
                if (children.size() == 0) {
                    ((TreeNodeValue)this.docTree.removeNode(path).value()).discard();
                    continue;
                }
                children.keySet().stream().forEach(name -> toClearQueue.add(new DocumentPath(name, path)));
                toClearQueue.add(path);
            }
        }
        finally {
            commit.close();
        }
    }

    private void notifyListeners(DocumentPath path, DocumentTreeUpdateResult<byte[]> result) {
        if (result.status() != DocumentTreeUpdateResult.Status.OK) {
            return;
        }
        DocumentTreeEvent event = new DocumentTreeEvent(path, result.created() ? DocumentTreeEvent.Type.CREATED : (result.newValue() == null ? DocumentTreeEvent.Type.DELETED : DocumentTreeEvent.Type.UPDATED), Optional.ofNullable(result.newValue()), Optional.ofNullable(result.oldValue()));
        this.listeners.values().forEach(commit -> commit.session().publish("changeEvents", (Object)ImmutableList.of((Object)event)));
    }

    public void register(ServerSession session) {
    }

    public void unregister(ServerSession session) {
        this.closeListener(session.id());
    }

    public void expire(ServerSession session) {
        this.closeListener(session.id());
    }

    public void close(ServerSession session) {
        this.closeListener(session.id());
    }

    private void closeListener(Long sessionId) {
        Commit<? extends AtomixDocumentTreeCommands.Listen> commit = this.listeners.remove(sessionId);
        if (commit != null) {
            commit.close();
        }
    }

    private class NonTransactionalCommit
    implements TreeNodeValue {
        private final Commit<? extends AtomixDocumentTreeCommands.Update> commit;

        public NonTransactionalCommit(Commit<? extends AtomixDocumentTreeCommands.Update> commit) {
            this.commit = commit;
        }

        @Override
        public byte[] value() {
            return ((AtomixDocumentTreeCommands.Update)this.commit.operation()).value();
        }

        @Override
        public void discard() {
            this.commit.close();
        }
    }

    private static interface TreeNodeValue {
        public byte[] value();

        public void discard();
    }
}

