/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.onosproject.store.primitives.resources.impl.DefaultDocumentTreeNode;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTree;
import org.onosproject.store.service.DocumentTreeListener;
import org.onosproject.store.service.IllegalDocumentModificationException;
import org.onosproject.store.service.NoSuchDocumentPathException;
import org.onosproject.store.service.Versioned;

public class DefaultDocumentTree<V>
implements DocumentTree<V> {
    private static final DocumentPath ROOT_PATH = DocumentPath.from((String)"root");
    private final DefaultDocumentTreeNode<V> root;
    private final Supplier<Long> versionSupplier;

    public DefaultDocumentTree() {
        AtomicLong versionCounter = new AtomicLong(0L);
        this.versionSupplier = versionCounter::incrementAndGet;
        this.root = new DefaultDocumentTreeNode<Object>(ROOT_PATH, null, (Long)this.versionSupplier.get(), null);
    }

    public DefaultDocumentTree(Supplier<Long> versionSupplier) {
        this.root = new DefaultDocumentTreeNode<Object>(ROOT_PATH, null, (Long)versionSupplier.get(), null);
        this.versionSupplier = versionSupplier;
    }

    public DocumentPath root() {
        return ROOT_PATH;
    }

    public Map<String, Versioned<V>> getChildren(DocumentPath path) {
        DefaultDocumentTreeNode<V> node = this.getNode(path);
        if (node != null) {
            HashMap childrenValues = Maps.newHashMap();
            node.children().forEachRemaining(n -> childrenValues.put(this.simpleName(n.path()), n.value()));
            return childrenValues;
        }
        throw new NoSuchDocumentPathException();
    }

    public Versioned<V> get(DocumentPath path) {
        DefaultDocumentTreeNode<V> currentNode = this.getNode(path);
        return currentNode != null ? currentNode.value() : null;
    }

    public Versioned<V> set(DocumentPath path, V value) {
        this.checkRootModification(path);
        DefaultDocumentTreeNode<V> node = this.getNode(path);
        if (node != null) {
            return node.update(value, (Long)this.versionSupplier.get());
        }
        this.create(path, value);
        return null;
    }

    public boolean create(DocumentPath path, V value) {
        this.checkRootModification(path);
        DefaultDocumentTreeNode<V> node = this.getNode(path);
        if (node != null) {
            return false;
        }
        DocumentPath parentPath = path.parent();
        DefaultDocumentTreeNode<V> parentNode = this.getNode(parentPath);
        if (parentNode == null) {
            throw new IllegalDocumentModificationException();
        }
        parentNode.addChild(this.simpleName(path), value, (Long)this.versionSupplier.get());
        return true;
    }

    public boolean replace(DocumentPath path, V newValue, long version) {
        this.checkRootModification(path);
        DefaultDocumentTreeNode<V> node = this.getNode(path);
        if (node != null && node.value() != null && node.value().version() == version && !Objects.equals(newValue, node.value().value())) {
            this.set(path, newValue);
            return true;
        }
        return false;
    }

    public boolean replace(DocumentPath path, V newValue, V currentValue) {
        this.checkRootModification(path);
        if (Objects.equals(newValue, currentValue)) {
            return false;
        }
        DefaultDocumentTreeNode<V> node = this.getNode(path);
        if (node != null && Objects.equals(Versioned.valueOrNull((Versioned)node.value()), currentValue)) {
            this.set(path, newValue);
            return true;
        }
        return false;
    }

    public Versioned<V> removeNode(DocumentPath path) {
        this.checkRootModification(path);
        DefaultDocumentTreeNode<V> nodeToRemove = this.getNode(path);
        if (nodeToRemove == null) {
            throw new NoSuchDocumentPathException();
        }
        if (nodeToRemove.hasChildren()) {
            throw new IllegalDocumentModificationException();
        }
        DefaultDocumentTreeNode parent = (DefaultDocumentTreeNode)nodeToRemove.parent();
        parent.removeChild(this.simpleName(path));
        return nodeToRemove.value();
    }

    public void addListener(DocumentPath path, DocumentTreeListener<V> listener) {
    }

    public void removeListener(DocumentTreeListener<V> listener) {
    }

    private DefaultDocumentTreeNode<V> getNode(DocumentPath path) {
        DefaultDocumentTreeNode currentNode;
        Iterator pathElements = path.pathElements().iterator();
        Preconditions.checkState((boolean)"root".equals(pathElements.next()), (Object)"Path should start with root");
        for (currentNode = this.root; pathElements.hasNext() && currentNode != null; currentNode = (DefaultDocumentTreeNode)currentNode.child((String)pathElements.next())) {
        }
        return currentNode;
    }

    private String simpleName(DocumentPath path) {
        return (String)path.pathElements().get(path.pathElements().size() - 1);
    }

    private void checkRootModification(DocumentPath path) {
        if (ROOT_PATH.equals((Object)path)) {
            throw new IllegalDocumentModificationException();
        }
    }
}

