/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.Throwables;
import io.atomix.resource.ResourceType;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.onosproject.store.primitives.resources.impl.AtomixDocumentTree;
import org.onosproject.store.primitives.resources.impl.AtomixTestBase;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTreeEvent;
import org.onosproject.store.service.DocumentTreeListener;
import org.onosproject.store.service.IllegalDocumentModificationException;
import org.onosproject.store.service.NoSuchDocumentPathException;
import org.onosproject.store.service.Versioned;

public class AtomixDocumentTreeTest
extends AtomixTestBase {
    @BeforeClass
    public static void preTestSetup() throws Throwable {
        AtomixDocumentTreeTest.createCopycatServers(3);
    }

    @AfterClass
    public static void postTestCleanup() throws Exception {
        AtomixDocumentTreeTest.clearTests();
    }

    @Override
    protected ResourceType resourceType() {
        return new ResourceType(AtomixDocumentTree.class);
    }

    @Test
    public void testQueries() throws Throwable {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        Versioned root = (Versioned)tree.get(DocumentPath.from((String)"root")).join();
        Assert.assertEquals((long)1L, (long)root.version());
        Assert.assertNull((Object)root.value());
    }

    @Test
    public void testCreate() throws Throwable {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        tree.create(DocumentPath.from((String)"root.a"), "a".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.b"), "ab".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.c"), "ac".getBytes()).join();
        Versioned a = (Versioned)tree.get(DocumentPath.from((String)"root.a")).join();
        Assert.assertArrayEquals((byte[])"a".getBytes(), (byte[])((byte[])a.value()));
        Versioned ab = (Versioned)tree.get(DocumentPath.from((String)"root.a.b")).join();
        Assert.assertArrayEquals((byte[])"ab".getBytes(), (byte[])((byte[])ab.value()));
        Versioned ac = (Versioned)tree.get(DocumentPath.from((String)"root.a.c")).join();
        Assert.assertArrayEquals((byte[])"ac".getBytes(), (byte[])((byte[])ac.value()));
    }

    @Test
    public void testSet() throws Throwable {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        tree.create(DocumentPath.from((String)"root.a"), "a".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.b"), "ab".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.c"), "ac".getBytes()).join();
        tree.set(DocumentPath.from((String)"root.a.d"), "ad".getBytes()).join();
        Versioned ad = (Versioned)tree.get(DocumentPath.from((String)"root.a.d")).join();
        Assert.assertArrayEquals((byte[])"ad".getBytes(), (byte[])((byte[])ad.value()));
        tree.set(DocumentPath.from((String)"root.a"), "newA".getBytes()).join();
        Versioned newA = (Versioned)tree.get(DocumentPath.from((String)"root.a")).join();
        Assert.assertArrayEquals((byte[])"newA".getBytes(), (byte[])((byte[])newA.value()));
        tree.set(DocumentPath.from((String)"root.a.b"), "newAB".getBytes()).join();
        Versioned newAB = (Versioned)tree.get(DocumentPath.from((String)"root.a.b")).join();
        Assert.assertArrayEquals((byte[])"newAB".getBytes(), (byte[])((byte[])newAB.value()));
    }

    @Test
    public void testReplaceVersion() throws Throwable {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        tree.create(DocumentPath.from((String)"root.a"), "a".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.b"), "ab".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.c"), "ac".getBytes()).join();
        Versioned ab = (Versioned)tree.get(DocumentPath.from((String)"root.a.b")).join();
        Assert.assertTrue((boolean)((Boolean)tree.replace(DocumentPath.from((String)"root.a.b"), "newAB".getBytes(), ab.version()).join()));
        Versioned newAB = (Versioned)tree.get(DocumentPath.from((String)"root.a.b")).join();
        Assert.assertArrayEquals((byte[])"newAB".getBytes(), (byte[])((byte[])newAB.value()));
        Assert.assertFalse((boolean)((Boolean)tree.replace(DocumentPath.from((String)"root.a.b"), "newestAB".getBytes(), ab.version()).join()));
        Assert.assertArrayEquals((byte[])"newAB".getBytes(), (byte[])((byte[])((Versioned)tree.get(DocumentPath.from((String)"root.a.b")).join()).value()));
        Assert.assertFalse((boolean)((Boolean)tree.replace(DocumentPath.from((String)"root.a.d"), "foo".getBytes(), 1L).join()));
    }

    @Test
    public void testReplaceValue() throws Throwable {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        tree.create(DocumentPath.from((String)"root.a"), "a".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.b"), "ab".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.c"), "ac".getBytes()).join();
        Versioned ab = (Versioned)tree.get(DocumentPath.from((String)"root.a.b")).join();
        Assert.assertTrue((boolean)((Boolean)tree.replace(DocumentPath.from((String)"root.a.b"), "newAB".getBytes(), (byte[])ab.value()).join()));
        Versioned newAB = (Versioned)tree.get(DocumentPath.from((String)"root.a.b")).join();
        Assert.assertArrayEquals((byte[])"newAB".getBytes(), (byte[])((byte[])newAB.value()));
        Assert.assertFalse((boolean)((Boolean)tree.replace(DocumentPath.from((String)"root.a.b"), "newestAB".getBytes(), (byte[])ab.value()).join()));
        Assert.assertArrayEquals((byte[])"newAB".getBytes(), (byte[])((byte[])((Versioned)tree.get(DocumentPath.from((String)"root.a.b")).join()).value()));
        Assert.assertFalse((boolean)((Boolean)tree.replace(DocumentPath.from((String)"root.a.d"), "bar".getBytes(), "foo".getBytes()).join()));
    }

    @Test
    public void testRemove() throws Throwable {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        tree.create(DocumentPath.from((String)"root.a"), "a".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.b"), "ab".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.c"), "ac".getBytes()).join();
        Versioned ab = (Versioned)tree.removeNode(DocumentPath.from((String)"root.a.b")).join();
        Assert.assertArrayEquals((byte[])"ab".getBytes(), (byte[])((byte[])ab.value()));
        Assert.assertNull(tree.get(DocumentPath.from((String)"root.a.b")).join());
        Versioned ac = (Versioned)tree.removeNode(DocumentPath.from((String)"root.a.c")).join();
        Assert.assertArrayEquals((byte[])"ac".getBytes(), (byte[])((byte[])ac.value()));
        Assert.assertNull(tree.get(DocumentPath.from((String)"root.a.c")).join());
        Versioned a = (Versioned)tree.removeNode(DocumentPath.from((String)"root.a")).join();
        Assert.assertArrayEquals((byte[])"a".getBytes(), (byte[])((byte[])a.value()));
        Assert.assertNull(tree.get(DocumentPath.from((String)"root.a")).join());
    }

    @Test
    public void testRemoveFailures() throws Throwable {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        tree.create(DocumentPath.from((String)"root.a"), "a".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.b"), "ab".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.c"), "ac".getBytes()).join();
        try {
            tree.removeNode(DocumentPath.from((String)"root")).join();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(Throwables.getRootCause((Throwable)e) instanceof IllegalDocumentModificationException));
        }
        try {
            tree.removeNode(DocumentPath.from((String)"root.a")).join();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(Throwables.getRootCause((Throwable)e) instanceof IllegalDocumentModificationException));
        }
        try {
            tree.removeNode(DocumentPath.from((String)"root.d")).join();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(Throwables.getRootCause((Throwable)e) instanceof NoSuchDocumentPathException));
        }
    }

    @Test
    public void testCreateFailures() throws Throwable {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        try {
            tree.create(DocumentPath.from((String)"root.a.c"), "ac".getBytes()).join();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(Throwables.getRootCause((Throwable)e) instanceof IllegalDocumentModificationException));
        }
    }

    @Test
    public void testSetFailures() throws Throwable {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        try {
            tree.set(DocumentPath.from((String)"root.a.c"), "ac".getBytes()).join();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(Throwables.getRootCause((Throwable)e) instanceof IllegalDocumentModificationException));
        }
    }

    @Test
    public void testGetChildren() throws Throwable {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        tree.create(DocumentPath.from((String)"root.a"), "a".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.b"), "ab".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.c"), "ac".getBytes()).join();
        Map rootChildren = (Map)tree.getChildren(DocumentPath.from((String)"root")).join();
        Assert.assertEquals((long)1L, (long)rootChildren.size());
        Versioned a = (Versioned)rootChildren.get("a");
        Assert.assertArrayEquals((byte[])"a".getBytes(), (byte[])((byte[])a.value()));
        Map children = (Map)tree.getChildren(DocumentPath.from((String)"root.a")).join();
        Assert.assertEquals((long)2L, (long)children.size());
        Versioned ab = (Versioned)children.get("b");
        Assert.assertArrayEquals((byte[])"ab".getBytes(), (byte[])((byte[])ab.value()));
        Versioned ac = (Versioned)children.get("c");
        Assert.assertArrayEquals((byte[])"ac".getBytes(), (byte[])((byte[])ac.value()));
        Assert.assertEquals((long)0L, (long)((Map)tree.getChildren(DocumentPath.from((String)"root.a.b")).join()).size());
        Assert.assertEquals((long)0L, (long)((Map)tree.getChildren(DocumentPath.from((String)"root.a.c")).join()).size());
    }

    @Test
    public void testClear() {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        tree.create(DocumentPath.from((String)"root.a"), "a".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.b"), "ab".getBytes()).join();
        tree.create(DocumentPath.from((String)"root.a.c"), "ac".getBytes()).join();
        tree.destroy().join();
        Assert.assertEquals((long)0L, (long)((Map)tree.getChildren(DocumentPath.from((String)"root")).join()).size());
    }

    @Test
    @Ignore
    public void testNotifications() throws Exception {
        AtomixDocumentTree tree = (AtomixDocumentTree)this.createAtomixClient().getResource(UUID.randomUUID().toString(), AtomixDocumentTree.class).join();
        TestEventListener listener = new TestEventListener();
        ((CompletableFuture)tree.addListener((DocumentTreeListener)listener).thenCompose(v -> tree.set(DocumentPath.from((String)"root.a"), "a".getBytes()))).join();
        DocumentTreeEvent<byte[]> event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)DocumentTreeEvent.Type.CREATED, (Object)event.type());
        Assert.assertArrayEquals((byte[])"a".getBytes(), (byte[])((byte[])((Versioned)event.newValue().get()).value()));
    }

    private static class TestEventListener
    implements DocumentTreeListener<byte[]> {
        private final BlockingQueue<DocumentTreeEvent<byte[]>> queue = new ArrayBlockingQueue<DocumentTreeEvent<byte[]>>(1);

        private TestEventListener() {
        }

        public void event(DocumentTreeEvent<byte[]> event) {
            try {
                this.queue.put(event);
            }
            catch (InterruptedException e) {
                Throwables.propagate((Throwable)e);
            }
        }

        public DocumentTreeEvent<byte[]> event() throws InterruptedException {
            return this.queue.take();
        }
    }
}

