/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.PartitionId;
import org.onosproject.event.Change;
import org.onosproject.store.primitives.impl.Hasher;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.DistributedPrimitive;

public class PartitionedAsyncLeaderElector
implements AsyncLeaderElector {
    private final String name;
    private final TreeMap<PartitionId, AsyncLeaderElector> partitions = Maps.newTreeMap();
    private final Hasher<String> topicHasher;

    public PartitionedAsyncLeaderElector(String name, Map<PartitionId, AsyncLeaderElector> partitions, Hasher<String> topicHasher) {
        this.name = name;
        this.partitions.putAll((Map)Preconditions.checkNotNull(partitions));
        this.topicHasher = (Hasher)Preconditions.checkNotNull(topicHasher);
    }

    public String name() {
        return this.name;
    }

    public CompletableFuture<Leadership> run(String topic, NodeId nodeId) {
        return this.getLeaderElector(topic).run(topic, nodeId);
    }

    public CompletableFuture<Void> withdraw(String topic) {
        return this.getLeaderElector(topic).withdraw(topic);
    }

    public CompletableFuture<Boolean> anoint(String topic, NodeId nodeId) {
        return this.getLeaderElector(topic).anoint(topic, nodeId);
    }

    public CompletableFuture<Boolean> promote(String topic, NodeId nodeId) {
        return this.getLeaderElector(topic).promote(topic, nodeId);
    }

    public CompletableFuture<Void> evict(NodeId nodeId) {
        return CompletableFuture.allOf((CompletableFuture[])this.getLeaderElectors().stream().map(le -> le.evict(nodeId)).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Leadership> getLeadership(String topic) {
        return this.getLeaderElector(topic).getLeadership(topic);
    }

    public CompletableFuture<Map<String, Leadership>> getLeaderships() {
        ConcurrentMap leaderships = Maps.newConcurrentMap();
        return CompletableFuture.allOf((CompletableFuture[])this.getLeaderElectors().stream().map(le -> le.getLeaderships().thenAccept(m -> leaderships.putAll(m))).toArray(CompletableFuture[]::new)).thenApply(v -> leaderships);
    }

    public CompletableFuture<Void> addChangeListener(Consumer<Change<Leadership>> listener) {
        return CompletableFuture.allOf((CompletableFuture[])this.getLeaderElectors().stream().map(map -> map.addChangeListener(listener)).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Void> removeChangeListener(Consumer<Change<Leadership>> listener) {
        return CompletableFuture.allOf((CompletableFuture[])this.getLeaderElectors().stream().map(map -> map.removeChangeListener(listener)).toArray(CompletableFuture[]::new));
    }

    private AsyncLeaderElector getLeaderElector(String topic) {
        return this.partitions.get(this.topicHasher.hash(topic));
    }

    private Collection<AsyncLeaderElector> getLeaderElectors() {
        return this.partitions.values();
    }

    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.partitions.values().forEach(elector -> elector.addStatusChangeListener(listener));
    }

    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.partitions.values().forEach(elector -> elector.removeStatusChangeListener(listener));
    }

    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        throw new UnsupportedOperationException();
    }
}

