/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.StorageLevel;
import io.atomix.manager.internal.ResourceManagerState;
import io.atomix.manager.util.ResourceManagerTypeResolver;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.onosproject.store.primitives.impl.Managed;
import org.onosproject.store.primitives.impl.StoragePartition;
import org.onosproject.store.primitives.impl.StoragePartitionDetails;
import org.onosproject.store.service.PartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePartitionServer
implements Managed<StoragePartitionServer> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_ENTRIES_PER_LOG_SEGMENT = 32768;
    private final StoragePartition partition;
    private final Address localAddress;
    private final Supplier<Transport> transport;
    private final Serializer serializer;
    private final File dataFolder;
    private CopycatServer server;

    public StoragePartitionServer(Address localAddress, StoragePartition partition, Serializer serializer, Supplier<Transport> transport, File dataFolder) {
        this.partition = partition;
        this.localAddress = localAddress;
        this.serializer = serializer;
        this.transport = transport;
        this.dataFolder = dataFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> open() {
        CompletableFuture serverOpenFuture;
        if (this.partition.getMemberAddresses().contains(this.localAddress)) {
            if (this.server != null && this.server.isRunning()) {
                return CompletableFuture.completedFuture(null);
            }
            StoragePartitionServer storagePartitionServer = this;
            synchronized (storagePartitionServer) {
                this.server = this.buildServer();
            }
            serverOpenFuture = this.server.bootstrap(this.partition.getMemberAddresses());
        } else {
            serverOpenFuture = CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)serverOpenFuture.whenComplete((r, e) -> {
            if (e == null) {
                this.log.info("Successfully started server for partition {}", (Object)this.partition.getId());
            } else {
                this.log.info("Failed to start server for partition {}", (Object)this.partition.getId(), e);
            }
        })).thenApply(v -> null);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.server.shutdown();
    }

    public CompletableFuture<Void> closeAndExit() {
        return this.server.leave();
    }

    private CopycatServer buildServer() {
        CopycatServer server = CopycatServer.builder((Address)this.localAddress).withName("partition-" + this.partition.getId()).withSerializer(this.serializer.clone()).withTransport(this.transport.get()).withStateMachine(ResourceManagerState::new).withStorage(Storage.builder().withStorageLevel(StorageLevel.DISK).withCompactionThreads(1).withDirectory(this.dataFolder).withMaxEntriesPerSegment(32768).build()).build();
        server.serializer().resolve(new SerializableTypeResolver[]{new ResourceManagerTypeResolver()});
        return server;
    }

    public CompletableFuture<Void> join(Collection<Address> otherMembers) {
        this.server = this.buildServer();
        return ((CompletableFuture)this.server.join(otherMembers).whenComplete((r, e) -> {
            if (e == null) {
                this.log.info("Successfully joined partition {}", (Object)this.partition.getId());
            } else {
                this.log.info("Failed to join partition {}", (Object)this.partition.getId(), e);
            }
        })).thenApply(v -> null);
    }

    @Override
    public boolean isOpen() {
        return this.server.isRunning();
    }

    public PartitionInfo info() {
        return new StoragePartitionDetails(this.partition.getId(), this.server.cluster().members(), this.server.cluster().members(), this.server.cluster().leader(), this.server.cluster().term()).toPartitionInfo();
    }
}

