/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.collect.Maps;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ResourceTypeInfo;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.onlab.util.Match;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentTreeMapCommands;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentTreeMapFactory;
import org.onosproject.store.primitives.resources.impl.MapEntryUpdateResult;
import org.onosproject.store.service.AsyncConsistentTreeMap;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.MapTransaction;
import org.onosproject.store.service.Versioned;

@ResourceTypeInfo(id=-155, factory=AtomixConsistentTreeMapFactory.class)
public class AtomixConsistentTreeMap
extends AbstractResource<AtomixConsistentTreeMap>
implements AsyncConsistentTreeMap<byte[]> {
    private final Map<MapEventListener<String, byte[]>, Executor> mapEventListeners = Maps.newConcurrentMap();
    public static final String CHANGE_SUBJECT = "changeEvents";

    public AtomixConsistentTreeMap(CopycatClient client, Properties options) {
        super(client, options);
    }

    public String name() {
        return null;
    }

    public CompletableFuture<AtomixConsistentTreeMap> open() {
        return super.open().thenApply(result -> {
            this.client.onEvent(CHANGE_SUBJECT, this::handleEvent);
            return result;
        });
    }

    private void handleEvent(List<MapEvent<String, byte[]>> events) {
        events.forEach(event -> this.mapEventListeners.forEach((listener, executor) -> executor.execute(() -> listener.event(event))));
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.client.submit((Query)new AtomixConsistentTreeMapCommands.IsEmpty());
    }

    public CompletableFuture<Integer> size() {
        return this.client.submit((Query)new AtomixConsistentTreeMapCommands.Size());
    }

    public CompletableFuture<Boolean> containsKey(String key) {
        return this.client.submit((Query)new AtomixConsistentTreeMapCommands.ContainsKey(key));
    }

    public CompletableFuture<Boolean> containsValue(byte[] value) {
        return this.client.submit((Query)new AtomixConsistentTreeMapCommands.ContainsValue(value));
    }

    public CompletableFuture<Versioned<byte[]>> get(String key) {
        return this.client.submit((Query)new AtomixConsistentTreeMapCommands.Get(key));
    }

    public CompletableFuture<Set<String>> keySet() {
        return this.client.submit((Query)new AtomixConsistentTreeMapCommands.KeySet());
    }

    public CompletableFuture<Collection<Versioned<byte[]>>> values() {
        return this.client.submit((Query)new AtomixConsistentTreeMapCommands.Values());
    }

    public CompletableFuture<Set<Map.Entry<String, Versioned<byte[]>>>> entrySet() {
        return this.client.submit((Query)new AtomixConsistentTreeMapCommands.EntrySet());
    }

    public CompletableFuture<Versioned<byte[]>> put(String key, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentTreeMapCommands.UpdateAndGet(key, value, (Match<byte[]>)Match.ANY, (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.oldValue());
    }

    public CompletableFuture<Versioned<byte[]>> putAndGet(String key, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentTreeMapCommands.UpdateAndGet(key, value, (Match<byte[]>)Match.ANY, (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.newValue());
    }

    public CompletableFuture<Versioned<byte[]>> putIfAbsent(String key, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentTreeMapCommands.UpdateAndGet(key, value, (Match<byte[]>)Match.NULL, (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.oldValue());
    }

    public CompletableFuture<Versioned<byte[]>> remove(String key) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentTreeMapCommands.UpdateAndGet(key, null, (Match<byte[]>)Match.ANY, (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.oldValue());
    }

    public CompletableFuture<Boolean> remove(String key, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentTreeMapCommands.UpdateAndGet(key, null, (Match<byte[]>)Match.ifValue((Object)value), (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.updated());
    }

    public CompletableFuture<Boolean> remove(String key, long version) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentTreeMapCommands.UpdateAndGet(key, null, (Match<byte[]>)Match.ANY, (Match<Long>)Match.ifValue((Object)version))).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.updated());
    }

    public CompletableFuture<Versioned<byte[]>> replace(String key, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentTreeMapCommands.UpdateAndGet(key, value, (Match<byte[]>)Match.NOT_NULL, (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.oldValue());
    }

    public CompletableFuture<Boolean> replace(String key, byte[] oldValue, byte[] newValue) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentTreeMapCommands.UpdateAndGet(key, newValue, (Match<byte[]>)Match.ifValue((Object)oldValue), (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.updated());
    }

    public CompletableFuture<Boolean> replace(String key, long oldVersion, byte[] newValue) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentTreeMapCommands.UpdateAndGet(key, newValue, (Match<byte[]>)Match.ANY, (Match<Long>)Match.ifValue((Object)oldVersion))).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.updated());
    }

    public CompletableFuture<Void> clear() {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentTreeMapCommands.Clear()).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult.Status)((Object)r)))).thenApply(v -> null);
    }

    public CompletableFuture<Versioned<byte[]>> computeIf(String key, Predicate<? super byte[]> condition, BiFunction<? super String, ? super byte[], ? extends byte[]> remappingFunction) {
        return this.get(key).thenCompose(r1 -> {
            byte[] existingValue;
            byte[] byArray = existingValue = r1 == null ? null : (byte[])r1.value();
            if (!condition.test(existingValue)) {
                return CompletableFuture.completedFuture(r1);
            }
            AtomicReference computedValue = new AtomicReference();
            try {
                computedValue.set(remappingFunction.apply(key, existingValue));
            }
            catch (Exception e2) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e2);
                return future;
            }
            if (computedValue.get() == null && r1 == null) {
                return CompletableFuture.completedFuture(null);
            }
            Match valueMatch = r1 == null ? Match.NULL : Match.ANY;
            Match versionMatch = r1 == null ? Match.ANY : Match.ifValue((Object)r1.version());
            return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentTreeMapCommands.UpdateAndGet(key, (byte[])computedValue.get(), (Match<byte[]>)valueMatch, (Match<Long>)versionMatch)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.newValue());
        });
    }

    public CompletableFuture<Void> addListener(MapEventListener<String, byte[]> listener, Executor executor) {
        if (this.mapEventListeners.isEmpty()) {
            return this.client.submit((Command)new AtomixConsistentTreeMapCommands.Listen()).thenRun(() -> this.mapEventListeners.put(listener, executor));
        }
        this.mapEventListeners.put(listener, executor);
        return CompletableFuture.completedFuture(null);
    }

    public synchronized CompletableFuture<Void> removeListener(MapEventListener<String, byte[]> listener) {
        if (this.mapEventListeners.remove(listener) != null && this.mapEventListeners.isEmpty()) {
            return this.client.submit((Command)new AtomixConsistentTreeMapCommands.Unlisten()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void throwIfLocked(MapEntryUpdateResult.Status status) {
        if (status == MapEntryUpdateResult.Status.WRITE_LOCK) {
            throw new ConcurrentModificationException("Cannot update TreeMap: another update is in progress.");
        }
    }

    public CompletableFuture<String> firstKey() {
        return this.client.submit(new AtomixConsistentTreeMapCommands.FirstKey());
    }

    public CompletableFuture<String> lastKey() {
        return this.client.submit(new AtomixConsistentTreeMapCommands.LastKey());
    }

    public CompletableFuture<Map.Entry<String, Versioned<byte[]>>> ceilingEntry(String key) {
        return this.client.submit(new AtomixConsistentTreeMapCommands.CeilingEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<byte[]>>> floorEntry(String key) {
        return this.client.submit(new AtomixConsistentTreeMapCommands.FloorEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<byte[]>>> higherEntry(String key) {
        return this.client.submit(new AtomixConsistentTreeMapCommands.HigherEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<byte[]>>> lowerEntry(String key) {
        return this.client.submit(new AtomixConsistentTreeMapCommands.LowerEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<byte[]>>> firstEntry() {
        return this.client.submit(new AtomixConsistentTreeMapCommands.FirstEntry());
    }

    public CompletableFuture<Map.Entry<String, Versioned<byte[]>>> lastEntry() {
        return this.client.submit(new AtomixConsistentTreeMapCommands.LastEntry());
    }

    public CompletableFuture<Map.Entry<String, Versioned<byte[]>>> pollFirstEntry() {
        return this.client.submit(new AtomixConsistentTreeMapCommands.PollFirstEntry());
    }

    public CompletableFuture<Map.Entry<String, Versioned<byte[]>>> pollLastEntry() {
        return this.client.submit(new AtomixConsistentTreeMapCommands.PollLastEntry());
    }

    public CompletableFuture<String> lowerKey(String key) {
        return this.client.submit(new AtomixConsistentTreeMapCommands.LowerKey(key));
    }

    public CompletableFuture<String> floorKey(String key) {
        return this.client.submit(new AtomixConsistentTreeMapCommands.FloorKey(key));
    }

    public CompletableFuture<String> ceilingKey(String key) {
        return this.client.submit(new AtomixConsistentTreeMapCommands.CeilingKey(key));
    }

    public CompletableFuture<String> higherKey(String key) {
        return this.client.submit(new AtomixConsistentTreeMapCommands.HigherKey(key));
    }

    public CompletableFuture<NavigableSet<String>> navigableKeySet() {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    public CompletableFuture<NavigableMap<String, byte[]>> subMap(String upperKey, String lowerKey, boolean inclusiveUpper, boolean inclusiveLower) {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    public CompletableFuture<Boolean> prepareAndCommit(MapTransaction<String, byte[]> transaction) {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    public CompletableFuture<Boolean> prepare(MapTransaction<String, byte[]> transaction) {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }
}

