/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.store.LogicalTimestamp;
import org.onosproject.store.Timestamp;
import org.onosproject.store.primitives.impl.MapValue;

public class MapValueTest {
    @Test
    public void testConstruction() {
        LogicalTimestamp ts = new LogicalTimestamp(10L);
        MapValue mv = new MapValue((Object)"foo", (Timestamp)ts);
        Assert.assertEquals((Object)"foo", (Object)mv.get());
        Assert.assertEquals((Object)ts, (Object)mv.timestamp());
        Assert.assertTrue((boolean)mv.isAlive());
    }

    @Test
    public void testDigest() {
        LogicalTimestamp ts = new LogicalTimestamp(10L);
        MapValue mv = new MapValue((Object)"foo", (Timestamp)ts);
        MapValue.Digest actual = mv.digest();
        MapValue.Digest expected = new MapValue.Digest((Timestamp)ts, false);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testComparison() {
        LogicalTimestamp ts1 = new LogicalTimestamp(9L);
        LogicalTimestamp ts2 = new LogicalTimestamp(10L);
        LogicalTimestamp ts3 = new LogicalTimestamp(11L);
        MapValue mv1 = new MapValue((Object)"foo", (Timestamp)ts1);
        MapValue mv2 = new MapValue((Object)"foo", (Timestamp)ts2);
        MapValue mv3 = new MapValue((Object)"foo", (Timestamp)ts3);
        Assert.assertTrue((boolean)mv2.isNewerThan(mv1));
        Assert.assertFalse((boolean)mv1.isNewerThan(mv3));
        Assert.assertTrue((boolean)mv3.isNewerThan((Timestamp)ts2));
        Assert.assertFalse((boolean)mv1.isNewerThan((Timestamp)ts2));
        Assert.assertTrue((mv1.compareTo(mv2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((mv1.compareTo(mv1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mv3.compareTo(mv2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTombstone() {
        LogicalTimestamp ts1 = new LogicalTimestamp(9L);
        MapValue mv = MapValue.tombstone((Timestamp)ts1);
        Assert.assertTrue((boolean)mv.isTombstone());
        Assert.assertFalse((boolean)mv.isAlive());
        Assert.assertNull((Object)mv.get());
        Assert.assertEquals((Object)ts1, (Object)mv.timestamp());
    }
}

