/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.store.primitives.resources.impl.DefaultDocumentTree;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.IllegalDocumentModificationException;
import org.onosproject.store.service.NoSuchDocumentPathException;
import org.onosproject.store.service.Versioned;

public class DefaultDocumentTreeTest {
    @Test
    public void testTreeConstructor() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        Assert.assertEquals((Object)tree.root(), (Object)DefaultDocumentTreeTest.path("root"));
    }

    @Test
    public void testCreateNodeAtRoot() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        Assert.assertTrue((boolean)tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar"));
        Assert.assertFalse((boolean)tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"baz"));
    }

    @Test
    public void testCreateNodeAtNonRoot() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar");
        Assert.assertTrue((boolean)tree.create(DefaultDocumentTreeTest.path("root.a.b"), (Object)"baz"));
    }

    @Test
    public void testCreateRecursive() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.createRecursive(DefaultDocumentTreeTest.path("root.a.b.c"), (Object)"bar");
        Assert.assertEquals((Object)tree.get(DefaultDocumentTreeTest.path("root.a.b.c")).value(), (Object)"bar");
        Assert.assertNull((Object)tree.get(DefaultDocumentTreeTest.path("root.a.b")).value());
        Assert.assertNull((Object)tree.get(DefaultDocumentTreeTest.path("root.a")).value());
    }

    @Test(expected=IllegalDocumentModificationException.class)
    public void testCreateRecursiveRoot() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.createRecursive(DefaultDocumentTreeTest.path("root"), (Object)"bar");
    }

    @Test(expected=IllegalDocumentModificationException.class)
    public void testCreateNodeFailure() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a.b"), (Object)"bar");
    }

    @Test
    public void testGetRootValue() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar");
        tree.create(DefaultDocumentTreeTest.path("root.a.b"), (Object)"baz");
        Versioned root = tree.get(DefaultDocumentTreeTest.path("root"));
        Assert.assertNotNull((Object)root);
        Assert.assertNull((Object)root.value());
    }

    @Test
    public void testGetInnerNode() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar");
        tree.create(DefaultDocumentTreeTest.path("root.a.b"), (Object)"baz");
        Versioned nodeValue = tree.get(DefaultDocumentTreeTest.path("root.a"));
        Assert.assertNotNull((Object)nodeValue);
        Assert.assertEquals((Object)"bar", (Object)nodeValue.value());
    }

    @Test
    public void testGetLeafNode() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar");
        tree.create(DefaultDocumentTreeTest.path("root.a.b"), (Object)"baz");
        Versioned nodeValue = tree.get(DefaultDocumentTreeTest.path("root.a.b"));
        Assert.assertNotNull((Object)nodeValue);
        Assert.assertEquals((Object)"baz", (Object)nodeValue.value());
    }

    @Test
    public void getMissingNode() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar");
        tree.create(DefaultDocumentTreeTest.path("root.a.b"), (Object)"baz");
        Assert.assertNull((Object)tree.get(DefaultDocumentTreeTest.path("root.x")));
        Assert.assertNull((Object)tree.get(DefaultDocumentTreeTest.path("root.a.x")));
        Assert.assertNull((Object)tree.get(DefaultDocumentTreeTest.path("root.a.b.x")));
    }

    @Test
    public void testGetChildren() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar");
        tree.create(DefaultDocumentTreeTest.path("root.a.b"), (Object)"alpha");
        tree.create(DefaultDocumentTreeTest.path("root.a.c"), (Object)"beta");
        Assert.assertEquals((long)2L, (long)tree.getChildren(DefaultDocumentTreeTest.path("root.a")).size());
        Assert.assertEquals((long)0L, (long)tree.getChildren(DefaultDocumentTreeTest.path("root.a.b")).size());
    }

    @Test(expected=NoSuchDocumentPathException.class)
    public void testGetChildrenFailure() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar");
        tree.getChildren(DefaultDocumentTreeTest.path("root.a.b"));
    }

    @Test(expected=IllegalDocumentModificationException.class)
    public void testSetRootFailure() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.set(tree.root(), (Object)"bar");
    }

    @Test
    public void testSet() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar");
        Assert.assertNull((Object)tree.set(DefaultDocumentTreeTest.path("root.a.b"), (Object)"alpha"));
        Assert.assertEquals((Object)"alpha", (Object)tree.set(DefaultDocumentTreeTest.path("root.a.b"), (Object)"beta").value());
        Assert.assertEquals((Object)"beta", (Object)tree.get(DefaultDocumentTreeTest.path("root.a.b")).value());
    }

    @Test(expected=IllegalDocumentModificationException.class)
    public void testSetInvalidNode() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.set(DefaultDocumentTreeTest.path("root.a.b"), (Object)"alpha");
    }

    public void testReplaceWithVersion() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar");
        tree.create(DefaultDocumentTreeTest.path("root.a.b"), (Object)"alpha");
        Versioned value = tree.get(DefaultDocumentTreeTest.path("root.a.b"));
        Assert.assertTrue((boolean)tree.replace(DefaultDocumentTreeTest.path("root.a.b"), (Object)"beta", value.version()));
        Assert.assertFalse((boolean)tree.replace(DefaultDocumentTreeTest.path("root.a.b"), (Object)"beta", value.version()));
        Assert.assertFalse((boolean)tree.replace(DefaultDocumentTreeTest.path("root.x"), (Object)"beta", 1L));
    }

    public void testReplaceWithValue() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar");
        tree.create(DefaultDocumentTreeTest.path("root.a.b"), (Object)"alpha");
        Assert.assertTrue((boolean)tree.replace(DefaultDocumentTreeTest.path("root.a.b"), (Object)"beta", (Object)"alpha"));
        Assert.assertFalse((boolean)tree.replace(DefaultDocumentTreeTest.path("root.a.b"), (Object)"beta", (Object)"alpha"));
        Assert.assertFalse((boolean)tree.replace(DefaultDocumentTreeTest.path("root.x"), (Object)"beta", (Object)"bar"));
        Assert.assertTrue((boolean)tree.replace(DefaultDocumentTreeTest.path("root.x"), (Object)"beta", null));
    }

    @Test(expected=IllegalDocumentModificationException.class)
    public void testRemoveRoot() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.removeNode(tree.root());
    }

    @Test
    public void testRemove() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.create(DefaultDocumentTreeTest.path("root.a"), (Object)"bar");
        tree.create(DefaultDocumentTreeTest.path("root.a.b"), (Object)"alpha");
        Assert.assertEquals((Object)"alpha", (Object)tree.removeNode(DefaultDocumentTreeTest.path("root.a.b")).value());
        Assert.assertEquals((long)0L, (long)tree.getChildren(DefaultDocumentTreeTest.path("root.a")).size());
    }

    @Test(expected=NoSuchDocumentPathException.class)
    public void testRemoveInvalidNode() {
        DefaultDocumentTree tree = new DefaultDocumentTree();
        tree.removeNode(DefaultDocumentTreeTest.path("root.a"));
    }

    private static DocumentPath path(String path) {
        return DocumentPath.from((String)path);
    }
}

