/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Server;
import io.atomix.catalyst.transport.Transport;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.cluster.messaging.Endpoint;
import org.onosproject.store.cluster.messaging.MessagingService;
import org.onosproject.store.primitives.impl.CopycatTransportClient;
import org.onosproject.store.primitives.impl.CopycatTransportServer;

public class CopycatTransport
implements Transport {
    private final Mode mode;
    private final PartitionId partitionId;
    private final MessagingService messagingService;
    private static final Map<Address, Endpoint> EP_LOOKUP_CACHE = Maps.newConcurrentMap();
    private static final Map<Endpoint, Address> ADDRESS_LOOKUP_CACHE = Maps.newConcurrentMap();

    public CopycatTransport(Mode mode, PartitionId partitionId, MessagingService messagingService) {
        this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
        this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId);
        this.messagingService = (MessagingService)Preconditions.checkNotNull((Object)messagingService);
    }

    public Client client() {
        return new CopycatTransportClient(this.partitionId, this.messagingService, this.mode);
    }

    public Server server() {
        return new CopycatTransportServer(this.partitionId, this.messagingService);
    }

    public static Endpoint toEndpoint(Address address) {
        return EP_LOOKUP_CACHE.computeIfAbsent(address, a -> {
            try {
                return new Endpoint(IpAddress.valueOf((InetAddress)InetAddress.getByName(a.host())), a.port());
            }
            catch (UnknownHostException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        });
    }

    public static Address toAddress(Endpoint endpoint) {
        return ADDRESS_LOOKUP_CACHE.computeIfAbsent(endpoint, ep -> {
            try {
                InetAddress host = InetAddress.getByAddress(endpoint.host().toOctets());
                int port = endpoint.port();
                return new Address(new InetSocketAddress(host, port));
            }
            catch (UnknownHostException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        });
    }

    public static enum Mode {
        CLIENT,
        SERVER;

    }
}

