/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.onosproject.core.ApplicationId;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.MapTransaction;
import org.onosproject.store.service.Versioned;

public class DelegatingAsyncConsistentMap<K, V>
implements AsyncConsistentMap<K, V> {
    private final AsyncConsistentMap<K, V> delegateMap;

    DelegatingAsyncConsistentMap(AsyncConsistentMap<K, V> delegateMap) {
        this.delegateMap = (AsyncConsistentMap)Preconditions.checkNotNull(delegateMap, (Object)"delegate map cannot be null");
    }

    public String name() {
        return this.delegateMap.name();
    }

    public ApplicationId applicationId() {
        return this.delegateMap.applicationId();
    }

    public CompletableFuture<Integer> size() {
        return this.delegateMap.size();
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.delegateMap.containsKey(key);
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return this.delegateMap.containsValue(value);
    }

    public CompletableFuture<Versioned<V>> get(K key) {
        return this.delegateMap.get(key);
    }

    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.delegateMap.computeIf(key, condition, remappingFunction);
    }

    public CompletableFuture<Versioned<V>> put(K key, V value) {
        return this.delegateMap.put(key, value);
    }

    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        return this.delegateMap.putAndGet(key, value);
    }

    public CompletableFuture<Versioned<V>> remove(K key) {
        return this.delegateMap.remove(key);
    }

    public CompletableFuture<Void> clear() {
        return this.delegateMap.clear();
    }

    public CompletableFuture<Set<K>> keySet() {
        return this.delegateMap.keySet();
    }

    public CompletableFuture<Collection<Versioned<V>>> values() {
        return this.delegateMap.values();
    }

    public CompletableFuture<Set<Map.Entry<K, Versioned<V>>>> entrySet() {
        return this.delegateMap.entrySet();
    }

    public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
        return this.delegateMap.putIfAbsent(key, value);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.delegateMap.remove(key, value);
    }

    public CompletableFuture<Boolean> remove(K key, long version) {
        return this.delegateMap.remove(key, version);
    }

    public CompletableFuture<Versioned<V>> replace(K key, V value) {
        return this.delegateMap.replace(key, value);
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.delegateMap.replace(key, oldValue, newValue);
    }

    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        return this.delegateMap.replace(key, oldVersion, newValue);
    }

    public CompletableFuture<Void> addListener(MapEventListener<K, V> listener, Executor executor) {
        return this.delegateMap.addListener(listener, executor);
    }

    public CompletableFuture<Void> removeListener(MapEventListener<K, V> listener) {
        return this.delegateMap.removeListener(listener);
    }

    public CompletableFuture<Boolean> prepare(MapTransaction<K, V> transaction) {
        return this.delegateMap.prepare(transaction);
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return this.delegateMap.commit(transactionId);
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return this.delegateMap.rollback(transactionId);
    }

    public CompletableFuture<Boolean> prepareAndCommit(MapTransaction<K, V> transaction) {
        return this.delegateMap.prepareAndCommit(transaction);
    }

    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.delegateMap.addStatusChangeListener(listener);
    }

    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.delegateMap.removeStatusChangeListener(listener);
    }

    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return this.delegateMap.statusChangeListeners();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("delegateMap", this.delegateMap).toString();
    }

    public int hashCode() {
        return Objects.hash(this.delegateMap);
    }

    public boolean equals(Object other) {
        if (other instanceof DelegatingAsyncConsistentMap) {
            DelegatingAsyncConsistentMap that = (DelegatingAsyncConsistentMap)other;
            return this.delegateMap.equals(that.delegateMap);
        }
        return false;
    }
}

