/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.MoreObjects;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import java.util.Map;
import java.util.Optional;
import org.onlab.util.Match;
import org.onosproject.store.primitives.resources.impl.DocumentTreeUpdateResult;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.Versioned;

public class AtomixDocumentTreeCommands {

    public static class TypeResolver
    implements SerializableTypeResolver {
        public void resolve(SerializerRegistry registry) {
            registry.register(Get.class, -911);
            registry.register(GetChildren.class, -912);
            registry.register(Update.class, -913);
            registry.register(Listen.class, -914);
            registry.register(Unlisten.class, -915);
            registry.register(Clear.class, -916);
        }
    }

    public static class Unlisten
    extends DocumentTreeCommand<Void> {
        public Unlisten() {
            this(DocumentPath.from((String)"root"));
        }

        public Unlisten(DocumentPath path) {
            super(path);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("path", (Object)this.path()).toString();
        }
    }

    public static class Listen
    extends DocumentTreeCommand<Void> {
        public Listen() {
            this(DocumentPath.from((String)"root"));
        }

        public Listen(DocumentPath path) {
            super(path);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("path", (Object)this.path()).toString();
        }
    }

    public static class Clear
    implements Command<Void>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    public static class Update
    extends DocumentTreeCommand<DocumentTreeUpdateResult<byte[]>> {
        private Optional<byte[]> value;
        private Match<byte[]> valueMatch;
        private Match<Long> versionMatch;

        public Update() {
            super(null);
            this.value = null;
            this.valueMatch = null;
            this.versionMatch = null;
        }

        public Update(DocumentPath path, Optional<byte[]> value, Match<byte[]> valueMatch, Match<Long> versionMatch) {
            super(path);
            this.value = value;
            this.valueMatch = valueMatch;
            this.versionMatch = versionMatch;
        }

        public Optional<byte[]> value() {
            return this.value;
        }

        public Match<byte[]> valueMatch() {
            return this.valueMatch;
        }

        public Match<Long> versionMatch() {
            return this.versionMatch;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
            serializer.writeObject(this.valueMatch, buffer);
            serializer.writeObject(this.versionMatch, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = (Optional)serializer.readObject(buffer);
            this.valueMatch = (Match)serializer.readObject(buffer);
            this.versionMatch = (Match)serializer.readObject(buffer);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("path", (Object)this.path()).add("value", this.value).add("valueMatch", this.valueMatch).add("versionMatch", this.versionMatch).toString();
        }
    }

    public static class GetChildren
    extends DocumentTreeQuery<Map<String, Versioned<byte[]>>> {
        public GetChildren() {
            super(null);
        }

        public GetChildren(DocumentPath path) {
            super(path);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("path", (Object)this.path()).toString();
        }
    }

    public static class Get
    extends DocumentTreeQuery<Versioned<byte[]>> {
        public Get() {
            super(null);
        }

        public Get(DocumentPath path) {
            super(path);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("path", (Object)this.path()).toString();
        }
    }

    public static abstract class DocumentTreeCommand<V>
    extends DocumentTreeOperation<V>
    implements Command<V> {
        DocumentTreeCommand(DocumentPath path) {
            super(path);
        }
    }

    public static abstract class DocumentTreeQuery<V>
    extends DocumentTreeOperation<V>
    implements Query<V> {
        DocumentTreeQuery(DocumentPath path) {
            super(path);
        }

        public Query.ConsistencyLevel consistency() {
            return Query.ConsistencyLevel.SEQUENTIAL;
        }
    }

    public static abstract class DocumentTreeOperation<V>
    implements CatalystSerializable {
        private DocumentPath path;

        DocumentTreeOperation(DocumentPath path) {
            this.path = path;
        }

        public DocumentPath path() {
            return this.path;
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject((Object)this.path, buffer);
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.path = (DocumentPath)serializer.readObject(buffer);
        }
    }
}

