/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.MoreObjects;
import java.util.function.Function;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.Versioned;

public class MapEntryUpdateResult<K, V> {
    private final String mapName;
    private Status status;
    private final K key;
    private final Versioned<V> oldValue;
    private final Versioned<V> newValue;

    public MapEntryUpdateResult(Status status, String mapName, K key, Versioned<V> oldValue, Versioned<V> newValue) {
        this.status = status;
        this.mapName = mapName;
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public boolean updated() {
        return this.status == Status.OK;
    }

    public String mapName() {
        return this.mapName;
    }

    public Status status() {
        return this.status;
    }

    public K key() {
        return this.key;
    }

    public Versioned<V> oldValue() {
        return this.oldValue;
    }

    public Versioned<V> newValue() {
        return this.newValue;
    }

    public <K1, V1> MapEntryUpdateResult<K1, V1> map(Function<K, K1> keyTransform, Function<V, V1> valueMapper) {
        return new MapEntryUpdateResult<K1, V>(this.status, this.mapName, keyTransform.apply(this.key), this.oldValue == null ? null : this.oldValue.map(valueMapper), this.newValue == null ? null : this.newValue.map(valueMapper));
    }

    public MapEvent<K, V> toMapEvent() {
        if (!this.updated()) {
            return null;
        }
        return new MapEvent(this.mapName(), this.key(), this.newValue, this.oldValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper(MapEntryUpdateResult.class).add("mapName", (Object)this.mapName).add("status", (Object)this.status).add("key", this.key).add("oldValue", this.oldValue).add("newValue", this.newValue).toString();
    }

    public static enum Status {
        OK,
        NOOP,
        WRITE_LOCK,
        PRECONDITION_FAILED;

    }
}

