/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import io.atomix.resource.ResourceType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentSetMultimap;
import org.onosproject.store.primitives.resources.impl.AtomixTestBase;

public class AtomixConsistentSetMultimapTest
extends AtomixTestBase {
    private final String keyOne = "hello";
    private final String keyTwo = "goodbye";
    private final String keyThree = "foo";
    private final String keyFour = "bar";
    private final byte[] valueOne = Tools.getBytesUtf8((String)"hello");
    private final byte[] valueTwo = Tools.getBytesUtf8((String)"goodbye");
    private final byte[] valueThree = Tools.getBytesUtf8((String)"foo");
    private final byte[] valueFour = Tools.getBytesUtf8((String)"bar");
    private final List<String> allKeys = Lists.newArrayList((Object[])new String[]{"hello", "goodbye", "foo", "bar"});
    private final List<byte[]> allValues = Lists.newArrayList((Object[])new byte[][]{this.valueOne, this.valueTwo, this.valueThree, this.valueFour});

    @BeforeClass
    public static void preTestSetup() throws Throwable {
        AtomixConsistentSetMultimapTest.createCopycatServers(3);
    }

    @AfterClass
    public static void postTestCleanup() throws Exception {
        AtomixConsistentSetMultimapTest.clearTests();
    }

    @Override
    protected ResourceType resourceType() {
        return new ResourceType(AtomixConsistentSetMultimap.class);
    }

    @Test
    public void testSize() throws Throwable {
        AtomixConsistentSetMultimap map = this.createResource("testOneMap");
        map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result));
        ((CompletableFuture)map.put("hello", this.valueOne).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        map.isEmpty().thenAccept(result -> Assert.assertFalse((boolean)result));
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)1L, (long)result.intValue()))).join();
        ((CompletableFuture)map.put("hello", this.valueTwo).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)2L, (long)result.intValue()))).join();
        ((CompletableFuture)map.put("hello", this.valueOne).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)2L, (long)result.intValue()))).join();
        ((CompletableFuture)map.put("goodbye", this.valueOne).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ((CompletableFuture)map.put("goodbye", this.valueTwo).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)4L, (long)result.intValue()))).join();
        ((CompletableFuture)map.remove("hello", this.valueOne).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)3L, (long)result.intValue()))).join();
        ((CompletableFuture)map.remove("hello", this.valueOne).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)3L, (long)result.intValue()))).join();
        map.clear().join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)0L, (long)result.intValue()))).join();
        map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result));
        map.destroy().join();
    }

    @Test
    public void containsTest() throws Throwable {
        AtomixConsistentSetMultimap map = this.createResource("testTwoMap");
        this.allKeys.forEach(key -> ((CompletableFuture)map.putAll(key, this.allValues).thenAccept(result -> Assert.assertTrue((boolean)result))).join());
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)16L, (long)result.intValue()))).join();
        this.allKeys.forEach(key -> ((CompletableFuture)map.containsKey(key).thenAccept(result -> Assert.assertTrue((boolean)result))).join());
        this.allValues.forEach(value -> ((CompletableFuture)map.containsValue(value).thenAccept(result -> Assert.assertTrue((boolean)result))).join());
        this.allKeys.forEach(key -> this.allValues.forEach(value -> ((CompletableFuture)map.containsEntry(key, value).thenAccept(result -> Assert.assertTrue((boolean)result))).join()));
        this.allValues.forEach(value -> {
            String[] removedKey = new String[1];
            this.allKeys.forEach(key -> {
                ((CompletableFuture)map.remove(key, value).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
                ((CompletableFuture)map.containsEntry(key, value).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
                removedKey[0] = key;
            });
            map.containsKey(removedKey[0]).thenAccept(result -> Assert.assertFalse((boolean)result));
        });
        this.allValues.forEach(value -> ((CompletableFuture)map.containsValue(value).thenAccept(result -> Assert.assertFalse((boolean)result))).join());
        map.destroy().join();
    }

    @Test
    public void addAndRemoveTest() throws Exception {
        AtomixConsistentSetMultimap map = this.createResource("testThreeMap");
        this.allKeys.forEach(key -> this.allValues.forEach(value -> {
            ((CompletableFuture)map.put(key, value).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
            ((CompletableFuture)map.put(key, value).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        }));
        this.allKeys.forEach(key -> this.allValues.forEach(value -> {
            ((CompletableFuture)map.remove(key, value).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
            ((CompletableFuture)map.remove(key, value).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        }));
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        this.allKeys.forEach(key -> {
            ((CompletableFuture)map.putAll(key, (Collection)Lists.newArrayList(this.allValues.subList(0, 2))).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
            ((CompletableFuture)map.putAll(key, (Collection)Lists.newArrayList(this.allValues.subList(0, 2))).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
            ((CompletableFuture)map.putAll(key, (Collection)Lists.newArrayList(this.allValues.subList(2, 4))).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
            ((CompletableFuture)map.putAll(key, (Collection)Lists.newArrayList(this.allValues.subList(2, 4))).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        });
        this.allKeys.forEach(key -> {
            ((CompletableFuture)map.removeAll(key, (Collection)Lists.newArrayList(this.allValues.subList(0, 2))).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
            ((CompletableFuture)map.removeAll(key, (Collection)Lists.newArrayList(this.allValues.subList(0, 2))).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
            ((CompletableFuture)map.removeAll(key, (Collection)Lists.newArrayList(this.allValues.subList(2, 4))).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
            ((CompletableFuture)map.removeAll(key, (Collection)Lists.newArrayList(this.allValues.subList(2, 4))).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        });
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        this.allKeys.forEach(key -> ((CompletableFuture)map.putAll(key, this.allValues).thenAccept(result -> Assert.assertTrue((boolean)result))).join());
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)16L, (long)result.intValue()))).join();
        this.allKeys.forEach(key -> {
            ((CompletableFuture)map.removeAll(key).thenAccept(result -> Assert.assertTrue((boolean)this.byteArrayCollectionIsEqual(this.allValues, (Collection)result.value())))).join();
            ((CompletableFuture)map.removeAll(key).thenAccept(result -> Assert.assertFalse((boolean)this.byteArrayCollectionIsEqual(this.allValues, (Collection)result.value())))).join();
        });
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        this.allKeys.forEach(key -> ((CompletableFuture)map.putAll(key, this.allValues).thenAccept(result -> Assert.assertTrue((boolean)result))).join());
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)16L, (long)result.intValue()))).join();
        this.allKeys.forEach(key -> {
            ((CompletableFuture)map.replaceValues(key, this.allValues).thenAccept(result -> Assert.assertTrue((boolean)this.byteArrayCollectionIsEqual(this.allValues, (Collection)result.value())))).join();
            ((CompletableFuture)map.replaceValues(key, (Collection)Lists.newArrayList()).thenAccept(result -> Assert.assertTrue((boolean)this.byteArrayCollectionIsEqual(this.allValues, (Collection)result.value())))).join();
            ((CompletableFuture)map.replaceValues(key, this.allValues).thenAccept(result -> Assert.assertTrue((boolean)((Collection)result.value()).isEmpty()))).join();
        });
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)16L, (long)result.intValue()))).join();
        this.allKeys.forEach(key -> {
            ((CompletableFuture)map.remove(key, this.valueOne).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
            ((CompletableFuture)map.replaceValues(key, (Collection)Lists.newArrayList()).thenAccept(result -> Assert.assertTrue((boolean)this.byteArrayCollectionIsEqual(Lists.newArrayList((Object[])new byte[][]{this.valueTwo, this.valueThree, this.valueFour}), (Collection)result.value())))).join();
            ((CompletableFuture)map.replaceValues(key, this.allValues).thenAccept(result -> Assert.assertTrue((boolean)((Collection)result.value()).isEmpty()))).join();
        });
        map.destroy().join();
    }

    @Test
    public void testAccessors() throws Exception {
        AtomixConsistentSetMultimap map = this.createResource("testFourMap");
        this.allKeys.forEach(key -> ((CompletableFuture)map.putAll(key, this.allValues).thenAccept(result -> Assert.assertTrue((boolean)result))).join());
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)16L, (long)result.intValue()))).join();
        this.allKeys.forEach(key -> ((CompletableFuture)map.get(key).thenAccept(result -> Assert.assertTrue((boolean)this.byteArrayCollectionIsEqual(this.allValues, (Collection)result.value())))).join());
        ((CompletableFuture)map.keySet().thenAccept(result -> Assert.assertTrue((boolean)this.stringArrayCollectionIsEqual((Collection<? extends String>)this.allKeys, (Collection<? extends String>)result)))).join();
        ((CompletableFuture)map.values().thenAccept(result -> {
            TreeMultiset set = TreeMultiset.create((Comparator)new ByteArrayComparator());
            for (int i = 0; i < 4; ++i) {
                set.addAll(this.allValues);
            }
            Assert.assertEquals((long)16L, (long)result.size());
            result.forEach(arg_0 -> AtomixConsistentSetMultimapTest.lambda$null$79((Multiset)set, arg_0));
            Assert.assertTrue((boolean)set.isEmpty());
        })).join();
        ((CompletableFuture)map.keys().thenAccept(result -> {
            TreeMultiset set = TreeMultiset.create();
            for (int i = 0; i < 4; ++i) {
                set.addAll(this.allKeys);
            }
            Assert.assertEquals((long)16L, (long)result.size());
            result.forEach(arg_0 -> AtomixConsistentSetMultimapTest.lambda$null$81((Multiset)set, arg_0));
            Assert.assertTrue((boolean)set.isEmpty());
        })).join();
        ((CompletableFuture)map.entries().thenAccept(result -> {
            TreeMultiset set = TreeMultiset.create((Comparator)new EntryComparator());
            this.allKeys.forEach(arg_0 -> this.lambda$null$84((Multiset)set, arg_0));
            Assert.assertEquals((long)16L, (long)result.size());
            result.forEach(arg_0 -> AtomixConsistentSetMultimapTest.lambda$null$85((Multiset)set, arg_0));
            Assert.assertTrue((boolean)set.isEmpty());
        })).join();
        map.clear().join();
        this.allKeys.forEach(key -> ((CompletableFuture)map.get(key).thenAccept(result -> Assert.assertTrue((boolean)((Collection)result.value()).isEmpty()))).join());
        ((CompletableFuture)map.keySet().thenAccept(result -> Assert.assertTrue((boolean)result.isEmpty()))).join();
        ((CompletableFuture)map.values().thenAccept(result -> Assert.assertTrue((boolean)result.isEmpty()))).join();
        ((CompletableFuture)map.keys().thenAccept(result -> Assert.assertTrue((boolean)result.isEmpty()))).join();
        ((CompletableFuture)map.entries().thenAccept(result -> Assert.assertTrue((boolean)result.isEmpty()))).join();
        map.destroy().join();
    }

    private AtomixConsistentSetMultimap createResource(String mapName) {
        try {
            AtomixConsistentSetMultimap map = (AtomixConsistentSetMultimap)this.createAtomixClient().getResource(mapName, AtomixConsistentSetMultimap.class).join();
            return map;
        }
        catch (Throwable e) {
            throw new RuntimeException(e.toString());
        }
    }

    private boolean byteArrayCollectionIsEqual(Collection<? extends byte[]> o1, Collection<? extends byte[]> o2) {
        if (o1 == null || o2 == null || o1.size() != o2.size()) {
            return false;
        }
        for (byte[] byArray : o1) {
            boolean matched = false;
            for (byte[] byArray2 : o2) {
                if (!Arrays.equals(byArray, byArray2)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    private boolean stringArrayCollectionIsEqual(Collection<? extends String> s1, Collection<? extends String> s2) {
        if (s1 == null || s2 == null || s1.size() != s2.size()) {
            return false;
        }
        for (String string : s1) {
            boolean matched = false;
            for (String string2 : s2) {
                if (!string.equals(string2)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$null$85(Multiset set, Map.Entry entry) {
        Assert.assertTrue((boolean)set.remove((Object)entry));
    }

    private /* synthetic */ void lambda$null$84(Multiset set, String key) {
        this.allValues.forEach(value -> set.add((Object)new DefaultMapEntry((Object)key, value)));
    }

    private static /* synthetic */ void lambda$null$81(Multiset set, String value) {
        Assert.assertTrue((boolean)set.remove((Object)value));
    }

    private static /* synthetic */ void lambda$null$79(Multiset set, byte[] value) {
        Assert.assertTrue((boolean)set.remove((Object)value));
    }

    private class EntryComparator
    implements Comparator<Map.Entry<String, byte[]>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, byte[]> o1, Map.Entry<String, byte[]> o2) {
            if (o1 == null || o1.getKey() == null || o2 == null || o2.getKey() == null) {
                throw new IllegalArgumentException();
            }
            if (o1.getKey().equals(o2.getKey()) && Arrays.equals(o1.getValue(), o2.getValue())) {
                return 0;
            }
            return o1.getKey().compareTo(o2.getKey());
        }
    }

    private class ByteArrayComparator
    implements Comparator<byte[]> {
        private ByteArrayComparator() {
        }

        @Override
        public int compare(byte[] o1, byte[] o2) {
            if (Arrays.equals(o1, o2)) {
                return 0;
            }
            for (int i = 0; i < o1.length && i < o2.length; ++i) {
                if (o1[i] < o2[i]) {
                    return -1;
                }
                if (o1[i] <= o2[i]) continue;
                return 1;
            }
            return o1.length > o2.length ? 1 : -1;
        }
    }
}

