/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.util.concurrent.Uninterruptibles;
import io.atomix.AtomixClient;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.local.LocalServerRegistry;
import io.atomix.catalyst.transport.netty.NettyTransport;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.StorageLevel;
import io.atomix.manager.internal.ResourceManagerState;
import io.atomix.resource.ResourceType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.onlab.junit.TestTools;
import org.onosproject.store.primitives.impl.CatalystSerializers;

public abstract class AtomixTestBase {
    protected static LocalServerRegistry registry = new LocalServerRegistry();
    protected static List<Address> members = new ArrayList<Address>();
    protected static List<CopycatClient> copycatClients = new ArrayList<CopycatClient>();
    protected static List<CopycatServer> copycatServers = new ArrayList<CopycatServer>();
    protected static List<AtomixClient> atomixClients = new ArrayList<AtomixClient>();
    protected static List<CopycatServer> atomixServers = new ArrayList<CopycatServer>();
    protected static Serializer serializer = CatalystSerializers.getSerializer();
    protected static AtomicInteger port = new AtomicInteger(49200);

    protected abstract ResourceType resourceType();

    private static Address nextAddress() {
        Address address = new Address("127.0.0.1", TestTools.findAvailablePort((int)port.getAndIncrement()));
        members.add(address);
        return address;
    }

    protected static List<CopycatServer> createCopycatServers(int nodes) throws Throwable {
        ArrayList<CopycatServer> servers = new ArrayList<CopycatServer>();
        ArrayList<Address> members = new ArrayList<Address>();
        for (int i = 0; i < nodes; ++i) {
            Address address = AtomixTestBase.nextAddress();
            members.add(address);
            CopycatServer server = AtomixTestBase.createCopycatServer(address);
            if (members.size() <= 1) {
                server.bootstrap().join();
            } else {
                server.join(members).join();
            }
            servers.add(server);
        }
        return servers;
    }

    protected static CopycatServer createCopycatServer(Address address) {
        CopycatServer server = CopycatServer.builder((Address)address).withTransport(NettyTransport.builder().withThreads(1).build()).withStorage(Storage.builder().withStorageLevel(StorageLevel.MEMORY).build()).withStateMachine(ResourceManagerState::new).withSerializer(serializer.clone()).build();
        copycatServers.add(server);
        return server;
    }

    public static void clearTests() throws Exception {
        registry = new LocalServerRegistry();
        members = new ArrayList<Address>();
        CompletableFuture<Void> closeClients = CompletableFuture.allOf((CompletableFuture[])atomixClients.stream().map(AtomixClient::close).toArray(CompletableFuture[]::new));
        closeClients.join();
        CompletableFuture<Void> closeServers = CompletableFuture.allOf((CompletableFuture[])copycatServers.stream().map(CopycatServer::shutdown).toArray(CompletableFuture[]::new));
        closeServers.join();
        atomixClients.clear();
        copycatServers.clear();
    }

    protected AtomixClient createAtomixClient() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomixClient client = AtomixClient.builder().withTransport(NettyTransport.builder().withThreads(1).build()).withSerializer(serializer.clone()).build();
        client.connect(members).thenRun(latch::countDown);
        atomixClients.add(client);
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
        return client;
    }
}

