/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.MoreObjects;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.copycat.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.onosproject.store.service.Task;
import org.onosproject.store.service.WorkQueueStats;

public final class AtomixWorkQueueCommands {
    private AtomixWorkQueueCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        public void resolve(SerializerRegistry registry) {
            registry.register(Register.class, -960);
            registry.register(Unregister.class, -961);
            registry.register(Take.class, -962);
            registry.register(Add.class, -963);
            registry.register(Complete.class, -964);
            registry.register(Stats.class, -965);
            registry.register(Clear.class, -966);
        }
    }

    public static class Clear
    implements Command<Void>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }
    }

    public static class Complete
    implements Command<Void>,
    CatalystSerializable {
        private Collection<String> taskIds;

        private Complete() {
        }

        public Complete(Collection<String> taskIds) {
            this.taskIds = taskIds;
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.taskIds, buffer);
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.taskIds = (Collection)serializer.readObject(buffer);
        }

        public Collection<String> taskIds() {
            return this.taskIds;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("taskIds", this.taskIds).toString();
        }
    }

    public static class Unregister
    implements Command<Void>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }
    }

    public static class Register
    implements Command<Void>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }
    }

    public static class Stats
    implements Command<WorkQueueStats>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }
    }

    public static class Take
    implements Command<Collection<Task<byte[]>>>,
    CatalystSerializable {
        private int maxTasks;

        private Take() {
        }

        public Take(int maxTasks) {
            this.maxTasks = maxTasks;
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeInt(this.maxTasks);
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.maxTasks = buffer.readInt();
        }

        public int maxTasks() {
            return this.maxTasks;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("maxTasks", this.maxTasks).toString();
        }
    }

    public static class Add
    implements Command<Void>,
    CatalystSerializable {
        private Collection<byte[]> items;

        private Add() {
        }

        public Add(Collection<byte[]> items) {
            this.items = items;
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeInt(this.items.size());
            this.items.forEach(task -> serializer.writeObject(task, buffer));
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.items = IntStream.range(0, buffer.readInt()).mapToObj(i -> (byte[])serializer.readObject(buffer)).collect(Collectors.toCollection(ArrayList::new));
        }

        public Collection<byte[]> items() {
            return this.items;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("items", this.items).toString();
        }
    }
}

