/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.atomix.resource.ResourceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentTreeMap;
import org.onosproject.store.primitives.resources.impl.AtomixTestBase;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Versioned;

public class AtomixConsistentTreeMapTest
extends AtomixTestBase {
    private final String keyFour = "hello";
    private final String keyThree = "goodbye";
    private final String keyTwo = "foo";
    private final String keyOne = "bar";
    private final byte[] valueOne = Tools.getBytesUtf8((String)"bar");
    private final byte[] valueTwo = Tools.getBytesUtf8((String)"foo");
    private final byte[] valueThree = Tools.getBytesUtf8((String)"goodbye");
    private final byte[] valueFour = Tools.getBytesUtf8((String)"hello");
    private final byte[] spareValue = Tools.getBytesUtf8((String)"spareValue");
    private final List<String> allKeys = Lists.newArrayList((Object[])new String[]{"bar", "foo", "goodbye", "hello"});
    private final List<byte[]> allValues = Lists.newArrayList((Object[])new byte[][]{this.valueOne, this.valueTwo, this.valueThree, this.valueFour});

    @BeforeClass
    public static void preTestSetup() throws Throwable {
        AtomixConsistentTreeMapTest.createCopycatServers(3);
    }

    @AfterClass
    public static void postTestCleanup() throws Throwable {
        AtomixConsistentTreeMapTest.clearTests();
    }

    @Override
    protected ResourceType resourceType() {
        return new ResourceType(AtomixConsistentTreeMap.class);
    }

    @Test
    public void testBasicMapOperations() throws Throwable {
        AtomixConsistentTreeMap map = this.createResource("basicTestMap");
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)0L, (long)result.intValue()))).join();
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.containsKey(key).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        });
        this.allValues.forEach(value -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.containsValue(value).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.get(key).thenAccept(result -> Assert.assertNull((Object)result))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.put(key, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertNull((Object)result))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.containsKey(key).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        });
        this.allValues.forEach(value -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.containsValue(value).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.get(key).thenAccept(result -> Assert.assertArrayEquals((byte[])this.allValues.get(this.allKeys.indexOf(key)), (byte[])((byte[])result.value())))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.computeIfAbsent(key, v -> this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertArrayEquals((byte[])this.allValues.get(this.allKeys.indexOf(key)), (byte[])((byte[])result.value())))).join();
        });
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)4L, (long)result.intValue()))).join();
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.computeIfPresent(key, (k, v) -> null).thenAccept(result -> Assert.assertNull((Object)result))).join();
        });
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.compute(key, (k, v) -> this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertArrayEquals((byte[])this.allValues.get(this.allKeys.indexOf(key)), (byte[])((byte[])result.value())))).join();
        });
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)4L, (long)result.intValue()))).join();
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.computeIf(key, k -> this.allKeys.indexOf(key) < 2, (k, v) -> null).thenAccept(result -> {
                if (this.allKeys.indexOf(key) < 2) {
                    Assert.assertNull((Object)result);
                } else {
                    Assert.assertArrayEquals((byte[])this.allValues.get(this.allKeys.indexOf(key)), (byte[])((byte[])result.value()));
                }
            })).join();
        });
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)2L, (long)result.intValue()))).join();
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.put(key, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> {
                if (this.allKeys.indexOf(key) < 2) {
                    Assert.assertNull((Object)result);
                } else {
                    Assert.assertArrayEquals((byte[])this.allValues.get(this.allKeys.indexOf(key)), (byte[])((byte[])result.value()));
                }
            })).join();
        });
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)4L, (long)result.intValue()))).join();
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.putAndGet(key, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(firstResult -> map.putAndGet(key, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(secondResult -> {
                Assert.assertArrayEquals((byte[])this.allValues.get(this.allKeys.indexOf(key)), (byte[])((byte[])firstResult.value()));
                Assert.assertArrayEquals((byte[])this.allValues.get(this.allKeys.indexOf(key)), (byte[])((byte[])secondResult.value()));
                Assert.assertTrue((firstResult.version() + 1L == secondResult.version() ? 1 : 0) != 0);
            }))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.remove(key).thenAccept(result -> Assert.assertArrayEquals((byte[])this.allValues.get(this.allKeys.indexOf(key)), (byte[])((byte[])result.value())))).join();
        });
        map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result));
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.put(key, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertNull((Object)result))).join();
        });
        ((CompletableFuture)map.keySet().thenAccept(keys -> Assert.assertTrue((boolean)this.stringArrayCollectionIsEqual((Collection<? extends String>)keys, (Collection<? extends String>)this.allKeys)))).join();
        ((CompletableFuture)map.values().thenAccept(values -> Assert.assertTrue((boolean)this.byteArrayCollectionIsEqual(values.stream().map(v -> (byte[])v.value()).collect(Collectors.toSet()), this.allValues)))).join();
        ((CompletableFuture)map.entrySet().thenAccept(entrySet -> entrySet.forEach(entry -> {
            Assert.assertTrue((boolean)this.allKeys.contains(entry.getKey()));
            Assert.assertTrue((boolean)Arrays.equals((byte[])((Versioned)entry.getValue()).value(), this.allValues.get(this.allKeys.indexOf(entry.getKey()))));
        }))).join();
        map.clear().join();
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.putIfAbsent(key, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertNull((Object)result))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.putIfAbsent(key, null).thenAccept(result -> Assert.assertArrayEquals((byte[])((byte[])result.value()), (byte[])this.allValues.get(this.allKeys.indexOf(key))))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.remove(key, this.spareValue).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.remove(key, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        });
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        ArrayList versions = Lists.newArrayList();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.putAndGet(key, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> versions.add(result.version()))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.remove(key, ((Long)versions.get(0)).longValue()).thenAccept(result -> {
                Assert.assertTrue((boolean)result);
                versions.remove(0);
            })).join();
        });
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.put(key, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertNull((Object)result))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.replace(key, this.allValues.get(3 - this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertArrayEquals((byte[])this.allValues.get(this.allKeys.indexOf(key)), (byte[])((byte[])result.value())))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.replace(key, this.spareValue, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.replace(key, this.allValues.get(3 - this.allKeys.indexOf(key)), this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        });
        map.clear().join();
        ((CompletableFuture)map.isEmpty().thenAccept(result -> Assert.assertTrue((boolean)result))).join();
        versions.clear();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.putAndGet(key, this.allValues.get(3 - this.allKeys.indexOf(key))).thenAccept(result -> versions.add(result.version()))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.replace(key, 0L, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        });
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.replace(key, ((Long)versions.get(0)).longValue(), this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> {
                Assert.assertTrue((boolean)result);
                versions.remove(0);
            })).join();
        });
    }

    @Test
    public void mapListenerTests() throws Throwable {
        byte[] value1 = Tools.getBytesUtf8((String)"value1");
        byte[] value2 = Tools.getBytesUtf8((String)"value2");
        byte[] value3 = Tools.getBytesUtf8((String)"value3");
        AtomixConsistentTreeMap map = this.createResource("treeMapListenerTestMap");
        TestMapEventListener listener = new TestMapEventListener();
        ((CompletableFuture)map.addListener((MapEventListener)listener).thenCompose(v -> map.put("foo", value1))).join();
        MapEvent<String, byte[]> event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.INSERT, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value1, (byte[])event.newValue().value()));
        ((CompletableFuture)map.removeListener((MapEventListener)listener).thenCompose(v -> map.put("foo", value2))).join();
        Assert.assertFalse((boolean)listener.eventReceived());
        ((CompletableFuture)map.addListener((MapEventListener)listener).thenCompose(v -> map.put("foo", value3))).join();
        event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.UPDATE, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value3, (byte[])event.newValue().value()));
        map.putIfAbsent("foo", value1).join();
        Assert.assertFalse((boolean)listener.eventReceived());
        map.remove("foo").join();
        event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.REMOVE, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value3, (byte[])event.oldValue().value()));
        map.computeIf("foo", v -> v == null, (k, v) -> value1).join();
        event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.INSERT, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value1, (byte[])event.newValue().value()));
        map.compute((Object)"foo", (k, v) -> value2).join();
        event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.UPDATE, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value2, (byte[])event.newValue().value()));
        map.computeIf("foo", v -> Arrays.equals(v, value2), (k, v) -> null).join();
        event = listener.event();
        Assert.assertNotNull(event);
        Assert.assertEquals((Object)MapEvent.Type.REMOVE, (Object)event.type());
        Assert.assertTrue((boolean)Arrays.equals(value2, (byte[])event.oldValue().value()));
        map.removeListener((MapEventListener)listener).join();
    }

    @Test
    public void treeMapFunctionsTest() {
        AtomixConsistentTreeMap map = this.createResource("treeMapFunctionTestMap");
        ((CompletableFuture)map.firstKey().thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.lastKey().thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.ceilingEntry("bar").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.floorEntry("bar").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.higherEntry("bar").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.lowerEntry("bar").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.firstEntry().thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.lastEntry().thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.pollFirstEntry().thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.pollLastEntry().thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.lowerKey("bar").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.floorKey("bar").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.ceilingKey("bar").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.higherKey("bar").thenAccept(result -> Assert.assertNull((Object)result))).join();
        map.delete().join();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.put(key, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> Assert.assertNull((Object)result))).join();
        });
        ((CompletableFuture)map.firstKey().thenAccept(result -> Assert.assertEquals((Object)"bar", (Object)result))).join();
        ((CompletableFuture)map.lastKey().thenAccept(result -> Assert.assertEquals((Object)"hello", (Object)result))).join();
        ((CompletableFuture)map.ceilingEntry("bar").thenAccept(result -> {
            Assert.assertEquals((Object)"bar", result.getKey());
            Assert.assertArrayEquals((byte[])this.valueOne, (byte[])((byte[])((Versioned)result.getValue()).value()));
        })).join();
        ((CompletableFuture)map.ceilingEntry("bara").thenAccept(result -> {
            Assert.assertEquals((Object)"foo", result.getKey());
            Assert.assertArrayEquals((byte[])this.valueTwo, (byte[])((byte[])((Versioned)result.getValue()).value()));
        })).join();
        ((CompletableFuture)map.ceilingEntry("helloa").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.floorEntry("foo").thenAccept(result -> {
            Assert.assertEquals((Object)"foo", result.getKey());
            Assert.assertArrayEquals((byte[])this.valueTwo, (byte[])((byte[])((Versioned)result.getValue()).value()));
        })).join();
        ((CompletableFuture)map.floorEntry("foo".substring(0, 2)).thenAccept(result -> {
            Assert.assertEquals((Object)"bar", result.getKey());
            Assert.assertArrayEquals((byte[])this.valueOne, (byte[])((byte[])((Versioned)result.getValue()).value()));
        })).join();
        ((CompletableFuture)map.floorEntry("bar".substring(0, 1)).thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.higherEntry("foo").thenAccept(result -> {
            Assert.assertEquals((Object)"goodbye", result.getKey());
            Assert.assertArrayEquals((byte[])this.valueThree, (byte[])((byte[])((Versioned)result.getValue()).value()));
        })).join();
        ((CompletableFuture)map.higherEntry("hello").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.lowerEntry("hello").thenAccept(result -> {
            Assert.assertEquals((Object)"goodbye", result.getKey());
            Assert.assertArrayEquals((byte[])this.valueThree, (byte[])((byte[])((Versioned)result.getValue()).value()));
        })).join();
        ((CompletableFuture)map.lowerEntry("bar").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.firstEntry().thenAccept(result -> {
            Assert.assertEquals((Object)"bar", result.getKey());
            Assert.assertArrayEquals((byte[])this.valueOne, (byte[])((byte[])((Versioned)result.getValue()).value()));
        })).join();
        ((CompletableFuture)map.lastEntry().thenAccept(result -> {
            Assert.assertEquals((Object)"hello", result.getKey());
            Assert.assertArrayEquals((byte[])this.valueFour, (byte[])((byte[])((Versioned)result.getValue()).value()));
        })).join();
        map.pollFirstEntry().thenAccept(result -> {
            Assert.assertEquals((Object)"bar", result.getKey());
            Assert.assertArrayEquals((byte[])this.valueOne, (byte[])((byte[])((Versioned)result.getValue()).value()));
        });
        ((CompletableFuture)map.containsKey("bar").thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)3L, (long)result.intValue()))).join();
        map.pollLastEntry().thenAccept(result -> {
            Assert.assertEquals((Object)"hello", result.getKey());
            Assert.assertArrayEquals((byte[])this.valueFour, (byte[])((byte[])((Versioned)result.getValue()).value()));
        });
        ((CompletableFuture)map.containsKey("hello").thenAccept(result -> Assert.assertFalse((boolean)result))).join();
        ((CompletableFuture)map.size().thenAccept(result -> Assert.assertEquals((long)2L, (long)result.intValue()))).join();
        this.allKeys.forEach(key -> {
            Void cfr_ignored_0 = (Void)((CompletableFuture)map.put(key, this.allValues.get(this.allKeys.indexOf(key))).thenAccept(result -> {
                if (key.equals("bar") || key.equals("hello")) {
                    Assert.assertNull((Object)result);
                } else {
                    Assert.assertArrayEquals((byte[])this.allValues.get(this.allKeys.indexOf(key)), (byte[])((byte[])result.value()));
                }
            })).join();
        });
        ((CompletableFuture)map.lowerKey("bar").thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.lowerKey("goodbye").thenAccept(result -> Assert.assertEquals((Object)"foo", (Object)result))).join();
        ((CompletableFuture)map.floorKey("goodbye").thenAccept(result -> Assert.assertEquals((Object)"goodbye", (Object)result))).join();
        ((CompletableFuture)map.floorKey("bar".substring(0, 1)).thenAccept(result -> Assert.assertNull((Object)result))).join();
        ((CompletableFuture)map.ceilingKey("foo").thenAccept(result -> Assert.assertEquals((Object)"foo", (Object)result))).join();
        ((CompletableFuture)map.ceilingKey("helloa").thenAccept(reslt -> Assert.assertNull((Object)reslt))).join();
        ((CompletableFuture)map.higherKey("goodbye").thenAccept(result -> Assert.assertEquals((Object)"hello", (Object)result))).join();
        ((CompletableFuture)map.higherKey("hello").thenAccept(result -> Assert.assertNull((Object)result))).join();
        map.delete().join();
    }

    private AtomixConsistentTreeMap createResource(String mapName) {
        try {
            AtomixConsistentTreeMap map = (AtomixConsistentTreeMap)this.createAtomixClient().getResource(mapName, AtomixConsistentTreeMap.class).join();
            return map;
        }
        catch (Throwable e) {
            throw new RuntimeException(e.toString());
        }
    }

    private boolean byteArrayCollectionIsEqual(Collection<? extends byte[]> o1, Collection<? extends byte[]> o2) {
        if (o1 == null || o2 == null || o1.size() != o2.size()) {
            return false;
        }
        for (byte[] byArray : o1) {
            boolean matched = false;
            for (byte[] byArray2 : o2) {
                if (!Arrays.equals(byArray, byArray2)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    private boolean stringArrayCollectionIsEqual(Collection<? extends String> s1, Collection<? extends String> s2) {
        if (s1 == null || s2 == null || s1.size() != s2.size()) {
            return false;
        }
        for (String string : s1) {
            boolean matched = false;
            for (String string2 : s2) {
                if (!string.equals(string2)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    private class InnerEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public InnerEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V temp = this.value;
            this.value = value;
            return temp;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof InnerEntry)) {
                return false;
            }
            InnerEntry other = (InnerEntry)o;
            boolean keysEqual = false;
            boolean valuesEqual = false;
            if (this.key instanceof byte[]) {
                if (!(other.getKey() instanceof byte[])) return false;
                keysEqual = Arrays.equals((byte[])this.key, (byte[])other.getKey());
            } else {
                keysEqual = this.getKey().equals(other.getKey());
            }
            if (!keysEqual) return false;
            if (!(this.value instanceof byte[])) return this.key.equals(other.getKey());
            if (!(other.getValue() instanceof byte[])) return false;
            return Arrays.equals((byte[])this.value, (byte[])other.getValue());
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    private static class TestMapEventListener
    implements MapEventListener<String, byte[]> {
        private final BlockingQueue<MapEvent<String, byte[]>> queue = new ArrayBlockingQueue<MapEvent<String, byte[]>>(1);

        private TestMapEventListener() {
        }

        public void event(MapEvent<String, byte[]> event) {
            try {
                this.queue.put(event);
            }
            catch (InterruptedException e) {
                Throwables.propagate((Throwable)e);
            }
        }

        public boolean eventReceived() {
            return !this.queue.isEmpty();
        }

        public MapEvent<String, byte[]> event() throws InterruptedException {
            return this.queue.take();
        }
    }
}

