/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.onosproject.store.service.AsyncConsistentMultimap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Versioned;

public class DelegatingAsyncConsistentMultimap<K, V>
implements AsyncConsistentMultimap<K, V> {
    private final AsyncConsistentMultimap<K, V> delegateMap;

    public DelegatingAsyncConsistentMultimap(AsyncConsistentMultimap<K, V> delegateMap) {
        this.delegateMap = (AsyncConsistentMultimap)Preconditions.checkNotNull(delegateMap);
    }

    public String name() {
        return this.delegateMap.name();
    }

    public CompletableFuture<Integer> size() {
        return this.delegateMap.size();
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.delegateMap.isEmpty();
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.delegateMap.containsKey(key);
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return this.delegateMap.containsValue(value);
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        return this.delegateMap.containsEntry(key, value);
    }

    public CompletableFuture<Boolean> put(K key, V value) {
        return this.delegateMap.put(key, value);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.delegateMap.remove(key, value);
    }

    public CompletableFuture<Boolean> removeAll(K key, Collection<? extends V> values) {
        return this.delegateMap.removeAll(key, values);
    }

    public CompletableFuture<Versioned<Collection<? extends V>>> removeAll(K key) {
        return this.delegateMap.removeAll(key);
    }

    public CompletableFuture<Boolean> putAll(K key, Collection<? extends V> values) {
        return this.delegateMap.putAll(key, values);
    }

    public CompletableFuture<Versioned<Collection<? extends V>>> replaceValues(K key, Collection<V> values) {
        return this.delegateMap.replaceValues(key, values);
    }

    public CompletableFuture<Void> clear() {
        return this.delegateMap.clear();
    }

    public CompletableFuture<Versioned<Collection<? extends V>>> get(K key) {
        return this.delegateMap.get(key);
    }

    public CompletableFuture<Set<K>> keySet() {
        return this.delegateMap.keySet();
    }

    public CompletableFuture<Multiset<K>> keys() {
        return this.delegateMap.keys();
    }

    public CompletableFuture<Multiset<V>> values() {
        return this.delegateMap.values();
    }

    public CompletableFuture<Collection<Map.Entry<K, V>>> entries() {
        return this.delegateMap.entries();
    }

    public CompletableFuture<Map<K, Collection<V>>> asMap() {
        return this.delegateMap.asMap();
    }

    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.delegateMap.addStatusChangeListener(listener);
    }

    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.delegateMap.removeStatusChangeListener(listener);
    }

    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return this.delegateMap.statusChangeListeners();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("delegateMap", this.delegateMap).toString();
    }

    public int hashCode() {
        return Objects.hash(this.delegateMap);
    }

    public boolean equals(Object other) {
        if (other instanceof DelegatingAsyncConsistentMultimap) {
            DelegatingAsyncConsistentMultimap that = (DelegatingAsyncConsistentMultimap)other;
            return this.delegateMap.equals(that.delegateMap);
        }
        return false;
    }
}

