/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.MapTransaction;
import org.onosproject.store.service.Versioned;

public class TranscodingAsyncConsistentMap<K1, V1, K2, V2>
implements AsyncConsistentMap<K1, V1> {
    private final AsyncConsistentMap<K2, V2> backingMap;
    private final Function<K1, K2> keyEncoder;
    private final Function<K2, K1> keyDecoder;
    private final Function<V2, V1> valueDecoder;
    private final Function<V1, V2> valueEncoder;
    private final Function<Versioned<V2>, Versioned<V1>> versionedValueTransform;
    private final Map<MapEventListener<K1, V1>, InternalBackingMapEventListener> listeners = Maps.newIdentityHashMap();

    public TranscodingAsyncConsistentMap(AsyncConsistentMap<K2, V2> backingMap, Function<K1, K2> keyEncoder, Function<K2, K1> keyDecoder, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        this.backingMap = backingMap;
        this.keyEncoder = k -> k == null ? null : keyEncoder.apply(k);
        this.keyDecoder = k -> k == null ? null : keyDecoder.apply(k);
        this.valueEncoder = v -> v == null ? null : valueEncoder.apply(v);
        this.valueDecoder = v -> v == null ? null : valueDecoder.apply(v);
        this.versionedValueTransform = v -> v == null ? null : v.map(valueDecoder);
    }

    public String name() {
        return this.backingMap.name();
    }

    public CompletableFuture<Integer> size() {
        return this.backingMap.size();
    }

    public CompletableFuture<Boolean> containsKey(K1 key) {
        try {
            return this.backingMap.containsKey(this.keyEncoder.apply(key));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> containsValue(V1 value) {
        try {
            return this.backingMap.containsValue(this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Versioned<V1>> get(K1 key) {
        try {
            return this.backingMap.get(this.keyEncoder.apply(key)).thenApply(this.versionedValueTransform);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Versioned<V1>> computeIf(K1 key, Predicate<? super V1> condition, BiFunction<? super K1, ? super V1, ? extends V1> remappingFunction) {
        try {
            return this.backingMap.computeIf(this.keyEncoder.apply(key), v -> condition.test((V1)this.valueDecoder.apply(v)), (k, v) -> this.valueEncoder.apply(remappingFunction.apply((K1)this.keyDecoder.apply(k), (V1)this.valueDecoder.apply(v)))).thenApply(this.versionedValueTransform);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Versioned<V1>> put(K1 key, V1 value) {
        try {
            return this.backingMap.put(this.keyEncoder.apply(key), this.valueEncoder.apply(value)).thenApply(this.versionedValueTransform);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Versioned<V1>> putAndGet(K1 key, V1 value) {
        try {
            return this.backingMap.putAndGet(this.keyEncoder.apply(key), this.valueEncoder.apply(value)).thenApply(this.versionedValueTransform);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Versioned<V1>> remove(K1 key) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key)).thenApply(this.versionedValueTransform);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Void> clear() {
        return this.backingMap.clear();
    }

    public CompletableFuture<Set<K1>> keySet() {
        return this.backingMap.keySet().thenApply(s -> s.stream().map(this.keyDecoder).collect(Collectors.toSet()));
    }

    public CompletableFuture<Collection<Versioned<V1>>> values() {
        return this.backingMap.values().thenApply(c -> c.stream().map(this.versionedValueTransform).collect(Collectors.toList()));
    }

    public CompletableFuture<Set<Map.Entry<K1, Versioned<V1>>>> entrySet() {
        return this.backingMap.entrySet().thenApply(s -> s.stream().map(e -> Maps.immutableEntry(this.keyDecoder.apply(e.getKey()), this.versionedValueTransform.apply((Versioned<V2>)e.getValue()))).collect(Collectors.toSet()));
    }

    public CompletableFuture<Versioned<V1>> putIfAbsent(K1 key, V1 value) {
        try {
            return this.backingMap.putIfAbsent(this.keyEncoder.apply(key), this.valueEncoder.apply(value)).thenApply(this.versionedValueTransform);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> remove(K1 key, V1 value) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key), this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> remove(K1 key, long version) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key), version);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Versioned<V1>> replace(K1 key, V1 value) {
        try {
            return this.backingMap.replace(this.keyEncoder.apply(key), this.valueEncoder.apply(value)).thenApply(this.versionedValueTransform);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> replace(K1 key, V1 oldValue, V1 newValue) {
        try {
            return this.backingMap.replace(this.keyEncoder.apply(key), this.valueEncoder.apply(oldValue), this.valueEncoder.apply(newValue));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> replace(K1 key, long oldVersion, V1 newValue) {
        try {
            return this.backingMap.replace(this.keyEncoder.apply(key), oldVersion, this.valueEncoder.apply(newValue));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> addListener(MapEventListener<K1, V1> listener, Executor executor) {
        Map<MapEventListener<K1, V1>, InternalBackingMapEventListener> map = this.listeners;
        synchronized (map) {
            InternalBackingMapEventListener backingMapListener = this.listeners.computeIfAbsent(listener, k -> new InternalBackingMapEventListener(listener));
            return this.backingMap.addListener((MapEventListener)backingMapListener, executor);
        }
    }

    public CompletableFuture<Void> removeListener(MapEventListener<K1, V1> listener) {
        InternalBackingMapEventListener backingMapListener = this.listeners.remove(listener);
        if (backingMapListener != null) {
            return this.backingMap.removeListener((MapEventListener)backingMapListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Boolean> prepare(MapTransaction<K1, V1> transaction) {
        try {
            return this.backingMap.prepare(transaction.map(this.keyEncoder, this.valueEncoder));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return this.backingMap.commit(transactionId);
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return this.backingMap.rollback(transactionId);
    }

    public CompletableFuture<Boolean> prepareAndCommit(MapTransaction<K1, V1> transaction) {
        try {
            return this.backingMap.prepareAndCommit(transaction.map(this.keyEncoder, this.valueEncoder));
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.backingMap.addStatusChangeListener(listener);
    }

    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.backingMap.removeStatusChangeListener(listener);
    }

    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return this.backingMap.statusChangeListeners();
    }

    private class InternalBackingMapEventListener
    implements MapEventListener<K2, V2> {
        private final MapEventListener<K1, V1> listener;

        InternalBackingMapEventListener(MapEventListener<K1, V1> listener) {
            this.listener = listener;
        }

        public void event(MapEvent<K2, V2> event) {
            this.listener.event(new MapEvent(event.name(), TranscodingAsyncConsistentMap.this.keyDecoder.apply(event.key()), event.newValue() != null ? event.newValue().map(TranscodingAsyncConsistentMap.this.valueDecoder) : null, event.oldValue() != null ? event.oldValue().map(TranscodingAsyncConsistentMap.this.valueDecoder) : null));
        }
    }
}

