/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ResourceTypeInfo;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.onlab.util.Match;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMapCommands;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMapFactory;
import org.onosproject.store.primitives.resources.impl.MapEntryUpdateResult;
import org.onosproject.store.primitives.resources.impl.PrepareResult;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.MapTransaction;
import org.onosproject.store.service.Versioned;

@ResourceTypeInfo(id=-151, factory=AtomixConsistentMapFactory.class)
public class AtomixConsistentMap
extends AbstractResource<AtomixConsistentMap>
implements AsyncConsistentMap<String, byte[]> {
    private final Set<Consumer<DistributedPrimitive.Status>> statusChangeListeners = Sets.newCopyOnWriteArraySet();
    private final Map<MapEventListener<String, byte[]>, Executor> mapEventListeners = new ConcurrentHashMap<MapEventListener<String, byte[]>, Executor>();
    public static final String CHANGE_SUBJECT = "changeEvents";

    public AtomixConsistentMap(CopycatClient client, Properties properties) {
        super(client, properties);
    }

    public String name() {
        return null;
    }

    public CompletableFuture<AtomixConsistentMap> open() {
        return super.open().thenApply(result -> {
            this.client.onStateChange(state -> {
                if (state == CopycatClient.State.CONNECTED && this.isListening()) {
                    this.client.submit((Command)new AtomixConsistentMapCommands.Listen());
                }
            });
            this.client.onEvent(CHANGE_SUBJECT, this::handleEvent);
            return result;
        });
    }

    private void handleEvent(List<MapEvent<String, byte[]>> events) {
        events.forEach(event -> this.mapEventListeners.forEach((listener, executor) -> executor.execute(() -> listener.event(event))));
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.client.submit((Query)new AtomixConsistentMapCommands.IsEmpty());
    }

    public CompletableFuture<Integer> size() {
        return this.client.submit((Query)new AtomixConsistentMapCommands.Size());
    }

    public CompletableFuture<Boolean> containsKey(String key) {
        return this.client.submit((Query)new AtomixConsistentMapCommands.ContainsKey(key));
    }

    public CompletableFuture<Boolean> containsValue(byte[] value) {
        return this.client.submit((Query)new AtomixConsistentMapCommands.ContainsValue(value));
    }

    public CompletableFuture<Versioned<byte[]>> get(String key) {
        return this.client.submit((Query)new AtomixConsistentMapCommands.Get(key));
    }

    public CompletableFuture<Set<String>> keySet() {
        return this.client.submit((Query)new AtomixConsistentMapCommands.KeySet());
    }

    public CompletableFuture<Collection<Versioned<byte[]>>> values() {
        return this.client.submit((Query)new AtomixConsistentMapCommands.Values());
    }

    public CompletableFuture<Set<Map.Entry<String, Versioned<byte[]>>>> entrySet() {
        return this.client.submit((Query)new AtomixConsistentMapCommands.EntrySet());
    }

    public CompletableFuture<Versioned<byte[]>> put(String key, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentMapCommands.UpdateAndGet(key, value, (Match<byte[]>)Match.ANY, (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.oldValue());
    }

    public CompletableFuture<Versioned<byte[]>> putAndGet(String key, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentMapCommands.UpdateAndGet(key, value, (Match<byte[]>)Match.ANY, (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.newValue());
    }

    public CompletableFuture<Versioned<byte[]>> putIfAbsent(String key, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentMapCommands.UpdateAndGet(key, value, (Match<byte[]>)Match.NULL, (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.oldValue());
    }

    public CompletableFuture<Versioned<byte[]>> remove(String key) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentMapCommands.UpdateAndGet(key, null, (Match<byte[]>)Match.ANY, (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.oldValue());
    }

    public CompletableFuture<Boolean> remove(String key, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentMapCommands.UpdateAndGet(key, null, (Match<byte[]>)Match.ifValue((Object)value), (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.updated());
    }

    public CompletableFuture<Boolean> remove(String key, long version) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentMapCommands.UpdateAndGet(key, null, (Match<byte[]>)Match.ANY, (Match<Long>)Match.ifValue((Object)version))).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.updated());
    }

    public CompletableFuture<Versioned<byte[]>> replace(String key, byte[] value) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentMapCommands.UpdateAndGet(key, value, (Match<byte[]>)Match.NOT_NULL, (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.oldValue());
    }

    public CompletableFuture<Boolean> replace(String key, byte[] oldValue, byte[] newValue) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentMapCommands.UpdateAndGet(key, newValue, (Match<byte[]>)Match.ifValue((Object)oldValue), (Match<Long>)Match.ANY)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.updated());
    }

    public CompletableFuture<Boolean> replace(String key, long oldVersion, byte[] newValue) {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentMapCommands.UpdateAndGet(key, newValue, (Match<byte[]>)Match.ANY, (Match<Long>)Match.ifValue((Object)oldVersion))).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenApply(v -> v.updated());
    }

    public CompletableFuture<Void> clear() {
        return ((CompletableFuture)this.client.submit((Command)new AtomixConsistentMapCommands.Clear()).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult.Status)((Object)r)))).thenApply(v -> null);
    }

    public CompletableFuture<Versioned<byte[]>> computeIf(String key, Predicate<? super byte[]> condition, BiFunction<? super String, ? super byte[], ? extends byte[]> remappingFunction) {
        return this.get(key).thenCompose(r1 -> {
            byte[] existingValue;
            byte[] byArray = existingValue = r1 == null ? null : (byte[])r1.value();
            if (!condition.test(existingValue)) {
                return CompletableFuture.completedFuture(r1);
            }
            AtomicReference computedValue = new AtomicReference();
            try {
                computedValue.set(remappingFunction.apply(key, existingValue));
            }
            catch (Exception e2) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e2);
                return future;
            }
            if (computedValue.get() == null && r1 == null) {
                return CompletableFuture.completedFuture(null);
            }
            Match valueMatch = r1 == null ? Match.NULL : Match.ANY;
            Match versionMatch = r1 == null ? Match.ANY : Match.ifValue((Object)r1.version());
            return ((CompletableFuture)((CompletableFuture)this.client.submit((Command)new AtomixConsistentMapCommands.UpdateAndGet(key, (byte[])computedValue.get(), (Match<byte[]>)valueMatch, (Match<Long>)versionMatch)).whenComplete((r, e) -> this.throwIfLocked(r.status()))).thenCompose(r -> {
                if (r.status() == MapEntryUpdateResult.Status.PRECONDITION_FAILED || r.status() == MapEntryUpdateResult.Status.WRITE_LOCK) {
                    return Tools.exceptionalFuture((Throwable)new ConsistentMapException.ConcurrentModification());
                }
                return CompletableFuture.completedFuture(r);
            })).thenApply(v -> v.newValue());
        });
    }

    public synchronized CompletableFuture<Void> addListener(MapEventListener<String, byte[]> listener, Executor executor) {
        if (this.mapEventListeners.isEmpty()) {
            return this.client.submit((Command)new AtomixConsistentMapCommands.Listen()).thenRun(() -> this.mapEventListeners.put(listener, executor));
        }
        this.mapEventListeners.put(listener, executor);
        return CompletableFuture.completedFuture(null);
    }

    public synchronized CompletableFuture<Void> removeListener(MapEventListener<String, byte[]> listener) {
        if (this.mapEventListeners.remove(listener) != null && this.mapEventListeners.isEmpty()) {
            return this.client.submit((Command)new AtomixConsistentMapCommands.Unlisten()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void throwIfLocked(MapEntryUpdateResult.Status status) {
        if (status == MapEntryUpdateResult.Status.WRITE_LOCK) {
            throw new ConcurrentModificationException("Cannot update map: Another transaction in progress");
        }
    }

    public CompletableFuture<Boolean> prepare(MapTransaction<String, byte[]> transaction) {
        return this.client.submit((Command)new AtomixConsistentMapCommands.TransactionPrepare(transaction)).thenApply(v -> v == PrepareResult.OK);
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return this.client.submit((Command)new AtomixConsistentMapCommands.TransactionCommit(transactionId)).thenApply(v -> null);
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return this.client.submit((Command)new AtomixConsistentMapCommands.TransactionRollback(transactionId)).thenApply(v -> null);
    }

    public CompletableFuture<Boolean> prepareAndCommit(MapTransaction<String, byte[]> transaction) {
        return this.client.submit((Command)new AtomixConsistentMapCommands.TransactionPrepareAndCommit(transaction)).thenApply(v -> v == PrepareResult.OK);
    }

    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.statusChangeListeners.add(listener);
    }

    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.statusChangeListeners.remove(listener);
    }

    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return ImmutableSet.copyOf(this.statusChangeListeners);
    }

    private boolean isListening() {
        return !this.mapEventListeners.isEmpty();
    }
}

