/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.copycat.session.Session;
import io.atomix.resource.ResourceStateMachine;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.onlab.util.Match;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentTreeMapCommands;
import org.onosproject.store.primitives.resources.impl.MapEntryUpdateResult;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.Versioned;

public class AtomixConsistentTreeMapState
extends ResourceStateMachine
implements SessionListener,
Snapshottable {
    private final Map<Long, Commit<? extends AtomixConsistentTreeMapCommands.Listen>> listeners = Maps.newHashMap();
    private TreeMap<String, TreeMapEntryValue> tree = Maps.newTreeMap();
    private final Set<String> preparedKeys = Sets.newHashSet();
    private AtomicLong versionCounter = new AtomicLong(0L);
    private Function<Commit<AtomixConsistentTreeMapCommands.SubMap>, NavigableMap<String, TreeMapEntryValue>> subMapFunction = this::subMap;
    private Function<Commit<AtomixConsistentTreeMapCommands.FirstKey>, String> firstKeyFunction = this::firstKey;
    private Function<Commit<AtomixConsistentTreeMapCommands.LastKey>, String> lastKeyFunction = this::lastKey;
    private Function<Commit<AtomixConsistentTreeMapCommands.HigherEntry>, Map.Entry<String, Versioned<byte[]>>> higherEntryFunction = this::higherEntry;
    private Function<Commit<AtomixConsistentTreeMapCommands.FirstEntry>, Map.Entry<String, Versioned<byte[]>>> firstEntryFunction = this::firstEntry;
    private Function<Commit<AtomixConsistentTreeMapCommands.LastEntry>, Map.Entry<String, Versioned<byte[]>>> lastEntryFunction = this::lastEntry;
    private Function<Commit<AtomixConsistentTreeMapCommands.PollFirstEntry>, Map.Entry<String, Versioned<byte[]>>> pollFirstEntryFunction = this::pollFirstEntry;
    private Function<Commit<AtomixConsistentTreeMapCommands.PollLastEntry>, Map.Entry<String, Versioned<byte[]>>> pollLastEntryFunction = this::pollLastEntry;
    private Function<Commit<AtomixConsistentTreeMapCommands.LowerEntry>, Map.Entry<String, Versioned<byte[]>>> lowerEntryFunction = this::lowerEntry;
    private Function<Commit<AtomixConsistentTreeMapCommands.LowerKey>, String> lowerKeyFunction = this::lowerKey;
    private Function<Commit<AtomixConsistentTreeMapCommands.FloorEntry>, Map.Entry<String, Versioned<byte[]>>> floorEntryFunction = this::floorEntry;
    private Function<Commit<AtomixConsistentTreeMapCommands.CeilingEntry>, Map.Entry<String, Versioned<byte[]>>> ceilingEntryFunction = this::ceilingEntry;
    private Function<Commit<AtomixConsistentTreeMapCommands.FloorKey>, String> floorKeyFunction = this::floorKey;
    private Function<Commit<AtomixConsistentTreeMapCommands.CeilingKey>, String> ceilingKeyFunction = this::ceilingKey;
    private Function<Commit<AtomixConsistentTreeMapCommands.HigherKey>, String> higherKeyFunction = this::higherKey;

    public AtomixConsistentTreeMapState(Properties properties) {
        super(properties);
    }

    public void snapshot(SnapshotWriter writer) {
        writer.writeLong(this.versionCounter.get());
    }

    public void install(SnapshotReader reader) {
        this.versionCounter = new AtomicLong(reader.readLong());
    }

    public void configure(StateMachineExecutor executor) {
        executor.register(AtomixConsistentTreeMapCommands.Listen.class, this::listen);
        executor.register(AtomixConsistentTreeMapCommands.Unlisten.class, this::unlisten);
        executor.register(AtomixConsistentTreeMapCommands.ContainsKey.class, this::containsKey);
        executor.register(AtomixConsistentTreeMapCommands.ContainsValue.class, this::containsValue);
        executor.register(AtomixConsistentTreeMapCommands.EntrySet.class, this::entrySet);
        executor.register(AtomixConsistentTreeMapCommands.Get.class, this::get);
        executor.register(AtomixConsistentTreeMapCommands.IsEmpty.class, this::isEmpty);
        executor.register(AtomixConsistentTreeMapCommands.KeySet.class, this::keySet);
        executor.register(AtomixConsistentTreeMapCommands.Size.class, this::size);
        executor.register(AtomixConsistentTreeMapCommands.Values.class, this::values);
        executor.register(AtomixConsistentTreeMapCommands.SubMap.class, this.subMapFunction);
        executor.register(AtomixConsistentTreeMapCommands.FirstKey.class, this.firstKeyFunction);
        executor.register(AtomixConsistentTreeMapCommands.LastKey.class, this.lastKeyFunction);
        executor.register(AtomixConsistentTreeMapCommands.FirstEntry.class, this.firstEntryFunction);
        executor.register(AtomixConsistentTreeMapCommands.LastEntry.class, this.lastEntryFunction);
        executor.register(AtomixConsistentTreeMapCommands.PollFirstEntry.class, this.pollFirstEntryFunction);
        executor.register(AtomixConsistentTreeMapCommands.PollLastEntry.class, this.pollLastEntryFunction);
        executor.register(AtomixConsistentTreeMapCommands.LowerEntry.class, this.lowerEntryFunction);
        executor.register(AtomixConsistentTreeMapCommands.LowerKey.class, this.lowerKeyFunction);
        executor.register(AtomixConsistentTreeMapCommands.FloorEntry.class, this.floorEntryFunction);
        executor.register(AtomixConsistentTreeMapCommands.FloorKey.class, this.floorKeyFunction);
        executor.register(AtomixConsistentTreeMapCommands.CeilingEntry.class, this.ceilingEntryFunction);
        executor.register(AtomixConsistentTreeMapCommands.CeilingKey.class, this.ceilingKeyFunction);
        executor.register(AtomixConsistentTreeMapCommands.HigherEntry.class, this.higherEntryFunction);
        executor.register(AtomixConsistentTreeMapCommands.HigherKey.class, this.higherKeyFunction);
        executor.register(AtomixConsistentTreeMapCommands.UpdateAndGet.class, this::updateAndGet);
        executor.register(AtomixConsistentTreeMapCommands.Clear.class, this::clear);
    }

    public void delete() {
        this.listeners.values().forEach(Commit::close);
        this.listeners.clear();
        this.tree.values().forEach(TreeMapEntryValue::discard);
        this.tree.clear();
    }

    protected boolean containsKey(Commit<? extends AtomixConsistentTreeMapCommands.ContainsKey> commit) {
        try {
            boolean bl = this.toVersioned(this.tree.get(((AtomixConsistentTreeMapCommands.ContainsKey)commit.operation()).key())) != null;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsValue(Commit<? extends AtomixConsistentTreeMapCommands.ContainsValue> commit) {
        try {
            Match valueMatch = Match.ifValue((Object)((AtomixConsistentTreeMapCommands.ContainsValue)commit.operation()).value());
            boolean bl = this.tree.values().stream().anyMatch(value -> valueMatch.matches((Object)value.value()));
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected Versioned<byte[]> get(Commit<? extends AtomixConsistentTreeMapCommands.Get> commit) {
        try {
            Versioned<byte[]> versioned = this.toVersioned(this.tree.get(((AtomixConsistentTreeMapCommands.Get)commit.operation()).key()));
            return versioned;
        }
        finally {
            commit.close();
        }
    }

    protected int size(Commit<? extends AtomixConsistentTreeMapCommands.Size> commit) {
        try {
            int n = this.tree.size();
            return n;
        }
        finally {
            commit.close();
        }
    }

    protected boolean isEmpty(Commit<? extends AtomixConsistentTreeMapCommands.IsEmpty> commit) {
        try {
            boolean bl = this.tree.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected Set<String> keySet(Commit<? extends AtomixConsistentTreeMapCommands.KeySet> commit) {
        try {
            Set<String> set = this.tree.keySet().stream().collect(Collectors.toSet());
            return set;
        }
        finally {
            commit.close();
        }
    }

    protected Collection<Versioned<byte[]>> values(Commit<? extends AtomixConsistentTreeMapCommands.Values> commit) {
        try {
            Collection collection = this.tree.values().stream().map(this::toVersioned).collect(Collectors.toList());
            return collection;
        }
        finally {
            commit.close();
        }
    }

    protected Set<Map.Entry<String, Versioned<byte[]>>> entrySet(Commit<? extends AtomixConsistentTreeMapCommands.EntrySet> commit) {
        try {
            Set<Map.Entry<String, Versioned<byte[]>>> set = this.tree.entrySet().stream().map(e -> Maps.immutableEntry(e.getKey(), this.toVersioned((TreeMapEntryValue)e.getValue()))).collect(Collectors.toSet());
            return set;
        }
        finally {
            commit.close();
        }
    }

    protected MapEntryUpdateResult<String, byte[]> updateAndGet(Commit<? extends AtomixConsistentTreeMapCommands.UpdateAndGet> commit) {
        MapEvent.Type updateType;
        Versioned newTreeValue;
        MapEntryUpdateResult.Status updateStatus = this.validate((AtomixConsistentTreeMapCommands.UpdateAndGet)commit.operation());
        String key = ((AtomixConsistentTreeMapCommands.UpdateAndGet)commit.operation()).key();
        TreeMapEntryValue oldCommitValue = this.tree.get(((AtomixConsistentTreeMapCommands.UpdateAndGet)commit.operation()).key());
        Versioned<byte[]> oldTreeValue = this.toVersioned(oldCommitValue);
        if (updateStatus != MapEntryUpdateResult.Status.OK) {
            commit.close();
            return new MapEntryUpdateResult<String, byte[]>(updateStatus, "", key, oldTreeValue, oldTreeValue);
        }
        byte[] newValue = ((AtomixConsistentTreeMapCommands.UpdateAndGet)commit.operation()).value();
        long newVersion = this.versionCounter.incrementAndGet();
        Versioned versioned = newTreeValue = newValue == null ? null : new Versioned((Object)newValue, newVersion);
        MapEvent.Type type = newValue == null ? MapEvent.Type.REMOVE : (updateType = oldCommitValue == null ? MapEvent.Type.INSERT : MapEvent.Type.UPDATE);
        if (updateType == MapEvent.Type.REMOVE || updateType == MapEvent.Type.UPDATE) {
            this.tree.remove(key);
            oldCommitValue.discard();
        }
        if (updateType == MapEvent.Type.INSERT || updateType == MapEvent.Type.UPDATE) {
            this.tree.put(key, new NonTransactionalCommit(newVersion, commit));
        } else {
            commit.close();
        }
        this.publish(Lists.newArrayList((Object[])new MapEvent[]{new MapEvent("", (Object)key, newTreeValue, oldTreeValue)}));
        return new MapEntryUpdateResult<String, byte[]>(updateStatus, "", key, oldTreeValue, newTreeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapEntryUpdateResult.Status clear(Commit<? extends AtomixConsistentTreeMapCommands.Clear> commit) {
        try {
            Iterator<Map.Entry<String, TreeMapEntryValue>> iterator = this.tree.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, TreeMapEntryValue> entry = iterator.next();
                String key = entry.getKey();
                TreeMapEntryValue value = entry.getValue();
                Versioned removedValue = new Versioned((Object)value.value(), value.version());
                this.publish(Lists.newArrayList((Object[])new MapEvent[]{new MapEvent("", (Object)key, null, removedValue)}));
                value.discard();
                iterator.remove();
            }
            MapEntryUpdateResult.Status status = MapEntryUpdateResult.Status.OK;
            return status;
        }
        finally {
            commit.close();
        }
    }

    protected void listen(Commit<? extends AtomixConsistentTreeMapCommands.Listen> commit) {
        Long sessionId = commit.session().id();
        this.listeners.put(sessionId, commit);
        commit.session().onStateChange(state -> {
            Commit<? extends AtomixConsistentTreeMapCommands.Listen> listener;
            if ((state == Session.State.CLOSED || state == Session.State.EXPIRED) && (listener = this.listeners.remove(sessionId)) != null) {
                listener.close();
            }
        });
    }

    protected void unlisten(Commit<? extends AtomixConsistentTreeMapCommands.Unlisten> commit) {
        try {
            Commit<? extends AtomixConsistentTreeMapCommands.Listen> listener = this.listeners.remove(commit.session());
            if (listener != null) {
                listener.close();
            }
        }
        finally {
            commit.close();
        }
    }

    private MapEntryUpdateResult.Status validate(AtomixConsistentTreeMapCommands.UpdateAndGet update) {
        TreeMapEntryValue existingValue = this.tree.get(update.key());
        if (existingValue == null && update.value() == null) {
            return MapEntryUpdateResult.Status.NOOP;
        }
        if (this.preparedKeys.contains(update.key())) {
            return MapEntryUpdateResult.Status.WRITE_LOCK;
        }
        byte[] existingRawValue = existingValue == null ? null : existingValue.value();
        Long existingVersion = existingValue == null ? null : Long.valueOf(existingValue.version());
        return update.valueMatch().matches((Object)existingRawValue) && update.versionMatch().matches((Object)existingVersion) ? MapEntryUpdateResult.Status.OK : MapEntryUpdateResult.Status.PRECONDITION_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NavigableMap<String, TreeMapEntryValue> subMap(Commit<? extends AtomixConsistentTreeMapCommands.SubMap> commit) {
        try {
            AtomixConsistentTreeMapCommands.SubMap subMap = (AtomixConsistentTreeMapCommands.SubMap)commit.operation();
            NavigableMap<String, TreeMapEntryValue> navigableMap = this.tree.subMap((String)subMap.fromKey(), subMap.isInclusiveFrom(), (String)subMap.toKey(), subMap.isInclusiveTo());
            return navigableMap;
        }
        finally {
            commit.close();
        }
    }

    protected String firstKey(Commit<? extends AtomixConsistentTreeMapCommands.FirstKey> commit) {
        try {
            if (this.tree.isEmpty()) {
                String string = null;
                return string;
            }
            String string = this.tree.firstKey();
            return string;
        }
        finally {
            commit.close();
        }
    }

    protected String lastKey(Commit<? extends AtomixConsistentTreeMapCommands.LastKey> commit) {
        try {
            String string = this.tree.isEmpty() ? null : this.tree.lastKey();
            return string;
        }
        finally {
            commit.close();
        }
    }

    protected Map.Entry<String, Versioned<byte[]>> higherEntry(Commit<? extends AtomixConsistentTreeMapCommands.HigherEntry> commit) {
        try {
            if (this.tree.isEmpty()) {
                Map.Entry<String, Versioned<byte[]>> entry = null;
                return entry;
            }
            Map.Entry<String, Versioned<byte[]>> entry = this.toVersionedEntry(this.tree.higherEntry(((AtomixConsistentTreeMapCommands.HigherEntry)commit.operation()).key()));
            return entry;
        }
        finally {
            commit.close();
        }
    }

    protected Map.Entry<String, Versioned<byte[]>> firstEntry(Commit<? extends AtomixConsistentTreeMapCommands.FirstEntry> commit) {
        try {
            if (this.tree.isEmpty()) {
                Map.Entry<String, Versioned<byte[]>> entry = null;
                return entry;
            }
            Map.Entry<String, Versioned<byte[]>> entry = this.toVersionedEntry(this.tree.firstEntry());
            return entry;
        }
        finally {
            commit.close();
        }
    }

    protected Map.Entry<String, Versioned<byte[]>> lastEntry(Commit<? extends AtomixConsistentTreeMapCommands.LastEntry> commit) {
        try {
            if (this.tree.isEmpty()) {
                Map.Entry<String, Versioned<byte[]>> entry = null;
                return entry;
            }
            Map.Entry<String, Versioned<byte[]>> entry = this.toVersionedEntry(this.tree.lastEntry());
            return entry;
        }
        finally {
            commit.close();
        }
    }

    protected Map.Entry<String, Versioned<byte[]>> pollFirstEntry(Commit<? extends AtomixConsistentTreeMapCommands.PollFirstEntry> commit) {
        try {
            Map.Entry<String, Versioned<byte[]>> entry = this.toVersionedEntry(this.tree.pollFirstEntry());
            return entry;
        }
        finally {
            commit.close();
        }
    }

    protected Map.Entry<String, Versioned<byte[]>> pollLastEntry(Commit<? extends AtomixConsistentTreeMapCommands.PollLastEntry> commit) {
        try {
            Map.Entry<String, Versioned<byte[]>> entry = this.toVersionedEntry(this.tree.pollLastEntry());
            return entry;
        }
        finally {
            commit.close();
        }
    }

    protected Map.Entry<String, Versioned<byte[]>> lowerEntry(Commit<? extends AtomixConsistentTreeMapCommands.LowerEntry> commit) {
        try {
            Map.Entry<String, Versioned<byte[]>> entry = this.toVersionedEntry(this.tree.lowerEntry(((AtomixConsistentTreeMapCommands.LowerEntry)commit.operation()).key()));
            return entry;
        }
        finally {
            commit.close();
        }
    }

    protected String lowerKey(Commit<? extends AtomixConsistentTreeMapCommands.LowerKey> commit) {
        try {
            String string = this.tree.lowerKey(((AtomixConsistentTreeMapCommands.LowerKey)commit.operation()).key());
            return string;
        }
        finally {
            commit.close();
        }
    }

    protected Map.Entry<String, Versioned<byte[]>> floorEntry(Commit<? extends AtomixConsistentTreeMapCommands.FloorEntry> commit) {
        try {
            Map.Entry<String, Versioned<byte[]>> entry = this.toVersionedEntry(this.tree.floorEntry(((AtomixConsistentTreeMapCommands.FloorEntry)commit.operation()).key()));
            return entry;
        }
        finally {
            commit.close();
        }
    }

    protected String floorKey(Commit<? extends AtomixConsistentTreeMapCommands.FloorKey> commit) {
        try {
            String string = this.tree.floorKey(((AtomixConsistentTreeMapCommands.FloorKey)commit.operation()).key());
            return string;
        }
        finally {
            commit.close();
        }
    }

    protected Map.Entry<String, Versioned<byte[]>> ceilingEntry(Commit<AtomixConsistentTreeMapCommands.CeilingEntry> commit) {
        try {
            Map.Entry<String, Versioned<byte[]>> entry = this.toVersionedEntry(this.tree.ceilingEntry(((AtomixConsistentTreeMapCommands.CeilingEntry)commit.operation()).key()));
            return entry;
        }
        finally {
            commit.close();
        }
    }

    protected String ceilingKey(Commit<AtomixConsistentTreeMapCommands.CeilingKey> commit) {
        try {
            String string = this.tree.ceilingKey(((AtomixConsistentTreeMapCommands.CeilingKey)commit.operation()).key());
            return string;
        }
        finally {
            commit.close();
        }
    }

    protected String higherKey(Commit<AtomixConsistentTreeMapCommands.HigherKey> commit) {
        try {
            String string = this.tree.higherKey(((AtomixConsistentTreeMapCommands.HigherKey)commit.operation()).key());
            return string;
        }
        finally {
            commit.close();
        }
    }

    private Versioned<byte[]> toVersioned(TreeMapEntryValue value) {
        return value == null ? null : new Versioned((Object)value.value(), value.version());
    }

    private Map.Entry<String, Versioned<byte[]>> toVersionedEntry(Map.Entry<String, TreeMapEntryValue> entry) {
        return entry == null ? null : new AbstractMap.SimpleImmutableEntry<String, Versioned<byte[]>>(entry.getKey(), this.toVersioned(entry.getValue()));
    }

    private void publish(List<MapEvent<String, byte[]>> events) {
        this.listeners.values().forEach(commit -> commit.session().publish("changeEvents", (Object)events));
    }

    public void register(ServerSession session) {
    }

    public void unregister(ServerSession session) {
        this.closeListener(session.id());
    }

    public void expire(ServerSession session) {
        this.closeListener(session.id());
    }

    public void close(ServerSession session) {
        this.closeListener(session.id());
    }

    private void closeListener(Long sessionId) {
        Commit<? extends AtomixConsistentTreeMapCommands.Listen> commit = this.listeners.remove(sessionId);
        if (commit != null) {
            commit.close();
        }
    }

    private class NonTransactionalCommit
    implements TreeMapEntryValue {
        private final long version;
        private final Commit<? extends AtomixConsistentTreeMapCommands.UpdateAndGet> commit;

        public NonTransactionalCommit(long version, Commit<? extends AtomixConsistentTreeMapCommands.UpdateAndGet> commit) {
            this.version = version;
            this.commit = commit;
        }

        @Override
        public byte[] value() {
            return ((AtomixConsistentTreeMapCommands.UpdateAndGet)this.commit.operation()).value();
        }

        @Override
        public long version() {
            return this.version;
        }

        @Override
        public void discard() {
            this.commit.close();
        }
    }

    private static interface TreeMapEntryValue {
        public byte[] value();

        public long version();

        public void discard();
    }
}

