/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AtomicValueEventListener;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Topic;

public class DefaultDistributedTopic<T>
implements Topic<T> {
    private final AsyncAtomicValue<T> atomicValue;
    private final Map<Consumer<T>, AtomicValueEventListener<T>> callbacks = Maps.newIdentityHashMap();

    DefaultDistributedTopic(AsyncAtomicValue<T> atomicValue) {
        this.atomicValue = atomicValue;
    }

    public String name() {
        return this.atomicValue.name();
    }

    public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.TOPIC;
    }

    public CompletableFuture<Void> destroy() {
        return this.atomicValue.destroy();
    }

    public CompletableFuture<Void> publish(T message) {
        return this.atomicValue.set(message);
    }

    public CompletableFuture<Void> subscribe(Consumer<T> callback, Executor executor) {
        AtomicValueEventListener valueListener = event -> executor.execute(() -> callback.accept(event.newValue()));
        if (this.callbacks.putIfAbsent(callback, valueListener) == null) {
            return this.atomicValue.addListener(valueListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> unsubscribe(Consumer<T> callback) {
        AtomicValueEventListener<T> valueListener = this.callbacks.remove(callback);
        if (valueListener != null) {
            return this.atomicValue.removeListener(valueListener);
        }
        return CompletableFuture.completedFuture(null);
    }
}

