/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.DistributedPrimitive;

public class ExecutingAsyncAtomicCounter
extends ExecutingDistributedPrimitive
implements AsyncAtomicCounter {
    private final AsyncAtomicCounter delegateCounter;
    private final Executor executor;

    public ExecutingAsyncAtomicCounter(AsyncAtomicCounter delegateCounter, Executor executor) {
        super((DistributedPrimitive)delegateCounter, executor);
        this.delegateCounter = delegateCounter;
        this.executor = executor;
    }

    public CompletableFuture<Long> incrementAndGet() {
        return Tools.asyncFuture((CompletableFuture)this.delegateCounter.incrementAndGet(), (Executor)this.executor);
    }

    public CompletableFuture<Long> getAndIncrement() {
        return Tools.asyncFuture((CompletableFuture)this.delegateCounter.getAndIncrement(), (Executor)this.executor);
    }

    public CompletableFuture<Long> getAndAdd(long delta) {
        return Tools.asyncFuture((CompletableFuture)this.delegateCounter.getAndAdd(delta), (Executor)this.executor);
    }

    public CompletableFuture<Long> addAndGet(long delta) {
        return Tools.asyncFuture((CompletableFuture)this.delegateCounter.addAndGet(delta), (Executor)this.executor);
    }

    public CompletableFuture<Long> get() {
        return Tools.asyncFuture((CompletableFuture)this.delegateCounter.get(), (Executor)this.executor);
    }

    public CompletableFuture<Void> set(long value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateCounter.set(value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> compareAndSet(long expectedValue, long updateValue) {
        return Tools.asyncFuture((CompletableFuture)this.delegateCounter.compareAndSet(expectedValue, updateValue), (Executor)this.executor);
    }
}

