/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncAtomicCounterMap;
import org.onosproject.store.service.DistributedPrimitive;

public class ExecutingAsyncAtomicCounterMap<K>
extends ExecutingDistributedPrimitive
implements AsyncAtomicCounterMap<K> {
    private final AsyncAtomicCounterMap<K> delegateMap;
    private final Executor executor;

    public ExecutingAsyncAtomicCounterMap(AsyncAtomicCounterMap<K> delegateMap, Executor executor) {
        super((DistributedPrimitive)delegateMap, executor);
        this.delegateMap = delegateMap;
        this.executor = executor;
    }

    public CompletableFuture<Long> incrementAndGet(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.incrementAndGet(key), (Executor)this.executor);
    }

    public CompletableFuture<Long> decrementAndGet(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.decrementAndGet(key), (Executor)this.executor);
    }

    public CompletableFuture<Long> getAndIncrement(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.getAndIncrement(key), (Executor)this.executor);
    }

    public CompletableFuture<Long> getAndDecrement(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.getAndDecrement(key), (Executor)this.executor);
    }

    public CompletableFuture<Long> addAndGet(K key, long delta) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.addAndGet(key, delta), (Executor)this.executor);
    }

    public CompletableFuture<Long> getAndAdd(K key, long delta) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.getAndAdd(key, delta), (Executor)this.executor);
    }

    public CompletableFuture<Long> get(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.get(key), (Executor)this.executor);
    }

    public CompletableFuture<Long> put(K key, long newValue) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.put(key, newValue), (Executor)this.executor);
    }

    public CompletableFuture<Long> putIfAbsent(K key, long newValue) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.putIfAbsent(key, newValue), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> replace(K key, long expectedOldValue, long newValue) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.replace(key, expectedOldValue, newValue), (Executor)this.executor);
    }

    public CompletableFuture<Long> remove(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.remove(key), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> remove(K key, long value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.remove(key, value), (Executor)this.executor);
    }

    public CompletableFuture<Integer> size() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.size(), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> isEmpty() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.isEmpty(), (Executor)this.executor);
    }

    public CompletableFuture<Void> clear() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.clear(), (Executor)this.executor);
    }
}

