/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AtomicValueEventListener;
import org.onosproject.store.service.DistributedPrimitive;

public class ExecutingAsyncAtomicValue<V>
extends ExecutingDistributedPrimitive
implements AsyncAtomicValue<V> {
    private final AsyncAtomicValue<V> delegateValue;
    private final Executor executor;
    private final Map<AtomicValueEventListener<V>, AtomicValueEventListener<V>> listenerMap = Maps.newConcurrentMap();

    public ExecutingAsyncAtomicValue(AsyncAtomicValue<V> delegateValue, Executor executor) {
        super((DistributedPrimitive)delegateValue, executor);
        this.delegateValue = delegateValue;
        this.executor = executor;
    }

    public CompletableFuture<Boolean> compareAndSet(V expect, V update) {
        return Tools.asyncFuture((CompletableFuture)this.delegateValue.compareAndSet(expect, update), (Executor)this.executor);
    }

    public CompletableFuture<V> get() {
        return Tools.asyncFuture((CompletableFuture)this.delegateValue.get(), (Executor)this.executor);
    }

    public CompletableFuture<V> getAndSet(V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateValue.getAndSet(value), (Executor)this.executor);
    }

    public CompletableFuture<Void> set(V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateValue.set(value), (Executor)this.executor);
    }

    public CompletableFuture<Void> addListener(AtomicValueEventListener<V> listener) {
        AtomicValueEventListener wrappedListener = e -> this.executor.execute(() -> listener.event(e));
        this.listenerMap.put(listener, wrappedListener);
        return Tools.asyncFuture((CompletableFuture)this.delegateValue.addListener(wrappedListener), (Executor)this.executor);
    }

    public CompletableFuture<Void> removeListener(AtomicValueEventListener<V> listener) {
        AtomicValueEventListener<V> wrappedListener = this.listenerMap.remove(listener);
        if (wrappedListener != null) {
            return Tools.asyncFuture((CompletableFuture)this.delegateValue.removeListener(wrappedListener), (Executor)this.executor);
        }
        return CompletableFuture.completedFuture(null);
    }
}

