/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;
import org.onosproject.store.service.Versioned;

public class ExecutingAsyncConsistentMap<K, V>
extends ExecutingDistributedPrimitive
implements AsyncConsistentMap<K, V> {
    private final AsyncConsistentMap<K, V> delegateMap;
    private final Executor executor;

    public ExecutingAsyncConsistentMap(AsyncConsistentMap<K, V> delegateMap, Executor executor) {
        super((DistributedPrimitive)delegateMap, executor);
        this.delegateMap = delegateMap;
        this.executor = executor;
    }

    public CompletableFuture<Integer> size() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.size(), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.containsKey(key), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.containsValue(value), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> get(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.get(key), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> getOrDefault(K key, V defaultValue) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.getOrDefault(key, defaultValue), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.computeIf(key, condition, remappingFunction), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> put(K key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.put(key, value), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.putAndGet(key, value), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> remove(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.remove(key), (Executor)this.executor);
    }

    public CompletableFuture<Void> clear() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.clear(), (Executor)this.executor);
    }

    public CompletableFuture<Set<K>> keySet() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.keySet(), (Executor)this.executor);
    }

    public CompletableFuture<Collection<Versioned<V>>> values() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.values(), (Executor)this.executor);
    }

    public CompletableFuture<Set<Map.Entry<K, Versioned<V>>>> entrySet() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.entrySet(), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.putIfAbsent(key, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.remove(key, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> remove(K key, long version) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.remove(key, version), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> replace(K key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.replace(key, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.replace(key, oldValue, newValue), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.replace(key, oldVersion, newValue), (Executor)this.executor);
    }

    public CompletableFuture<Version> begin(TransactionId transactionId) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.begin(transactionId), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<K, V>> transactionLog) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.prepare(transactionLog), (Executor)this.executor);
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.commit(transactionId), (Executor)this.executor);
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.rollback(transactionId), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<MapUpdate<K, V>> transactionLog) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.prepareAndCommit(transactionLog), (Executor)this.executor);
    }

    public CompletableFuture<Void> addListener(MapEventListener<K, V> listener) {
        return this.addListener(listener, this.executor);
    }

    public CompletableFuture<Void> addListener(MapEventListener<K, V> listener, Executor executor) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.addListener(listener, executor), (Executor)this.executor);
    }

    public CompletableFuture<Void> removeListener(MapEventListener<K, V> listener) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.removeListener(listener), (Executor)this.executor);
    }
}

