/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncConsistentMultimap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Versioned;

public class ExecutingAsyncConsistentMultimap<K, V>
extends ExecutingDistributedPrimitive
implements AsyncConsistentMultimap<K, V> {
    private final AsyncConsistentMultimap<K, V> delegateMap;
    private final Executor executor;

    public ExecutingAsyncConsistentMultimap(AsyncConsistentMultimap<K, V> delegateMap, Executor executor) {
        super((DistributedPrimitive)delegateMap, executor);
        this.delegateMap = delegateMap;
        this.executor = executor;
    }

    public CompletableFuture<Integer> size() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.size(), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> isEmpty() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.isEmpty(), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.containsKey(key), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.containsValue(value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.containsEntry(key, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> put(K key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.put(key, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.remove(key, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> removeAll(K key, Collection<? extends V> values) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.removeAll(key, values), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<Collection<? extends V>>> removeAll(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.removeAll(key), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> putAll(K key, Collection<? extends V> values) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.putAll(key, values), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<Collection<? extends V>>> replaceValues(K key, Collection<V> values) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.replaceValues(key, values), (Executor)this.executor);
    }

    public CompletableFuture<Void> clear() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.clear(), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<Collection<? extends V>>> get(K key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.get(key), (Executor)this.executor);
    }

    public CompletableFuture<Set<K>> keySet() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.keySet(), (Executor)this.executor);
    }

    public CompletableFuture<Multiset<K>> keys() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.keys(), (Executor)this.executor);
    }

    public CompletableFuture<Multiset<V>> values() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.values(), (Executor)this.executor);
    }

    public CompletableFuture<Collection<Map.Entry<K, V>>> entries() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.entries(), (Executor)this.executor);
    }

    public CompletableFuture<Map<K, Collection<V>>> asMap() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.asMap(), (Executor)this.executor);
    }
}

