/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncConsistentTreeMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;
import org.onosproject.store.service.Versioned;

public class ExecutingAsyncConsistentTreeMap<V>
extends ExecutingDistributedPrimitive
implements AsyncConsistentTreeMap<V> {
    private final AsyncConsistentTreeMap<V> delegateMap;
    private final Executor executor;

    public ExecutingAsyncConsistentTreeMap(AsyncConsistentTreeMap<V> delegateMap, Executor executor) {
        super((DistributedPrimitive)delegateMap, executor);
        this.delegateMap = delegateMap;
        this.executor = executor;
    }

    public CompletableFuture<String> firstKey() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.firstKey(), (Executor)this.executor);
    }

    public CompletableFuture<String> lastKey() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.lastKey(), (Executor)this.executor);
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> ceilingEntry(String key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.ceilingEntry(key), (Executor)this.executor);
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> floorEntry(String key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.floorEntry(key), (Executor)this.executor);
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> higherEntry(String key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.higherEntry(key), (Executor)this.executor);
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> lowerEntry(String key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.lowerEntry(key), (Executor)this.executor);
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> firstEntry() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.firstEntry(), (Executor)this.executor);
    }

    public CompletableFuture<Integer> size() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.size(), (Executor)this.executor);
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> lastEntry() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.lastEntry(), (Executor)this.executor);
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> pollFirstEntry() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.pollFirstEntry(), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> containsKey(String key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.containsKey((Object)key), (Executor)this.executor);
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> pollLastEntry() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.pollLastEntry(), (Executor)this.executor);
    }

    public CompletableFuture<String> lowerKey(String key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.lowerKey(key), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.containsValue(value), (Executor)this.executor);
    }

    public CompletableFuture<String> floorKey(String key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.floorKey(key), (Executor)this.executor);
    }

    public CompletableFuture<String> ceilingKey(String key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.ceilingKey(key), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> get(String key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.get((Object)key), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> getOrDefault(String key, V defaultValue) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.getOrDefault((Object)key, defaultValue), (Executor)this.executor);
    }

    public CompletableFuture<String> higherKey(String key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.higherKey(key), (Executor)this.executor);
    }

    public CompletableFuture<NavigableSet<String>> navigableKeySet() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.navigableKeySet(), (Executor)this.executor);
    }

    public CompletableFuture<NavigableMap<String, V>> subMap(String upperKey, String lowerKey, boolean inclusiveUpper, boolean inclusiveLower) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.subMap(upperKey, lowerKey, inclusiveUpper, inclusiveLower), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> computeIf(String key, Predicate<? super V> condition, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.computeIf((Object)key, condition, remappingFunction), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> put(String key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.put((Object)key, value), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> putAndGet(String key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.putAndGet((Object)key, value), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> remove(String key) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.remove((Object)key), (Executor)this.executor);
    }

    public CompletableFuture<Void> clear() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.clear(), (Executor)this.executor);
    }

    public CompletableFuture<Set<String>> keySet() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.keySet(), (Executor)this.executor);
    }

    public CompletableFuture<Collection<Versioned<V>>> values() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.values(), (Executor)this.executor);
    }

    public CompletableFuture<Set<Map.Entry<String, Versioned<V>>>> entrySet() {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.entrySet(), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> putIfAbsent(String key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.putIfAbsent((Object)key, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> remove(String key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.remove((Object)key, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> remove(String key, long version) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.remove((Object)key, version), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> replace(String key, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.replace((Object)key, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> replace(String key, V oldValue, V newValue) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.replace((Object)key, oldValue, newValue), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> replace(String key, long oldVersion, V newValue) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.replace((Object)key, oldVersion, newValue), (Executor)this.executor);
    }

    public CompletableFuture<Version> begin(TransactionId transactionId) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.begin(transactionId), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<String, V>> transactionLog) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.prepare(transactionLog), (Executor)this.executor);
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.commit(transactionId), (Executor)this.executor);
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.rollback(transactionId), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<MapUpdate<String, V>> transactionLog) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.prepareAndCommit(transactionLog), (Executor)this.executor);
    }

    public CompletableFuture<Void> addListener(MapEventListener<String, V> listener) {
        return this.addListener(listener, this.executor);
    }

    public CompletableFuture<Void> addListener(MapEventListener<String, V> listener, Executor executor) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.addListener(listener, executor), (Executor)this.executor);
    }

    public CompletableFuture<Void> removeListener(MapEventListener<String, V> listener) {
        return Tools.asyncFuture((CompletableFuture)this.delegateMap.removeListener(listener), (Executor)this.executor);
    }
}

