/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTreeListener;
import org.onosproject.store.service.Versioned;

public class ExecutingAsyncDocumentTree<V>
extends ExecutingDistributedPrimitive
implements AsyncDocumentTree<V> {
    private final AsyncDocumentTree<V> delegateTree;
    private final Executor executor;
    private final Map<DocumentTreeListener<V>, DocumentTreeListener<V>> listenerMap = Maps.newConcurrentMap();

    public ExecutingAsyncDocumentTree(AsyncDocumentTree<V> delegateTree, Executor executor) {
        super((DistributedPrimitive)delegateTree, executor);
        this.delegateTree = delegateTree;
        this.executor = executor;
    }

    public DocumentPath root() {
        return this.delegateTree.root();
    }

    public CompletableFuture<Map<String, Versioned<V>>> getChildren(DocumentPath path) {
        return Tools.asyncFuture((CompletableFuture)this.delegateTree.getChildren(path), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> get(DocumentPath path) {
        return Tools.asyncFuture((CompletableFuture)this.delegateTree.get(path), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> set(DocumentPath path, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateTree.set(path, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> create(DocumentPath path, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateTree.create(path, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> createRecursive(DocumentPath path, V value) {
        return Tools.asyncFuture((CompletableFuture)this.delegateTree.createRecursive(path, value), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> replace(DocumentPath path, V newValue, long version) {
        return Tools.asyncFuture((CompletableFuture)this.delegateTree.replace(path, newValue, version), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> replace(DocumentPath path, V newValue, V currentValue) {
        return Tools.asyncFuture((CompletableFuture)this.delegateTree.replace(path, newValue, currentValue), (Executor)this.executor);
    }

    public CompletableFuture<Versioned<V>> removeNode(DocumentPath path) {
        return Tools.asyncFuture((CompletableFuture)this.delegateTree.removeNode(path), (Executor)this.executor);
    }

    public CompletableFuture<Void> addListener(DocumentPath path, DocumentTreeListener<V> listener) {
        DocumentTreeListener wrappedListener = e -> this.executor.execute(() -> listener.event(e));
        this.listenerMap.put(listener, wrappedListener);
        return Tools.asyncFuture((CompletableFuture)this.delegateTree.addListener(path, wrappedListener), (Executor)this.executor);
    }

    public CompletableFuture<Void> removeListener(DocumentTreeListener<V> listener) {
        DocumentTreeListener<V> wrappedListener = this.listenerMap.remove(listener);
        if (wrappedListener != null) {
            return Tools.asyncFuture((CompletableFuture)this.delegateTree.removeListener(wrappedListener), (Executor)this.executor);
        }
        return CompletableFuture.completedFuture(null);
    }
}

