/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.onlab.util.Tools;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Change;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.DistributedPrimitive;

public class ExecutingAsyncLeaderElector
extends ExecutingDistributedPrimitive
implements AsyncLeaderElector {
    private final AsyncLeaderElector delegateElector;
    private final Executor executor;
    private final Map<Consumer<Change<Leadership>>, Consumer<Change<Leadership>>> listenerMap = Maps.newConcurrentMap();

    public ExecutingAsyncLeaderElector(AsyncLeaderElector delegateElector, Executor executor) {
        super((DistributedPrimitive)delegateElector, executor);
        this.delegateElector = delegateElector;
        this.executor = executor;
    }

    public CompletableFuture<Leadership> run(String topic, NodeId nodeId) {
        return Tools.asyncFuture((CompletableFuture)this.delegateElector.run(topic, nodeId), (Executor)this.executor);
    }

    public CompletableFuture<Void> withdraw(String topic) {
        return Tools.asyncFuture((CompletableFuture)this.delegateElector.withdraw(topic), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> anoint(String topic, NodeId nodeId) {
        return Tools.asyncFuture((CompletableFuture)this.delegateElector.anoint(topic, nodeId), (Executor)this.executor);
    }

    public CompletableFuture<Void> evict(NodeId nodeId) {
        return Tools.asyncFuture((CompletableFuture)this.delegateElector.evict(nodeId), (Executor)this.executor);
    }

    public CompletableFuture<Boolean> promote(String topic, NodeId nodeId) {
        return Tools.asyncFuture((CompletableFuture)this.delegateElector.promote(topic, nodeId), (Executor)this.executor);
    }

    public CompletableFuture<Leadership> getLeadership(String topic) {
        return Tools.asyncFuture((CompletableFuture)this.delegateElector.getLeadership(topic), (Executor)this.executor);
    }

    public CompletableFuture<Map<String, Leadership>> getLeaderships() {
        return Tools.asyncFuture((CompletableFuture)this.delegateElector.getLeaderships(), (Executor)this.executor);
    }

    public CompletableFuture<Void> addChangeListener(Consumer<Change<Leadership>> listener) {
        Consumer<Change> wrappedListener = e -> this.executor.execute(() -> listener.accept((Change<Leadership>)e));
        this.listenerMap.put(listener, wrappedListener);
        return Tools.asyncFuture((CompletableFuture)this.delegateElector.addChangeListener(wrappedListener), (Executor)this.executor);
    }

    public CompletableFuture<Void> removeChangeListener(Consumer<Change<Leadership>> listener) {
        Consumer<Change<Leadership>> wrappedListener = this.listenerMap.remove(listener);
        if (wrappedListener != null) {
            return Tools.asyncFuture((CompletableFuture)this.delegateElector.removeChangeListener(wrappedListener), (Executor)this.executor);
        }
        return CompletableFuture.completedFuture(null);
    }
}

