/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.impl.DelegatingDistributedPrimitive;
import org.onosproject.store.service.DistributedPrimitive;

public abstract class ExecutingDistributedPrimitive
extends DelegatingDistributedPrimitive {
    private final DistributedPrimitive primitive;
    private final Executor executor;
    private final Map<Consumer<DistributedPrimitive.Status>, Consumer<DistributedPrimitive.Status>> listenerMap = Maps.newConcurrentMap();

    protected ExecutingDistributedPrimitive(DistributedPrimitive primitive, Executor executor) {
        super(primitive);
        this.primitive = primitive;
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    public CompletableFuture<Void> destroy() {
        return Tools.asyncFuture((CompletableFuture)this.primitive.destroy(), (Executor)this.executor);
    }

    @Override
    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        Consumer<DistributedPrimitive.Status> wrappedListener = status -> this.executor.execute(() -> listener.accept((DistributedPrimitive.Status)status));
        this.listenerMap.put(listener, wrappedListener);
        this.primitive.addStatusChangeListener(wrappedListener);
    }

    @Override
    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        Consumer<DistributedPrimitive.Status> wrappedListener = this.listenerMap.remove(listener);
        if (wrappedListener != null) {
            this.primitive.removeStatusChangeListener(wrappedListener);
        }
    }
}

