/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Task;
import org.onosproject.store.service.WorkQueue;
import org.onosproject.store.service.WorkQueueStats;

public class ExecutingWorkQueue<E>
extends ExecutingDistributedPrimitive
implements WorkQueue<E> {
    private final WorkQueue<E> delegateQueue;
    private final Executor executor;

    public ExecutingWorkQueue(WorkQueue<E> delegateQueue, Executor executor) {
        super((DistributedPrimitive)delegateQueue, executor);
        this.delegateQueue = delegateQueue;
        this.executor = executor;
    }

    public CompletableFuture<Void> addMultiple(Collection<E> items) {
        return Tools.asyncFuture((CompletableFuture)this.delegateQueue.addMultiple(items), (Executor)this.executor);
    }

    public CompletableFuture<Collection<Task<E>>> take(int maxItems) {
        return Tools.asyncFuture((CompletableFuture)this.delegateQueue.take(maxItems), (Executor)this.executor);
    }

    public CompletableFuture<Void> complete(Collection<String> taskIds) {
        return Tools.asyncFuture((CompletableFuture)this.delegateQueue.complete(taskIds), (Executor)this.executor);
    }

    public CompletableFuture<Void> registerTaskProcessor(Consumer<E> taskProcessor, int parallelism, Executor executor) {
        return Tools.asyncFuture((CompletableFuture)this.delegateQueue.registerTaskProcessor(taskProcessor, parallelism, executor), (Executor)this.executor);
    }

    public CompletableFuture<Void> stopProcessing() {
        return Tools.asyncFuture((CompletableFuture)this.delegateQueue.stopProcessing(), (Executor)this.executor);
    }

    public CompletableFuture<WorkQueueStats> stats() {
        return Tools.asyncFuture((CompletableFuture)this.delegateQueue.stats(), (Executor)this.executor);
    }
}

