/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Transactional;
import org.onosproject.store.service.Version;

public class Transaction<T> {
    private static final String TX_OPEN_ERROR = "transaction already open";
    private static final String TX_CLOSED_ERROR = "transaction not open";
    private static final String TX_INACTIVE_ERROR = "transaction is not active";
    private static final String TX_UNPREPARED_ERROR = "transaction has not been prepared";
    protected final TransactionId transactionId;
    protected final Transactional<T> transactionalObject;
    private final AtomicBoolean open = new AtomicBoolean();
    private volatile State state = State.ACTIVE;

    public Transaction(TransactionId transactionId, Transactional<T> transactionalObject) {
        this.transactionId = transactionId;
        this.transactionalObject = transactionalObject;
    }

    public TransactionId transactionId() {
        return this.transactionId;
    }

    public State state() {
        return this.state;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    protected void open() {
        if (!this.open.compareAndSet(false, true)) {
            throw new IllegalStateException(TX_OPEN_ERROR);
        }
    }

    protected void checkOpen() {
        Preconditions.checkState((boolean)this.isOpen(), (Object)TX_CLOSED_ERROR);
    }

    protected void checkActive() {
        Preconditions.checkState((this.state == State.ACTIVE ? 1 : 0) != 0, (Object)TX_INACTIVE_ERROR);
    }

    protected void checkPrepared() {
        Preconditions.checkState((this.state == State.PREPARED ? 1 : 0) != 0, (Object)TX_UNPREPARED_ERROR);
    }

    protected void setState(State state) {
        this.state = state;
    }

    public CompletableFuture<Version> begin() {
        this.open();
        return this.transactionalObject.begin(this.transactionId);
    }

    public CompletableFuture<Boolean> prepare(List<T> updates) {
        this.checkOpen();
        this.checkActive();
        this.setState(State.PREPARING);
        return this.transactionalObject.prepare(new TransactionLog(this.transactionId, updates)).thenApply(succeeded -> {
            this.setState(State.PREPARED);
            return succeeded;
        });
    }

    public CompletableFuture<Boolean> prepareAndCommit(List<T> updates) {
        this.checkOpen();
        this.checkActive();
        this.setState(State.PREPARING);
        return this.transactionalObject.prepareAndCommit(new TransactionLog(this.transactionId, updates)).thenApply(succeeded -> {
            this.setState(State.COMMITTED);
            return succeeded;
        });
    }

    public CompletableFuture<Void> commit() {
        this.checkOpen();
        this.checkPrepared();
        this.setState(State.COMMITTING);
        return this.transactionalObject.commit(this.transactionId).thenRun(() -> this.setState(State.COMMITTED));
    }

    public CompletableFuture<Void> rollback() {
        this.checkOpen();
        this.checkPrepared();
        this.setState(State.ROLLING_BACK);
        return this.transactionalObject.rollback(this.transactionId).thenRun(() -> this.setState(State.ROLLED_BACK));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("transactionId", (Object)this.transactionId).add("state", (Object)this.state).toString();
    }

    static enum State {
        ACTIVE,
        PREPARING,
        PREPARED,
        COMMITTING,
        COMMITTED,
        ROLLING_BACK,
        ROLLED_BACK;

    }
}

