/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;

public final class AtomixAtomicCounterMapCommands {
    private AtomixAtomicCounterMapCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        public void resolve(SerializerRegistry registry) {
            registry.register(Get.class, -790);
            registry.register(Put.class, -791);
            registry.register(PutIfAbsent.class, -792);
            registry.register(Replace.class, -793);
            registry.register(Remove.class, -794);
            registry.register(RemoveValue.class, -795);
            registry.register(IncrementAndGet.class, -796);
            registry.register(DecrementAndGet.class, -797);
            registry.register(GetAndIncrement.class, -798);
            registry.register(GetAndDecrement.class, -799);
            registry.register(AddAndGet.class, -800);
            registry.register(GetAndAdd.class, -801);
            registry.register(Size.class, -801);
            registry.register(IsEmpty.class, -801);
            registry.register(Clear.class, -801);
        }
    }

    public static class Clear
    extends AtomicCounterMapCommand<Void> {
    }

    public static class IsEmpty
    extends AtomicCounterMapQuery<Boolean> {
    }

    public static class Size
    extends AtomicCounterMapQuery<Integer> {
    }

    public static class GetAndAdd
    extends DeltaCommand {
        public GetAndAdd() {
        }

        public GetAndAdd(String key, long delta) {
            super(key, delta);
        }
    }

    public static class AddAndGet
    extends DeltaCommand {
        public AddAndGet() {
        }

        public AddAndGet(String key, long delta) {
            super(key, delta);
        }
    }

    public static abstract class DeltaCommand
    extends KeyCommand<Long> {
        private long delta;

        public DeltaCommand() {
        }

        public DeltaCommand(String key, long delta) {
            super(key);
            this.delta = delta;
        }

        public long delta() {
            return this.delta;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeLong(this.delta);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.delta = buffer.readLong();
        }
    }

    public static class GetAndDecrement
    extends KeyCommand<Long> {
        public GetAndDecrement() {
        }

        public GetAndDecrement(String key) {
            super(key);
        }
    }

    public static class GetAndIncrement
    extends KeyCommand<Long> {
        public GetAndIncrement() {
        }

        public GetAndIncrement(String key) {
            super(key);
        }
    }

    public static class DecrementAndGet
    extends KeyCommand<Long> {
        public DecrementAndGet(String key) {
            super(key);
        }

        public DecrementAndGet() {
        }
    }

    public static class IncrementAndGet
    extends KeyCommand<Long> {
        public IncrementAndGet() {
        }

        public IncrementAndGet(String key) {
            super(key);
        }
    }

    public static class RemoveValue
    extends KeyValueCommand<Boolean> {
        public RemoveValue() {
        }

        public RemoveValue(String key, long value) {
            super(key, value);
        }
    }

    public static class Remove
    extends KeyCommand<Long> {
        public Remove() {
        }

        public Remove(String key) {
            super(key);
        }
    }

    public static class Replace
    extends KeyCommand<Boolean> {
        private long replace;
        private long value;

        public Replace() {
        }

        public Replace(String key, long replace, long value) {
            super(key);
            this.replace = replace;
            this.value = value;
        }

        public long replace() {
            return this.replace;
        }

        public long value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeLong(this.replace);
            buffer.writeLong(this.value);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.replace = buffer.readLong();
            this.value = buffer.readLong();
        }
    }

    public static class PutIfAbsent
    extends KeyValueCommand<Long> {
        public PutIfAbsent() {
        }

        public PutIfAbsent(String key, long value) {
            super(key, value);
        }
    }

    public static class Put
    extends KeyValueCommand<Long> {
        public Put() {
        }

        public Put(String key, long value) {
            super(key, value);
        }
    }

    public static class Get
    extends KeyQuery<Long> {
        public Get() {
        }

        public Get(String key) {
            super(key);
        }
    }

    public static class KeyValueCommand<V>
    extends KeyCommand<V> {
        private long value;

        public KeyValueCommand() {
        }

        public KeyValueCommand(String key, long value) {
            super(key);
            this.value = value;
        }

        public long value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeLong(this.value);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = buffer.readLong();
        }
    }

    public static abstract class KeyQuery<V>
    extends AtomicCounterMapQuery<V> {
        private String key;

        public KeyQuery() {
        }

        public KeyQuery(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeString(this.key);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.key = buffer.readString();
        }
    }

    public static abstract class KeyCommand<V>
    extends AtomicCounterMapCommand<V> {
        private String key;

        public KeyCommand() {
        }

        public KeyCommand(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeString(this.key);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.key = buffer.readString();
        }
    }

    public static abstract class AtomicCounterMapQuery<V>
    implements Query<V>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    public static abstract class AtomicCounterMapCommand<V>
    implements Command<V>,
    CatalystSerializable {
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SNAPSHOT;
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

