/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.resource.ResourceStateMachine;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.onosproject.store.primitives.resources.impl.AtomixAtomicCounterMapCommands;

public class AtomixAtomicCounterMapState
extends ResourceStateMachine
implements Snapshottable {
    private Map<String, Long> map = new HashMap<String, Long>();

    public AtomixAtomicCounterMapState(Properties config) {
        super(config);
    }

    protected void configure(StateMachineExecutor executor) {
        executor.register(AtomixAtomicCounterMapCommands.Put.class, this::put);
        executor.register(AtomixAtomicCounterMapCommands.PutIfAbsent.class, this::putIfAbsent);
        executor.register(AtomixAtomicCounterMapCommands.Get.class, this::get);
        executor.register(AtomixAtomicCounterMapCommands.Replace.class, this::replace);
        executor.register(AtomixAtomicCounterMapCommands.Remove.class, this::remove);
        executor.register(AtomixAtomicCounterMapCommands.RemoveValue.class, this::removeValue);
        executor.register(AtomixAtomicCounterMapCommands.GetAndIncrement.class, this::getAndIncrement);
        executor.register(AtomixAtomicCounterMapCommands.GetAndDecrement.class, this::getAndDecrement);
        executor.register(AtomixAtomicCounterMapCommands.IncrementAndGet.class, this::incrementAndGet);
        executor.register(AtomixAtomicCounterMapCommands.DecrementAndGet.class, this::decrementAndGet);
        executor.register(AtomixAtomicCounterMapCommands.AddAndGet.class, this::addAndGet);
        executor.register(AtomixAtomicCounterMapCommands.GetAndAdd.class, this::getAndAdd);
        executor.register(AtomixAtomicCounterMapCommands.Size.class, this::size);
        executor.register(AtomixAtomicCounterMapCommands.IsEmpty.class, this::isEmpty);
        executor.register(AtomixAtomicCounterMapCommands.Clear.class, this::clear);
    }

    public void snapshot(SnapshotWriter writer) {
        writer.writeObject(this.map);
    }

    public void install(SnapshotReader reader) {
        this.map = (Map)reader.readObject();
    }

    private long primitive(Long value) {
        if (value != null) {
            return value;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long put(Commit<AtomixAtomicCounterMapCommands.Put> commit) {
        try {
            long l = this.primitive(this.map.put(((AtomixAtomicCounterMapCommands.Put)commit.operation()).key(), ((AtomixAtomicCounterMapCommands.Put)commit.operation()).value()));
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long putIfAbsent(Commit<AtomixAtomicCounterMapCommands.PutIfAbsent> commit) {
        try {
            long l = this.primitive(this.map.putIfAbsent(((AtomixAtomicCounterMapCommands.PutIfAbsent)commit.operation()).key(), ((AtomixAtomicCounterMapCommands.PutIfAbsent)commit.operation()).value()));
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long get(Commit<AtomixAtomicCounterMapCommands.Get> commit) {
        try {
            long l = this.primitive(this.map.get(((AtomixAtomicCounterMapCommands.Get)commit.operation()).key()));
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean replace(Commit<AtomixAtomicCounterMapCommands.Replace> commit) {
        try {
            Long value = this.map.get(((AtomixAtomicCounterMapCommands.Replace)commit.operation()).key());
            if (value == null) {
                if (((AtomixAtomicCounterMapCommands.Replace)commit.operation()).replace() == 0L) {
                    this.map.put(((AtomixAtomicCounterMapCommands.Replace)commit.operation()).key(), ((AtomixAtomicCounterMapCommands.Replace)commit.operation()).value());
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (value.longValue() == ((AtomixAtomicCounterMapCommands.Replace)commit.operation()).replace()) {
                this.map.put(((AtomixAtomicCounterMapCommands.Replace)commit.operation()).key(), ((AtomixAtomicCounterMapCommands.Replace)commit.operation()).value());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long remove(Commit<AtomixAtomicCounterMapCommands.Remove> commit) {
        try {
            long l = this.primitive(this.map.remove(((AtomixAtomicCounterMapCommands.Remove)commit.operation()).key()));
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeValue(Commit<AtomixAtomicCounterMapCommands.RemoveValue> commit) {
        try {
            Long value = this.map.get(((AtomixAtomicCounterMapCommands.RemoveValue)commit.operation()).key());
            if (value == null) {
                if (((AtomixAtomicCounterMapCommands.RemoveValue)commit.operation()).value() == 0L) {
                    this.map.remove(((AtomixAtomicCounterMapCommands.RemoveValue)commit.operation()).key());
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (value.longValue() == ((AtomixAtomicCounterMapCommands.RemoveValue)commit.operation()).value()) {
                this.map.remove(((AtomixAtomicCounterMapCommands.RemoveValue)commit.operation()).key());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getAndIncrement(Commit<AtomixAtomicCounterMapCommands.GetAndIncrement> commit) {
        try {
            long value = this.primitive(this.map.get(((AtomixAtomicCounterMapCommands.GetAndIncrement)commit.operation()).key()));
            this.map.put(((AtomixAtomicCounterMapCommands.GetAndIncrement)commit.operation()).key(), value + 1L);
            long l = value;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getAndDecrement(Commit<AtomixAtomicCounterMapCommands.GetAndDecrement> commit) {
        try {
            long value = this.primitive(this.map.get(((AtomixAtomicCounterMapCommands.GetAndDecrement)commit.operation()).key()));
            this.map.put(((AtomixAtomicCounterMapCommands.GetAndDecrement)commit.operation()).key(), value - 1L);
            long l = value;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long incrementAndGet(Commit<AtomixAtomicCounterMapCommands.IncrementAndGet> commit) {
        try {
            long value = this.primitive(this.map.get(((AtomixAtomicCounterMapCommands.IncrementAndGet)commit.operation()).key()));
            this.map.put(((AtomixAtomicCounterMapCommands.IncrementAndGet)commit.operation()).key(), ++value);
            long l = value;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long decrementAndGet(Commit<AtomixAtomicCounterMapCommands.DecrementAndGet> commit) {
        try {
            long value = this.primitive(this.map.get(((AtomixAtomicCounterMapCommands.DecrementAndGet)commit.operation()).key()));
            this.map.put(((AtomixAtomicCounterMapCommands.DecrementAndGet)commit.operation()).key(), --value);
            long l = value;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long addAndGet(Commit<AtomixAtomicCounterMapCommands.AddAndGet> commit) {
        try {
            long value = this.primitive(this.map.get(((AtomixAtomicCounterMapCommands.AddAndGet)commit.operation()).key()));
            this.map.put(((AtomixAtomicCounterMapCommands.AddAndGet)commit.operation()).key(), value += ((AtomixAtomicCounterMapCommands.AddAndGet)commit.operation()).delta());
            long l = value;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getAndAdd(Commit<AtomixAtomicCounterMapCommands.GetAndAdd> commit) {
        try {
            long value = this.primitive(this.map.get(((AtomixAtomicCounterMapCommands.GetAndAdd)commit.operation()).key()));
            this.map.put(((AtomixAtomicCounterMapCommands.GetAndAdd)commit.operation()).key(), value + ((AtomixAtomicCounterMapCommands.GetAndAdd)commit.operation()).delta());
            long l = value;
            return l;
        }
        finally {
            commit.close();
        }
    }

    protected int size(Commit<AtomixAtomicCounterMapCommands.Size> commit) {
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            commit.close();
        }
    }

    protected boolean isEmpty(Commit<AtomixAtomicCounterMapCommands.IsEmpty> commit) {
        try {
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected void clear(Commit<AtomixAtomicCounterMapCommands.Clear> commit) {
        try {
            this.map.clear();
        }
        finally {
            commit.close();
        }
    }
}

