/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.copycat.session.Session;
import io.atomix.resource.ResourceStateMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.onlab.util.CountDownCompleter;
import org.onlab.util.Match;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMapCommands;
import org.onosproject.store.primitives.resources.impl.CommitResult;
import org.onosproject.store.primitives.resources.impl.MapEntryUpdateResult;
import org.onosproject.store.primitives.resources.impl.PrepareResult;
import org.onosproject.store.primitives.resources.impl.RollbackResult;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixConsistentMapState
extends ResourceStateMachine
implements SessionListener,
Snapshottable {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<Long, Commit<? extends AtomixConsistentMapCommands.Listen>> listeners = new HashMap<Long, Commit<? extends AtomixConsistentMapCommands.Listen>>();
    private final Map<String, MapEntryValue> mapEntries = new HashMap<String, MapEntryValue>();
    private final Set<String> preparedKeys = Sets.newHashSet();
    private final Map<TransactionId, Commit<? extends AtomixConsistentMapCommands.TransactionPrepare>> pendingTransactions = Maps.newHashMap();
    private AtomicLong versionCounter = new AtomicLong(0L);

    public AtomixConsistentMapState(Properties properties) {
        super(properties);
    }

    public void snapshot(SnapshotWriter writer) {
        writer.writeLong(this.versionCounter.get());
    }

    public void install(SnapshotReader reader) {
        this.versionCounter = new AtomicLong(reader.readLong());
    }

    protected void configure(StateMachineExecutor executor) {
        executor.register(AtomixConsistentMapCommands.Listen.class, this::listen);
        executor.register(AtomixConsistentMapCommands.Unlisten.class, this::unlisten);
        executor.register(AtomixConsistentMapCommands.ContainsKey.class, this::containsKey);
        executor.register(AtomixConsistentMapCommands.ContainsValue.class, this::containsValue);
        executor.register(AtomixConsistentMapCommands.EntrySet.class, this::entrySet);
        executor.register(AtomixConsistentMapCommands.Get.class, this::get);
        executor.register(AtomixConsistentMapCommands.GetOrDefault.class, this::getOrDefault);
        executor.register(AtomixConsistentMapCommands.IsEmpty.class, this::isEmpty);
        executor.register(AtomixConsistentMapCommands.KeySet.class, this::keySet);
        executor.register(AtomixConsistentMapCommands.Size.class, this::size);
        executor.register(AtomixConsistentMapCommands.Values.class, this::values);
        executor.register(AtomixConsistentMapCommands.UpdateAndGet.class, this::updateAndGet);
        executor.register(AtomixConsistentMapCommands.Clear.class, this::clear);
        executor.register(AtomixConsistentMapCommands.TransactionBegin.class, this::begin);
        executor.register(AtomixConsistentMapCommands.TransactionPrepare.class, this::prepare);
        executor.register(AtomixConsistentMapCommands.TransactionCommit.class, this::commit);
        executor.register(AtomixConsistentMapCommands.TransactionRollback.class, this::rollback);
        executor.register(AtomixConsistentMapCommands.TransactionPrepareAndCommit.class, this::prepareAndCommit);
    }

    public void delete() {
        this.listeners.values().forEach(Commit::close);
        this.listeners.clear();
        this.mapEntries.values().forEach(MapEntryValue::discard);
        this.mapEntries.clear();
    }

    protected boolean containsKey(Commit<? extends AtomixConsistentMapCommands.ContainsKey> commit) {
        try {
            boolean bl = this.toVersioned(this.mapEntries.get(((AtomixConsistentMapCommands.ContainsKey)commit.operation()).key())) != null;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsValue(Commit<? extends AtomixConsistentMapCommands.ContainsValue> commit) {
        try {
            Match valueMatch = Match.ifValue((Object)((AtomixConsistentMapCommands.ContainsValue)commit.operation()).value());
            boolean bl = this.mapEntries.values().stream().anyMatch(value -> valueMatch.matches((Object)value.value()));
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected Versioned<byte[]> get(Commit<? extends AtomixConsistentMapCommands.Get> commit) {
        try {
            Versioned<byte[]> versioned = this.toVersioned(this.mapEntries.get(((AtomixConsistentMapCommands.Get)commit.operation()).key()));
            return versioned;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Versioned<byte[]> getOrDefault(Commit<? extends AtomixConsistentMapCommands.GetOrDefault> commit) {
        try {
            Versioned value = this.toVersioned(this.mapEntries.get(((AtomixConsistentMapCommands.GetOrDefault)commit.operation()).key()));
            Versioned versioned = value != null ? value : new Versioned((Object)((AtomixConsistentMapCommands.GetOrDefault)commit.operation()).defaultValue(), 0L);
            return versioned;
        }
        finally {
            commit.close();
        }
    }

    protected int size(Commit<? extends AtomixConsistentMapCommands.Size> commit) {
        try {
            int n = this.mapEntries.size();
            return n;
        }
        finally {
            commit.close();
        }
    }

    protected boolean isEmpty(Commit<? extends AtomixConsistentMapCommands.IsEmpty> commit) {
        try {
            boolean bl = this.mapEntries.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected Set<String> keySet(Commit<? extends AtomixConsistentMapCommands.KeySet> commit) {
        try {
            Set<String> set = this.mapEntries.keySet().stream().collect(Collectors.toSet());
            return set;
        }
        finally {
            commit.close();
        }
    }

    protected Collection<Versioned<byte[]>> values(Commit<? extends AtomixConsistentMapCommands.Values> commit) {
        try {
            Collection collection = this.mapEntries.values().stream().map(this::toVersioned).collect(Collectors.toList());
            return collection;
        }
        finally {
            commit.close();
        }
    }

    protected Set<Map.Entry<String, Versioned<byte[]>>> entrySet(Commit<? extends AtomixConsistentMapCommands.EntrySet> commit) {
        try {
            Set<Map.Entry<String, Versioned<byte[]>>> set = this.mapEntries.entrySet().stream().map(e -> Maps.immutableEntry(e.getKey(), this.toVersioned((MapEntryValue)e.getValue()))).collect(Collectors.toSet());
            return set;
        }
        finally {
            commit.close();
        }
    }

    protected MapEntryUpdateResult<String, byte[]> updateAndGet(Commit<? extends AtomixConsistentMapCommands.UpdateAndGet> commit) {
        try {
            MapEvent.Type updateType;
            Versioned newMapValue;
            MapEntryUpdateResult.Status updateStatus = this.validate((AtomixConsistentMapCommands.UpdateAndGet)commit.operation());
            String key = ((AtomixConsistentMapCommands.UpdateAndGet)commit.operation()).key();
            MapEntryValue oldCommitValue = this.mapEntries.get(((AtomixConsistentMapCommands.UpdateAndGet)commit.operation()).key());
            Versioned<byte[]> oldMapValue = this.toVersioned(oldCommitValue);
            if (updateStatus != MapEntryUpdateResult.Status.OK) {
                commit.close();
                return new MapEntryUpdateResult<String, byte[]>(updateStatus, "", key, oldMapValue, oldMapValue);
            }
            byte[] newValue = ((AtomixConsistentMapCommands.UpdateAndGet)commit.operation()).value();
            long newVersion = this.versionCounter.incrementAndGet();
            Versioned versioned = newMapValue = newValue == null ? null : new Versioned((Object)newValue, newVersion);
            MapEvent.Type type = newValue == null ? MapEvent.Type.REMOVE : (updateType = oldCommitValue == null ? MapEvent.Type.INSERT : MapEvent.Type.UPDATE);
            if (updateType == MapEvent.Type.REMOVE || updateType == MapEvent.Type.UPDATE) {
                this.mapEntries.remove(key);
                oldCommitValue.discard();
            }
            if (updateType == MapEvent.Type.INSERT || updateType == MapEvent.Type.UPDATE) {
                this.mapEntries.put(key, new NonTransactionalCommit(newVersion, commit));
            } else {
                commit.close();
            }
            this.publish(Lists.newArrayList((Object[])new MapEvent[]{new MapEvent("", (Object)key, newMapValue, oldMapValue)}));
            return new MapEntryUpdateResult<String, byte[]>(updateStatus, "", key, oldMapValue, newMapValue);
        }
        catch (Exception e) {
            this.log.error("State machine operation failed", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapEntryUpdateResult.Status clear(Commit<? extends AtomixConsistentMapCommands.Clear> commit) {
        try {
            Iterator<Map.Entry<String, MapEntryValue>> iterator = this.mapEntries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, MapEntryValue> entry = iterator.next();
                String key = entry.getKey();
                MapEntryValue value = entry.getValue();
                Versioned removedValue = new Versioned((Object)value.value(), value.version());
                this.publish(Lists.newArrayList((Object[])new MapEvent[]{new MapEvent("", (Object)key, null, removedValue)}));
                value.discard();
                iterator.remove();
            }
            MapEntryUpdateResult.Status status = MapEntryUpdateResult.Status.OK;
            return status;
        }
        finally {
            commit.close();
        }
    }

    protected void listen(Commit<? extends AtomixConsistentMapCommands.Listen> commit) {
        Long sessionId = commit.session().id();
        if (this.listeners.putIfAbsent(sessionId, commit) != null) {
            commit.close();
            return;
        }
        commit.session().onStateChange(state -> {
            Commit<? extends AtomixConsistentMapCommands.Listen> listener;
            if ((state == Session.State.CLOSED || state == Session.State.EXPIRED) && (listener = this.listeners.remove(sessionId)) != null) {
                listener.close();
            }
        });
    }

    protected void unlisten(Commit<? extends AtomixConsistentMapCommands.Unlisten> commit) {
        try {
            Commit<? extends AtomixConsistentMapCommands.Listen> listener = this.listeners.remove(commit.session().id());
            if (listener != null) {
                listener.close();
            }
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long begin(Commit<? extends AtomixConsistentMapCommands.TransactionBegin> commit) {
        try {
            long l = commit.index();
            return l;
        }
        finally {
            commit.close();
        }
    }

    protected PrepareResult prepareAndCommit(Commit<? extends AtomixConsistentMapCommands.TransactionPrepareAndCommit> commit) {
        PrepareResult prepareResult = this.prepare(commit);
        if (prepareResult == PrepareResult.OK) {
            this.commitInternal(((AtomixConsistentMapCommands.TransactionPrepareAndCommit)commit.operation()).transactionLog().transactionId());
        }
        return prepareResult;
    }

    protected PrepareResult prepare(Commit<? extends AtomixConsistentMapCommands.TransactionPrepare> commit) {
        boolean ok = false;
        try {
            TransactionLog<MapUpdate<String, byte[]>> transaction = ((AtomixConsistentMapCommands.TransactionPrepare)commit.operation()).transactionLog();
            for (MapUpdate update : transaction.records()) {
                String key = (String)update.key();
                if (this.preparedKeys.contains(key)) {
                    PrepareResult prepareResult = PrepareResult.CONCURRENT_TRANSACTION;
                    return prepareResult;
                }
                MapEntryValue existingValue = this.mapEntries.get(key);
                if (existingValue == null) {
                    if (update.type() == MapUpdate.Type.PUT_IF_ABSENT) continue;
                    PrepareResult prepareResult = PrepareResult.OPTIMISTIC_LOCK_FAILURE;
                    return prepareResult;
                }
                if (existingValue.version() == update.currentVersion()) continue;
                PrepareResult prepareResult = PrepareResult.OPTIMISTIC_LOCK_FAILURE;
                return prepareResult;
            }
            this.pendingTransactions.put(transaction.transactionId(), commit);
            transaction.records().forEach(u -> this.preparedKeys.add((String)u.key()));
            ok = true;
            Object object = PrepareResult.OK;
            return object;
        }
        catch (Exception e) {
            this.log.warn("Failure applying {}", commit, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            if (!ok) {
                commit.close();
            }
        }
    }

    protected CommitResult commit(Commit<? extends AtomixConsistentMapCommands.TransactionCommit> commit) {
        TransactionId transactionId = ((AtomixConsistentMapCommands.TransactionCommit)commit.operation()).transactionId();
        try {
            CommitResult commitResult = this.commitInternal(transactionId);
            return commitResult;
        }
        catch (Exception e) {
            this.log.warn("Failure applying {}", commit, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            commit.close();
        }
    }

    private CommitResult commitInternal(TransactionId transactionId) {
        Commit<? extends AtomixConsistentMapCommands.TransactionPrepare> prepareCommit = this.pendingTransactions.remove(transactionId);
        if (prepareCommit == null) {
            return CommitResult.UNKNOWN_TRANSACTION_ID;
        }
        TransactionLog<MapUpdate<String, byte[]>> transaction = ((AtomixConsistentMapCommands.TransactionPrepare)prepareCommit.operation()).transactionLog();
        long totalReferencesToCommit = transaction.records().stream().filter(update -> update.type() != MapUpdate.Type.REMOVE_IF_VERSION_MATCH).count();
        CountDownCompleter completer = new CountDownCompleter(prepareCommit, totalReferencesToCommit, Commit::close);
        ArrayList eventsToPublish = Lists.newArrayList();
        for (MapUpdate update2 : transaction.records()) {
            String key = (String)update2.key();
            Preconditions.checkState((boolean)this.preparedKeys.remove(key), (Object)"key is not prepared");
            MapEntryValue previousValue = this.mapEntries.remove(key);
            TransactionalCommit newValue = null;
            if (update2.type() != MapUpdate.Type.REMOVE_IF_VERSION_MATCH) {
                newValue = new TransactionalCommit(key, this.versionCounter.incrementAndGet(), (CountDownCompleter<Commit<? extends AtomixConsistentMapCommands.TransactionPrepare>>)completer);
            }
            eventsToPublish.add(new MapEvent("", (Object)key, this.toVersioned(newValue), this.toVersioned(previousValue)));
            if (newValue != null) {
                this.mapEntries.put(key, newValue);
            }
            if (previousValue == null) continue;
            previousValue.discard();
        }
        this.publish(eventsToPublish);
        return CommitResult.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RollbackResult rollback(Commit<? extends AtomixConsistentMapCommands.TransactionRollback> commit) {
        TransactionId transactionId = ((AtomixConsistentMapCommands.TransactionRollback)commit.operation()).transactionId();
        try {
            Commit<? extends AtomixConsistentMapCommands.TransactionPrepare> prepareCommit = this.pendingTransactions.remove(transactionId);
            if (prepareCommit == null) {
                RollbackResult rollbackResult = RollbackResult.UNKNOWN_TRANSACTION_ID;
                return rollbackResult;
            }
            ((AtomixConsistentMapCommands.TransactionPrepare)prepareCommit.operation()).transactionLog().records().forEach(u -> this.preparedKeys.remove(u.key()));
            prepareCommit.close();
            RollbackResult rollbackResult = RollbackResult.OK;
            return rollbackResult;
        }
        finally {
            commit.close();
        }
    }

    private MapEntryUpdateResult.Status validate(AtomixConsistentMapCommands.UpdateAndGet update) {
        MapEntryValue existingValue = this.mapEntries.get(update.key());
        if (existingValue == null && update.value() == null) {
            return MapEntryUpdateResult.Status.NOOP;
        }
        if (this.preparedKeys.contains(update.key())) {
            return MapEntryUpdateResult.Status.WRITE_LOCK;
        }
        byte[] existingRawValue = existingValue == null ? null : existingValue.value();
        Long existingVersion = existingValue == null ? null : Long.valueOf(existingValue.version());
        return update.valueMatch().matches((Object)existingRawValue) && update.versionMatch().matches((Object)existingVersion) ? MapEntryUpdateResult.Status.OK : MapEntryUpdateResult.Status.PRECONDITION_FAILED;
    }

    private Versioned<byte[]> toVersioned(MapEntryValue value) {
        return value == null ? null : new Versioned((Object)value.value(), value.version());
    }

    private void publish(List<MapEvent<String, byte[]>> events) {
        this.listeners.values().forEach(commit -> commit.session().publish("changeEvents", (Object)events));
    }

    public void register(ServerSession session) {
    }

    public void unregister(ServerSession session) {
        this.closeListener(session.id());
    }

    public void expire(ServerSession session) {
        this.closeListener(session.id());
    }

    public void close(ServerSession session) {
        this.closeListener(session.id());
    }

    private void closeListener(Long sessionId) {
        Commit<? extends AtomixConsistentMapCommands.Listen> commit = this.listeners.remove(sessionId);
        if (commit != null) {
            commit.close();
        }
    }

    private class TransactionalCommit
    implements MapEntryValue {
        private final String key;
        private final long version;
        private final CountDownCompleter<Commit<? extends AtomixConsistentMapCommands.TransactionPrepare>> completer;

        public TransactionalCommit(String key, long version, CountDownCompleter<Commit<? extends AtomixConsistentMapCommands.TransactionPrepare>> commit) {
            this.key = key;
            this.version = version;
            this.completer = commit;
        }

        @Override
        public byte[] value() {
            TransactionLog<MapUpdate<String, byte[]>> transaction = ((AtomixConsistentMapCommands.TransactionPrepare)((Commit)this.completer.object()).operation()).transactionLog();
            return this.valueForKey(this.key, transaction);
        }

        @Override
        public long version() {
            return this.version;
        }

        @Override
        public void discard() {
            this.completer.countDown();
        }

        private byte[] valueForKey(String key, TransactionLog<MapUpdate<String, byte[]>> transaction) {
            MapUpdate update = transaction.records().stream().filter(u -> ((String)u.key()).equals(key)).findFirst().orElse(null);
            return update == null ? null : (byte[])update.value();
        }
    }

    private class NonTransactionalCommit
    implements MapEntryValue {
        private final long version;
        private final Commit<? extends AtomixConsistentMapCommands.UpdateAndGet> commit;

        public NonTransactionalCommit(long version, Commit<? extends AtomixConsistentMapCommands.UpdateAndGet> commit) {
            this.version = version;
            this.commit = commit;
        }

        @Override
        public byte[] value() {
            return ((AtomixConsistentMapCommands.UpdateAndGet)this.commit.operation()).value();
        }

        @Override
        public long version() {
            return this.version;
        }

        @Override
        public void discard() {
            this.commit.close();
        }
    }

    private static interface MapEntryValue {
        public byte[] value();

        public long version();

        public void discard();
    }
}

