/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Multiset;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.onlab.util.Match;
import org.onosproject.store.service.Versioned;

public final class AtomixConsistentMultimapCommands {
    private AtomixConsistentMultimapCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        public void resolve(SerializerRegistry registry) {
            registry.register(ContainsKey.class, -1000);
            registry.register(ContainsValue.class, -1001);
            registry.register(ContainsEntry.class, -1002);
            registry.register(Replace.class, -1003);
            registry.register(Clear.class, -1004);
            registry.register(KeySet.class, -1005);
            registry.register(Keys.class, -1006);
            registry.register(Values.class, -1007);
            registry.register(Entries.class, -1008);
            registry.register(Size.class, -1009);
            registry.register(IsEmpty.class, -1010);
            registry.register(Get.class, -1011);
            registry.register(Put.class, -1012);
            registry.register(RemoveAll.class, -1013);
            registry.register(MultiRemove.class, -1014);
        }
    }

    public static class Get
    extends KeyQuery<Versioned<Collection<? extends byte[]>>> {
        public Get() {
        }

        public Get(String key) {
            super(key);
        }
    }

    public static class Entries
    extends MultimapQuery<Collection<Map.Entry<String, byte[]>>> {
    }

    public static class Values
    extends MultimapQuery<Multiset<byte[]>> {
    }

    public static class Keys
    extends MultimapQuery<Multiset<String>> {
    }

    public static class KeySet
    extends MultimapQuery<Set<String>> {
    }

    public static class Clear
    extends MultimapCommand<Void> {
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.TOMBSTONE;
        }
    }

    public static class Replace
    extends MultimapCommand<Versioned<Collection<? extends byte[]>>> {
        private String key;
        private Collection<byte[]> values;
        private Match<Long> versionMatch;

        public Replace() {
        }

        public Replace(String key, Collection<byte[]> values, Match<Long> versionMatch) {
            this.key = (String)Assert.notNull((Object)key, (String)"key");
            this.values = values;
            this.versionMatch = versionMatch;
        }

        public String key() {
            return this.key;
        }

        public Match<Long> versionMatch() {
            return this.versionMatch;
        }

        public Collection<byte[]> values() {
            return this.values;
        }

        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.key, buffer);
            serializer.writeObject(this.values, buffer);
            serializer.writeObject(this.versionMatch, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = (String)serializer.readObject(buffer);
            this.values = (Collection)serializer.readObject(buffer);
            this.versionMatch = (Match)serializer.readObject(buffer);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key).add("values", this.values).add("versionMatch", this.versionMatch).toString();
        }
    }

    public static class Put
    extends MultimapCommand<Boolean> {
        private String key;
        private Collection<? extends byte[]> values;
        private Match<Long> versionMatch;

        public Put() {
        }

        public Put(String key, Collection<? extends byte[]> values, Match<Long> versionMatch) {
            this.key = (String)Assert.notNull((Object)key, (String)"key");
            this.values = values;
            this.versionMatch = versionMatch;
        }

        public String key() {
            return this.key;
        }

        public Collection<? extends byte[]> values() {
            return this.values;
        }

        public Match<Long> versionMatch() {
            return this.versionMatch;
        }

        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.key, buffer);
            serializer.writeObject(this.values, buffer);
            serializer.writeObject(this.versionMatch, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = (String)serializer.readObject(buffer);
            this.values = (Collection)serializer.readObject(buffer);
            this.versionMatch = (Match)serializer.readObject(buffer);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key).add("values", this.values).add("versionMatch", this.versionMatch).toString();
        }
    }

    public static class MultiRemove
    extends MultimapCommand<Boolean> {
        private String key;
        private Collection<byte[]> values;
        private Match<Long> versionMatch;

        public MultiRemove() {
        }

        public MultiRemove(String key, Collection<byte[]> valueMatches, Match<Long> versionMatch) {
            this.key = (String)Assert.notNull((Object)key, (String)"key");
            this.values = valueMatches;
            this.versionMatch = versionMatch;
        }

        public String key() {
            return this.key;
        }

        public Collection<byte[]> values() {
            return this.values;
        }

        public Match<Long> versionMatch() {
            return this.versionMatch;
        }

        public Command.CompactionMode compaction() {
            return Command.CompactionMode.TOMBSTONE;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.key, buffer);
            serializer.writeObject(this.values, buffer);
            serializer.writeObject(this.versionMatch, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = (String)serializer.readObject(buffer);
            this.values = (Collection)serializer.readObject(buffer);
            this.versionMatch = (Match)serializer.readObject(buffer);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key).add("values", this.values).add("versionMatch", this.versionMatch).toString();
        }
    }

    public static class RemoveAll
    extends MultimapCommand<Versioned<Collection<? extends byte[]>>> {
        private String key;
        private Match<Long> versionMatch;

        public RemoveAll() {
        }

        public RemoveAll(String key, Match<Long> versionMatch) {
            this.key = (String)Assert.notNull((Object)key, (String)"key");
            this.versionMatch = versionMatch;
        }

        public String key() {
            return this.key;
        }

        public Match<Long> versionMatch() {
            return this.versionMatch;
        }

        public Command.CompactionMode compaction() {
            return Command.CompactionMode.TOMBSTONE;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.key, buffer);
            serializer.writeObject(this.versionMatch, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = (String)serializer.readObject(buffer);
            this.versionMatch = (Match)serializer.readObject(buffer);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key).add("versionMatch", this.versionMatch).toString();
        }
    }

    public static class ContainsEntry
    extends MultimapQuery<Boolean> {
        protected String key;
        protected byte[] value;

        public ContainsEntry() {
        }

        public ContainsEntry(String key, byte[] value) {
            this.key = (String)Assert.notNull((Object)key, (String)"key");
            this.value = (byte[])Assert.notNull((Object)value, (String)"value");
        }

        public String key() {
            return this.key;
        }

        public byte[] value() {
            return this.value;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key).add("value", (Object)this.value).toString();
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.key, buffer);
            serializer.writeObject((Object)this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = (String)serializer.readObject(buffer);
            this.value = (byte[])serializer.readObject(buffer);
        }
    }

    public static class ContainsValue
    extends ValueQuery<Boolean> {
        public ContainsValue() {
        }

        public ContainsValue(byte[] value) {
            super(value);
        }
    }

    public static class ContainsKey
    extends KeyQuery<Boolean> {
        public ContainsKey() {
        }

        public ContainsKey(String key) {
            super(key);
        }
    }

    public static class IsEmpty
    extends MultimapQuery<Boolean> {
    }

    public static class Size
    extends MultimapQuery<Integer> {
    }

    public static abstract class ValueQuery<V>
    extends MultimapQuery<V> {
        protected byte[] value;

        public ValueQuery() {
        }

        public ValueQuery(byte[] value) {
            this.value = (byte[])Assert.notNull((Object)value, (String)"value");
        }

        public byte[] value() {
            return this.value;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", (Object)this.value).toString();
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = (byte[])serializer.readObject(buffer);
        }
    }

    public static abstract class KeyQuery<V>
    extends MultimapQuery<V> {
        protected String key;

        public KeyQuery() {
        }

        public KeyQuery(String key) {
            this.key = (String)Assert.notNull((Object)key, (String)"key");
        }

        public String key() {
            return this.key;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key).toString();
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject((Object)this.key, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = (String)serializer.readObject(buffer);
        }
    }

    public static abstract class MultimapQuery<V>
    implements Query<V>,
    CatalystSerializable {
        public Query.ConsistencyLevel consistency() {
            return Query.ConsistencyLevel.SEQUENTIAL;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    public static abstract class MultimapCommand<V>
    implements Command<V>,
    CatalystSerializable {
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).toString();
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

