/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncConsistentTreeMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;
import org.onosproject.store.service.Versioned;

public class ExecutingAsyncConsistentTreeMap<V>
extends ExecutingDistributedPrimitive
implements AsyncConsistentTreeMap<V> {
    private final AsyncConsistentTreeMap<V> delegateMap;

    public ExecutingAsyncConsistentTreeMap(AsyncConsistentTreeMap<V> delegateMap, Executor orderedExecutor, Executor threadPoolExecutor) {
        super((DistributedPrimitive)delegateMap, orderedExecutor, threadPoolExecutor);
        this.delegateMap = delegateMap;
    }

    public CompletableFuture<String> firstKey() {
        return this.asyncFuture(this.delegateMap.firstKey());
    }

    public CompletableFuture<String> lastKey() {
        return this.asyncFuture(this.delegateMap.lastKey());
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> ceilingEntry(String key) {
        return this.asyncFuture(this.delegateMap.ceilingEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> floorEntry(String key) {
        return this.asyncFuture(this.delegateMap.floorEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> higherEntry(String key) {
        return this.asyncFuture(this.delegateMap.higherEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> lowerEntry(String key) {
        return this.asyncFuture(this.delegateMap.lowerEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> firstEntry() {
        return this.asyncFuture(this.delegateMap.firstEntry());
    }

    public CompletableFuture<Integer> size() {
        return this.asyncFuture(this.delegateMap.size());
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> lastEntry() {
        return this.asyncFuture(this.delegateMap.lastEntry());
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> pollFirstEntry() {
        return this.asyncFuture(this.delegateMap.pollFirstEntry());
    }

    public CompletableFuture<Boolean> containsKey(String key) {
        return this.asyncFuture(this.delegateMap.containsKey((Object)key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> pollLastEntry() {
        return this.asyncFuture(this.delegateMap.pollLastEntry());
    }

    public CompletableFuture<String> lowerKey(String key) {
        return this.asyncFuture(this.delegateMap.lowerKey(key));
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return this.asyncFuture(this.delegateMap.containsValue(value));
    }

    public CompletableFuture<String> floorKey(String key) {
        return this.asyncFuture(this.delegateMap.floorKey(key));
    }

    public CompletableFuture<String> ceilingKey(String key) {
        return this.asyncFuture(this.delegateMap.ceilingKey(key));
    }

    public CompletableFuture<Versioned<V>> get(String key) {
        return this.asyncFuture(this.delegateMap.get((Object)key));
    }

    public CompletableFuture<Versioned<V>> getOrDefault(String key, V defaultValue) {
        return this.asyncFuture(this.delegateMap.getOrDefault((Object)key, defaultValue));
    }

    public CompletableFuture<String> higherKey(String key) {
        return this.asyncFuture(this.delegateMap.higherKey(key));
    }

    public CompletableFuture<NavigableSet<String>> navigableKeySet() {
        return this.asyncFuture(this.delegateMap.navigableKeySet());
    }

    public CompletableFuture<NavigableMap<String, V>> subMap(String upperKey, String lowerKey, boolean inclusiveUpper, boolean inclusiveLower) {
        return this.asyncFuture(this.delegateMap.subMap(upperKey, lowerKey, inclusiveUpper, inclusiveLower));
    }

    public CompletableFuture<Versioned<V>> computeIf(String key, Predicate<? super V> condition, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return this.asyncFuture(this.delegateMap.computeIf((Object)key, condition, remappingFunction));
    }

    public CompletableFuture<Versioned<V>> put(String key, V value) {
        return this.asyncFuture(this.delegateMap.put((Object)key, value));
    }

    public CompletableFuture<Versioned<V>> putAndGet(String key, V value) {
        return this.asyncFuture(this.delegateMap.putAndGet((Object)key, value));
    }

    public CompletableFuture<Versioned<V>> remove(String key) {
        return this.asyncFuture(this.delegateMap.remove((Object)key));
    }

    public CompletableFuture<Void> clear() {
        return this.asyncFuture(this.delegateMap.clear());
    }

    public CompletableFuture<Set<String>> keySet() {
        return this.asyncFuture(this.delegateMap.keySet());
    }

    public CompletableFuture<Collection<Versioned<V>>> values() {
        return this.asyncFuture(this.delegateMap.values());
    }

    public CompletableFuture<Set<Map.Entry<String, Versioned<V>>>> entrySet() {
        return this.asyncFuture(this.delegateMap.entrySet());
    }

    public CompletableFuture<Versioned<V>> putIfAbsent(String key, V value) {
        return this.asyncFuture(this.delegateMap.putIfAbsent((Object)key, value));
    }

    public CompletableFuture<Boolean> remove(String key, V value) {
        return this.asyncFuture(this.delegateMap.remove((Object)key, value));
    }

    public CompletableFuture<Boolean> remove(String key, long version) {
        return this.asyncFuture(this.delegateMap.remove((Object)key, version));
    }

    public CompletableFuture<Versioned<V>> replace(String key, V value) {
        return this.asyncFuture(this.delegateMap.replace((Object)key, value));
    }

    public CompletableFuture<Boolean> replace(String key, V oldValue, V newValue) {
        return this.asyncFuture(this.delegateMap.replace((Object)key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replace(String key, long oldVersion, V newValue) {
        return this.asyncFuture(this.delegateMap.replace((Object)key, oldVersion, newValue));
    }

    public CompletableFuture<Version> begin(TransactionId transactionId) {
        return this.asyncFuture(this.delegateMap.begin(transactionId));
    }

    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<String, V>> transactionLog) {
        return this.asyncFuture(this.delegateMap.prepare(transactionLog));
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return this.asyncFuture(this.delegateMap.commit(transactionId));
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return this.asyncFuture(this.delegateMap.rollback(transactionId));
    }

    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<MapUpdate<String, V>> transactionLog) {
        return this.asyncFuture(this.delegateMap.prepareAndCommit(transactionLog));
    }

    public CompletableFuture<Void> addListener(MapEventListener<String, V> listener) {
        return this.addListener(listener);
    }

    public CompletableFuture<Void> addListener(MapEventListener<String, V> listener, Executor executor) {
        return this.asyncFuture(this.delegateMap.addListener(listener, executor));
    }

    public CompletableFuture<Void> removeListener(MapEventListener<String, V> listener) {
        return this.asyncFuture(this.delegateMap.removeListener(listener));
    }
}

