/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Change;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.DistributedPrimitive;

public class ExecutingAsyncLeaderElector
extends ExecutingDistributedPrimitive
implements AsyncLeaderElector {
    private final AsyncLeaderElector delegateElector;
    private final Executor orderedExecutor;
    private final Map<Consumer<Change<Leadership>>, Consumer<Change<Leadership>>> listenerMap = Maps.newConcurrentMap();

    public ExecutingAsyncLeaderElector(AsyncLeaderElector delegateElector, Executor orderedExecutor, Executor threadPoolExecutor) {
        super((DistributedPrimitive)delegateElector, orderedExecutor, threadPoolExecutor);
        this.delegateElector = delegateElector;
        this.orderedExecutor = orderedExecutor;
    }

    public CompletableFuture<Leadership> run(String topic, NodeId nodeId) {
        return this.asyncFuture(this.delegateElector.run(topic, nodeId));
    }

    public CompletableFuture<Void> withdraw(String topic) {
        return this.asyncFuture(this.delegateElector.withdraw(topic));
    }

    public CompletableFuture<Boolean> anoint(String topic, NodeId nodeId) {
        return this.asyncFuture(this.delegateElector.anoint(topic, nodeId));
    }

    public CompletableFuture<Void> evict(NodeId nodeId) {
        return this.asyncFuture(this.delegateElector.evict(nodeId));
    }

    public CompletableFuture<Boolean> promote(String topic, NodeId nodeId) {
        return this.asyncFuture(this.delegateElector.promote(topic, nodeId));
    }

    public CompletableFuture<Leadership> getLeadership(String topic) {
        return this.asyncFuture(this.delegateElector.getLeadership(topic));
    }

    public CompletableFuture<Map<String, Leadership>> getLeaderships() {
        return this.asyncFuture(this.delegateElector.getLeaderships());
    }

    public CompletableFuture<Void> addChangeListener(Consumer<Change<Leadership>> listener) {
        Consumer<Change> wrappedListener = e -> this.orderedExecutor.execute(() -> listener.accept((Change<Leadership>)e));
        this.listenerMap.put(listener, wrappedListener);
        return this.asyncFuture(this.delegateElector.addChangeListener(wrappedListener));
    }

    public CompletableFuture<Void> removeChangeListener(Consumer<Change<Leadership>> listener) {
        Consumer<Change<Leadership>> wrappedListener = this.listenerMap.remove(listener);
        if (wrappedListener != null) {
            return this.asyncFuture(this.delegateElector.removeChangeListener(wrappedListener));
        }
        return CompletableFuture.completedFuture(null);
    }
}

