/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.onlab.util.Match;
import org.onlab.util.Tools;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.Hasher;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;
import org.onosproject.store.service.Versioned;

public class PartitionedAsyncConsistentMap<K, V>
implements AsyncConsistentMap<K, V> {
    private final String name;
    private final TreeMap<PartitionId, AsyncConsistentMap<K, V>> partitions = Maps.newTreeMap();
    private final Hasher<K> keyHasher;

    public PartitionedAsyncConsistentMap(String name, Map<PartitionId, AsyncConsistentMap<K, V>> partitions, Hasher<K> keyHasher) {
        this.name = name;
        this.partitions.putAll((Map)Preconditions.checkNotNull(partitions));
        this.keyHasher = (Hasher)Preconditions.checkNotNull(keyHasher);
    }

    public String name() {
        return this.name;
    }

    public CompletableFuture<Integer> size() {
        return Tools.allOf(this.getMaps().stream().map(m -> m.size()).collect(Collectors.toList()), Math::addExact, (Object)0);
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.size().thenApply(size -> size == 0);
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.getMap(key).containsKey(key);
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return Tools.firstOf(this.getMaps().stream().map(m -> m.containsValue(value)).collect(Collectors.toList()), (Match)Match.ifValue((Object)true), (Object)false);
    }

    public CompletableFuture<Versioned<V>> get(K key) {
        return this.getMap(key).get(key);
    }

    public CompletableFuture<Versioned<V>> getOrDefault(K key, V defaultValue) {
        return this.getMap(key).getOrDefault(key, defaultValue);
    }

    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.getMap(key).computeIf(key, condition, remappingFunction);
    }

    public CompletableFuture<Versioned<V>> put(K key, V value) {
        return this.getMap(key).put(key, value);
    }

    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        return this.getMap(key).putAndGet(key, value);
    }

    public CompletableFuture<Versioned<V>> remove(K key) {
        return this.getMap(key).remove(key);
    }

    public CompletableFuture<Void> clear() {
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(map -> map.clear()).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Set<K>> keySet() {
        return Tools.allOf(this.getMaps().stream().map(m -> m.keySet()).collect(Collectors.toList()), (s1, s2) -> ImmutableSet.builder().addAll((Iterable)s1).addAll((Iterable)s2).build(), (Object)ImmutableSet.of());
    }

    public CompletableFuture<Collection<Versioned<V>>> values() {
        return Tools.allOf(this.getMaps().stream().map(m -> m.values()).collect(Collectors.toList()), (c1, c2) -> ImmutableList.builder().addAll((Iterable)c1).addAll((Iterable)c2).build(), (Object)ImmutableList.of());
    }

    public CompletableFuture<Set<Map.Entry<K, Versioned<V>>>> entrySet() {
        return Tools.allOf(this.getMaps().stream().map(m -> m.entrySet()).collect(Collectors.toList()), (s1, s2) -> ImmutableSet.builder().addAll((Iterable)s1).addAll((Iterable)s2).build(), (Object)ImmutableSet.of());
    }

    public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
        return this.getMap(key).putIfAbsent(key, value);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.getMap(key).remove(key, value);
    }

    public CompletableFuture<Boolean> remove(K key, long version) {
        return this.getMap(key).remove(key, version);
    }

    public CompletableFuture<Versioned<V>> replace(K key, V value) {
        return this.getMap(key).replace(key, value);
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.getMap(key).replace(key, oldValue, newValue);
    }

    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        return this.getMap(key).replace(key, oldVersion, newValue);
    }

    public CompletableFuture<Void> addListener(MapEventListener<K, V> listener, Executor executor) {
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(map -> map.addListener(listener, executor)).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Void> removeListener(MapEventListener<K, V> listener) {
        return CompletableFuture.allOf((CompletableFuture[])this.getMaps().stream().map(map -> map.removeListener(listener)).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Version> begin(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<K, V>> transactionLog) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<MapUpdate<K, V>> transactionLog) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.partitions.values().forEach(map -> map.addStatusChangeListener(listener));
    }

    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.partitions.values().forEach(map -> map.removeStatusChangeListener(listener));
    }

    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        throw new UnsupportedOperationException();
    }

    private AsyncConsistentMap<K, V> getMap(K key) {
        return this.partitions.get(this.keyHasher.hash(key));
    }

    private Collection<AsyncConsistentMap<K, V>> getMaps() {
        return this.partitions.values();
    }
}

