/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.resource.ResourceType;
import java.io.File;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.cluster.messaging.MessagingService;
import org.onosproject.store.primitives.impl.CopycatTransport;
import org.onosproject.store.primitives.impl.Managed;
import org.onosproject.store.primitives.impl.StoragePartitionClient;
import org.onosproject.store.primitives.impl.StoragePartitionServer;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMap;
import org.onosproject.store.primitives.resources.impl.AtomixLeaderElector;
import org.onosproject.store.service.PartitionInfo;

public class StoragePartition
implements Managed<StoragePartition> {
    private final AtomicBoolean isOpened = new AtomicBoolean(false);
    private final Serializer serializer;
    private final Executor sharedExecutor;
    private final MessagingService messagingService;
    private final ClusterService clusterService;
    private final File logFolder;
    private Partition partition;
    private NodeId localNodeId;
    private StoragePartitionServer server;
    private StoragePartitionClient client;
    public static final Collection<ResourceType> RESOURCE_TYPES = ImmutableSet.of((Object)new ResourceType(AtomixLeaderElector.class), (Object)new ResourceType(AtomixConsistentMap.class));

    public StoragePartition(Partition partition, MessagingService messagingService, ClusterService clusterService, Serializer serializer, Executor sharedExecutor, File logFolder) {
        this.partition = partition;
        this.messagingService = messagingService;
        this.clusterService = clusterService;
        this.localNodeId = clusterService.getLocalNode().id();
        this.serializer = serializer;
        this.sharedExecutor = sharedExecutor;
        this.logFolder = logFolder;
    }

    public StoragePartitionClient client() {
        return this.client;
    }

    @Override
    public CompletableFuture<Void> open() {
        if (this.partition.getMembers().contains(this.localNodeId)) {
            this.openServer();
        }
        return ((CompletableFuture)this.openClient().thenAccept(v -> this.isOpened.set(true))).thenApply(v -> null);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.closeClient();
    }

    public PartitionId getId() {
        return this.partition.getId();
    }

    public Collection<NodeId> getMembers() {
        return this.partition.getMembers();
    }

    public Collection<Address> getMemberAddresses() {
        return Collections2.transform((Collection)this.partition.getMembers(), this::toAddress);
    }

    private CompletableFuture<Void> openServer() {
        if (!this.partition.getMembers().contains(this.localNodeId) || this.server != null) {
            return CompletableFuture.completedFuture(null);
        }
        StoragePartitionServer server = new StoragePartitionServer(this.toAddress(this.localNodeId), this, this.serializer, () -> new CopycatTransport(this.partition.getId(), this.messagingService), this.logFolder);
        return server.open().thenRun(() -> {
            this.server = server;
        });
    }

    private CompletableFuture<Void> joinCluster() {
        Set otherMembers = this.partition.getMembers().stream().filter(nodeId -> !nodeId.equals((Object)this.localNodeId)).collect(Collectors.toSet());
        StoragePartitionServer server = new StoragePartitionServer(this.toAddress(this.localNodeId), this, this.serializer, () -> new CopycatTransport(this.partition.getId(), this.messagingService), this.logFolder);
        return server.join(Collections2.transform(otherMembers, this::toAddress)).thenRun(() -> {
            this.server = server;
        });
    }

    private CompletableFuture<StoragePartitionClient> openClient() {
        this.client = new StoragePartitionClient(this, this.serializer, new CopycatTransport(this.partition.getId(), this.messagingService), this.sharedExecutor);
        return this.client.open().thenApply(v -> this.client);
    }

    public CompletableFuture<Void> leaveCluster() {
        return this.server != null ? this.server.closeAndExit() : CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isOpen() {
        return this.isOpened.get();
    }

    private CompletableFuture<Void> closeClient() {
        if (this.client != null) {
            return this.client.close();
        }
        return CompletableFuture.completedFuture(null);
    }

    private Address toAddress(NodeId nodeId) {
        ControllerNode node = this.clusterService.getNode(nodeId);
        return new Address(node.ip().toString(), node.tcpPort());
    }

    public Optional<PartitionInfo> info() {
        return this.server != null && this.server.isOpen() ? Optional.of(this.server.info()) : Optional.empty();
    }

    public void onUpdate(Partition newValue) {
        boolean wasPresent = this.partition.getMembers().contains(this.localNodeId);
        boolean isPresent = newValue.getMembers().contains(this.localNodeId);
        this.partition = newValue;
        if (wasPresent && isPresent || !wasPresent && !isPresent) {
            return;
        }
        if (wasPresent) {
            this.leaveCluster();
        } else if (isPresent) {
            this.joinCluster();
        }
    }
}

