/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.AsyncConsistentTreeMap;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;
import org.onosproject.store.service.Versioned;

public class TranscodingAsyncConsistentTreeMap<V1, V2>
implements AsyncConsistentTreeMap<V1> {
    private final AsyncConsistentTreeMap<V2> backingMap;
    private final Function<V2, V1> valueDecoder;
    private final Function<V1, V2> valueEncoder;
    private final Function<Versioned<V2>, Versioned<V1>> versionedValueTransform;
    private final Map<MapEventListener<String, V1>, InternalBackingMapEventListener> listeners = Maps.newIdentityHashMap();

    public TranscodingAsyncConsistentTreeMap(AsyncConsistentTreeMap<V2> backingMap, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        this.backingMap = backingMap;
        this.valueEncoder = v -> v == null ? null : valueEncoder.apply(v);
        this.valueDecoder = v -> v == null ? null : valueDecoder.apply(v);
        this.versionedValueTransform = v -> v == null ? null : v.map(valueDecoder);
    }

    public CompletableFuture<String> firstKey() {
        return this.backingMap.firstKey();
    }

    public CompletableFuture<String> lastKey() {
        return this.backingMap.lastKey();
    }

    public CompletableFuture<Map.Entry<String, Versioned<V1>>> ceilingEntry(String key) {
        return this.backingMap.ceilingEntry(key).thenApply(entry -> Maps.immutableEntry(entry.getKey(), this.versionedValueTransform.apply((Versioned<V2>)entry.getValue())));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V1>>> floorEntry(String key) {
        return this.backingMap.floorEntry(key).thenApply(entry -> Maps.immutableEntry(entry.getKey(), this.versionedValueTransform.apply((Versioned<V2>)entry.getValue())));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V1>>> higherEntry(String key) {
        return this.backingMap.higherEntry(key).thenApply(entry -> Maps.immutableEntry(entry.getKey(), this.versionedValueTransform.apply((Versioned<V2>)entry.getValue())));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V1>>> lowerEntry(String key) {
        return this.backingMap.lowerEntry(key).thenApply(entry -> Maps.immutableEntry(entry.getKey(), this.versionedValueTransform.apply((Versioned<V2>)entry.getValue())));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V1>>> firstEntry() {
        return this.backingMap.firstEntry().thenApply(entry -> Maps.immutableEntry(entry.getKey(), this.versionedValueTransform.apply((Versioned<V2>)entry.getValue())));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V1>>> lastEntry() {
        return this.backingMap.lastEntry().thenApply(entry -> Maps.immutableEntry(entry.getKey(), this.versionedValueTransform.apply((Versioned<V2>)entry.getValue())));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V1>>> pollFirstEntry() {
        return this.backingMap.pollFirstEntry().thenApply(entry -> Maps.immutableEntry(entry.getKey(), this.versionedValueTransform.apply((Versioned<V2>)entry.getValue())));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V1>>> pollLastEntry() {
        return this.backingMap.pollLastEntry().thenApply(entry -> Maps.immutableEntry(entry.getKey(), this.versionedValueTransform.apply((Versioned<V2>)entry.getValue())));
    }

    public CompletableFuture<String> lowerKey(String key) {
        return this.backingMap.lowerKey(key);
    }

    public CompletableFuture<String> floorKey(String key) {
        return this.backingMap.floorKey(key);
    }

    public CompletableFuture<String> ceilingKey(String key) {
        return this.backingMap.ceilingKey(key);
    }

    public CompletableFuture<String> higherKey(String key) {
        return this.backingMap.higherKey(key);
    }

    public CompletableFuture<NavigableSet<String>> navigableKeySet() {
        return this.backingMap.navigableKeySet();
    }

    public CompletableFuture<NavigableMap<String, V1>> subMap(String upperKey, String lowerKey, boolean inclusiveUpper, boolean inclusiveLower) {
        throw new UnsupportedOperationException("This operation is not yetsupported.");
    }

    public String name() {
        return this.backingMap.name();
    }

    public CompletableFuture<Integer> size() {
        return this.backingMap.size();
    }

    public CompletableFuture<Boolean> containsKey(String key) {
        return this.backingMap.containsKey((Object)key);
    }

    public CompletableFuture<Boolean> containsValue(V1 value) {
        return this.backingMap.containsValue(this.valueEncoder.apply(value));
    }

    public CompletableFuture<Versioned<V1>> get(String key) {
        return this.backingMap.get((Object)key).thenApply(this.versionedValueTransform);
    }

    public CompletableFuture<Versioned<V1>> getOrDefault(String key, V1 defaultValue) {
        return this.backingMap.getOrDefault((Object)key, this.valueEncoder.apply(defaultValue)).thenApply(this.versionedValueTransform);
    }

    public CompletableFuture<Versioned<V1>> computeIf(String key, Predicate<? super V1> condition, BiFunction<? super String, ? super V1, ? extends V1> remappingFunction) {
        try {
            return this.backingMap.computeIf((Object)key, v -> condition.test((V1)this.valueDecoder.apply(v)), (k, v) -> this.valueEncoder.apply(remappingFunction.apply(key, (V1)this.valueDecoder.apply(v)))).thenApply(this.versionedValueTransform);
        }
        catch (Exception e) {
            return Tools.exceptionalFuture((Throwable)e);
        }
    }

    public CompletableFuture<Versioned<V1>> put(String key, V1 value) {
        return this.backingMap.put((Object)key, this.valueEncoder.apply(value)).thenApply(this.versionedValueTransform);
    }

    public CompletableFuture<Versioned<V1>> putAndGet(String key, V1 value) {
        return this.backingMap.putAndGet((Object)key, this.valueEncoder.apply(value)).thenApply(this.versionedValueTransform);
    }

    public CompletableFuture<Versioned<V1>> remove(String key) {
        return this.backingMap.remove((Object)key).thenApply(this.versionedValueTransform);
    }

    public CompletableFuture<Void> clear() {
        return this.backingMap.clear();
    }

    public CompletableFuture<Set<String>> keySet() {
        return this.backingMap.keySet();
    }

    public CompletableFuture<Collection<Versioned<V1>>> values() {
        return this.backingMap.values().thenApply(valueSet -> valueSet.stream().map(this.versionedValueTransform).collect(Collectors.toSet()));
    }

    public CompletableFuture<Set<Map.Entry<String, Versioned<V1>>>> entrySet() {
        return this.backingMap.entrySet().thenApply(entries -> entries.stream().map(entry -> Maps.immutableEntry(entry.getKey(), this.versionedValueTransform.apply((Versioned<V2>)entry.getValue()))).collect(Collectors.toSet()));
    }

    public CompletableFuture<Versioned<V1>> putIfAbsent(String key, V1 value) {
        return this.backingMap.putIfAbsent((Object)key, this.valueEncoder.apply(value)).thenApply(this.versionedValueTransform);
    }

    public CompletableFuture<Boolean> remove(String key, V1 value) {
        return this.backingMap.remove((Object)key, this.valueEncoder.apply(value));
    }

    public CompletableFuture<Boolean> remove(String key, long version) {
        return this.backingMap.remove((Object)key, version);
    }

    public CompletableFuture<Versioned<V1>> replace(String key, V1 value) {
        return this.backingMap.replace((Object)key, this.valueEncoder.apply(value)).thenApply(this.versionedValueTransform);
    }

    public CompletableFuture<Boolean> replace(String key, V1 oldValue, V1 newValue) {
        return this.backingMap.replace((Object)key, this.valueEncoder.apply(oldValue), this.valueEncoder.apply(newValue));
    }

    public CompletableFuture<Boolean> replace(String key, long oldVersion, V1 newValue) {
        return this.backingMap.replace((Object)key, oldVersion, this.valueEncoder.apply(newValue));
    }

    public CompletableFuture<Void> addListener(MapEventListener<String, V1> listener, Executor executor) {
        InternalBackingMapEventListener backingMapEventListener = this.listeners.computeIfAbsent(listener, k -> new InternalBackingMapEventListener(listener));
        return this.backingMap.addListener((MapEventListener)backingMapEventListener, executor);
    }

    public CompletableFuture<Void> removeListener(MapEventListener<String, V1> listener) {
        InternalBackingMapEventListener backingMapEventListener = this.listeners.remove(listener);
        if (backingMapEventListener == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.backingMap.removeListener((MapEventListener)backingMapEventListener);
    }

    public CompletableFuture<Version> begin(TransactionId transactionId) {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<String, V1>> transactionLog) {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<MapUpdate<String, V1>> transactionLog) {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    private class InternalBackingMapEventListener
    implements MapEventListener<String, V2> {
        private final MapEventListener<String, V1> listener;

        InternalBackingMapEventListener(MapEventListener<String, V1> listener) {
            this.listener = listener;
        }

        public void event(MapEvent<String, V2> event) {
            this.listener.event(new MapEvent(event.name(), event.key(), event.newValue() != null ? event.newValue().map(TranscodingAsyncConsistentTreeMap.this.valueDecoder) : null, event.oldValue() != null ? event.oldValue().map(TranscodingAsyncConsistentTreeMap.this.valueDecoder) : null));
        }
    }
}

